 /*
  * Khoros: $Id: mtrans.c,v 1.2 1992/03/20 23:43:54 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mtrans.c,v 1.2 1992/03/20 23:43:54 dkhoros Exp $";
#endif

 /*
  * $Log: mtrans.c,v $
 * Revision 1.2  1992/03/20  23:43:54  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mtrans.c
 >>>>
 >>>>      Program Name: mtrans
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	mtrans - transposes a matrix.
 >>>>	
 >>>>	

 >>>>            Author: Matthew Lawrence, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:55:50 1992
 >>>>
 >>>>          Routines: main- the main program for mtrans
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "mtrans.h"


/****************************************************************
 *
 * Routine Name:  main program for mtrans
 *
 *       Input:  
 *        -i  input matrix 
 *        -o  resulting output matrix 
 *
 *
 *        [-c]  Generate Conjugate (0 = no, 1 = yes)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(mtrans->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmtrans(image,mtrans->c_logic)){
     (void)fprintf(stderr,"%s:  failed call to lmtrans.\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
     if(!(writeimage(mtrans->o_file,image))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for mtrans 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "mtrans :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tmtrans - transposes a matrix.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input matrix  (infile)\n");
	fprintf(stderr,"\t-o  resulting output matrix  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-c]   Generate Conjugate (0 = no, 1 = yes) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for mtrans\n");
	fprintf(stderr, "\t[-U] Gives the usage for mtrans\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called mtrans.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses mtrans.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for mtrans
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input matrix \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output matrix \n        {outfile}: "; 
char	*c_pstr = 
	"\nEnter: (c)  Generate Conjugate (0 = no, 1 = yes) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "mtrans", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "mtrans.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "mtrans: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "mtrans.ans");
		}

	     }

	}

	/*
	 * allocate the mtrans structure
	 */
	mtrans = (mtrans_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (mtrans_struct));

	/*
	 * get required arguments for mtrans
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(mtrans->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(mtrans->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mtrans->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    mtrans->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(mtrans->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mtrans->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(mtrans->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mtrans->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    mtrans->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(mtrans->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for mtrans
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	mtrans->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(mtrans->c_logic), 0);


}



