 /*
  * Khoros: $Id: mlud.c,v 1.2 1992/03/20 23:45:09 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mlud.c,v 1.2 1992/03/20 23:45:09 dkhoros Exp $";
#endif

 /*
  * $Log: mlud.c,v $
 * Revision 1.2  1992/03/20  23:45:09  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mlud.c
 >>>>
 >>>>      Program Name: mlud
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	compute the LU decomposition of a matrix
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:57:43 1992
 >>>>
 >>>>          Routines: main- the main program for mlud
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "mlud.h"


/****************************************************************
 *
 * Routine Name:  main program for mlud
 *
 *       Input:  
 *      -i  input image (matrix) 
 *
 *
 *      [-o1] resulting lower diagonal output matrix (image)
 *      [-o2] resulting upper diagonal output matrix (image)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*uimage,*createimage();
int     type;
char    *comment = "no comment...";
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(mlud->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image,1,TRUE);

  if(image->row_size<=0 || image->col_size<=0){
     (void)fprintf(stderr,"%s:  matrix dimensions cannot be zero.\n",program);
     exit(1);
  }

/*
** create the images
*/

      uimage = createimage(0,0,image->data_storage_type,1,1,comment,
                           (unsigned long)0, /* map_row_size */
                           (unsigned long)0, /* map_col_size */
                           (unsigned long)VFF_MS_NONE,
                           (unsigned long)VFF_MAPTYP_NONE,
                           (unsigned long)VFF_LOC_IMPLICIT,
                           (unsigned long)0);/* location dimension */

/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmlud(image,uimage)) {
     (void)fprintf(stderr, "%s: lmlud failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  if(mlud->o1_flag){
     if(!(writeimage(mlud->o1_file,image))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()",
              program);
        exit(1);
     }
  }
  if(mlud->o2_flag){
     if(!(writeimage(mlud->o2_file,uimage))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()",
              program);
        exit(1);
     }
  }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for mlud 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "mlud :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tcompute the LU decomposition of a matrix\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image (matrix)  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  resulting lower diagonal output matrix (image) (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  resulting upper diagonal output matrix (image) (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for mlud\n");
	fprintf(stderr, "\t[-U] Gives the usage for mlud\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called mlud.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses mlud.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for mlud
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image (matrix) \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) resulting lower diagonal output matrix (image) \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) resulting upper diagonal output matrix (image) \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "mlud", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "mlud.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "mlud: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "mlud.ans");
		}

	     }

	}

	/*
	 * allocate the mlud structure
	 */
	mlud = (mlud_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (mlud_struct));

	/*
	 * get required arguments for mlud
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(mlud->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(mlud->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mlud->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    mlud->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(mlud->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for mlud
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	mlud->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(mlud->o1_file))
;

	mlud->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(mlud->o2_file))
;


}



