 /*
  * Khoros: $Id: vgparmi.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgparmi.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: vgparmi.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Get Integer Parameter 

	source filename:			vgparmi.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		May-1-85		don hush

******************************************************************

usage :
	vgparmi(ifd,key,prompt,iarg,imax,imin,ierr)

	int ifd,*iarg,imax,imin,*ierr ;
	character *key,*prompt ;

description :
  This routine fetches a integer parameter from either the
command line , an answer file , or the user (interactively).
The answer file must be opened prior to	calling this routine.
If no answer file is present then ifd should be passed as an
illegal (negative) file descriptor. The command line is searched
first, then the answer file (if one has been opened).
If a parameter is not found to	match the key on the command
line or in the answer file , the user is prompted interactively
for the parameter. If prompt = "noprompt" when no match 
is found then the query	to the user is suppressed and
a default parameter value is returned (assumed 0)
with an error flag of -1. The parameter is checked to insure
that it is within the specified bounds (imin,imax). If
it does not fall within the bounds the user is prompted
for a different value.

argument descriptions :

	ifd -	C file descriptor for the answer file ;
		If there is no answer file ifd should be
		passed as an invalid (negative) file descriptor

	key -	search key used to locate the parameter ;
		It must begin with a '-' and be the first thing
		to appear in the line in the answer file (no 
		leading spaces).
		A maximum of 1 character can follow the '-'
		to make up the key.  Case distinctions are made
		when parsing the key , so upper and lower case
		letters are not treated the same.

	prompt - prompt used to query the user if no match
		is found for the key. If prompt = "noprompt"
		then the query is suppressed and a default
		value for the parameter is returned with
		an error code of -1 .

	imax -	maximum allowable value of the parameter (1)

	imin -	minimum allowable value of the parameter (1)

	iarg - 	argument (parameter) value 

	ierr -	error flag for this routine
		 0 means returned value is O.K.
		-1 means that this routine was unable to get a 
		   valid parameter
		Note: -1 can occur only when prompt = "noprompt" 
		      otherwise it has to return with a valid
		      parameter value
1. if imin == imax then no bounds checking is done

******************************************************************/

#include "vgparm.h"

extern int first_time,make;
extern char make_name[];


vgparmi(ifd,key,prompt,iarg,imax,imin,ierr)

int ifd,*iarg,imax,imin,*ierr;
char *key,*prompt;

{
    int i;
    char b_prompt[MAX_LINE_LEN];

    int	clc_err = 0, afile_err = 0, user_err = 0;

    if (first_time) {
	first_time = FALSE;
	make = init_makec();
    }

    if ( strcmp(key,"nokey") == 0 )
	*ierr = get_arg_user(prompt,iarg,'i');
    else {
        if ( (clc_err = *ierr=get_arg_clc(key,iarg,'i')) == -1 ) 
	    if ( (afile_err = *ierr=get_arg_afile(ifd,key,iarg,'i')) == -1 ) 
	        if ( (user_err = *ierr=get_arg_user(prompt,iarg,'i')) == -1 ) 
		    return;
    }

	                 /* if there is an error for input don't check
			  * bounds
			  */
    if (clc_err == -2 || afile_err == -2 || user_err == -2)
        *ierr = -1;

    while ( (i=check_bounds_int(*iarg,imax,imin)) != 0 ) {

        if (*ierr == -1)	/* no error checking stuff */
	    break;

	switch (i) {

	    case -3 :
		if (strcmp(prompt,"noprompt")!=0)
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value < 0\n%s ",prompt);
		else
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value < 0\nKey = %s\nPlease re-enter value --> ",key);
		*ierr = get_arg_user(b_prompt,iarg,'i');
		break;

	    case -2 :
		if (strcmp(prompt,"noprompt")!=0)
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value <= 0\n%s ",prompt);
		else
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value <= 0\nKey = %s\nPlease re-enter value --> ",key);
		*ierr = get_arg_user(b_prompt,iarg,'i');
		break;

	    case -1 :
		if (strcmp(prompt,"noprompt")!=0)
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
max = %d min = %d\n%s ",imax,imin,prompt);
		else
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
max = %d min = %d\nKey = %s\nPlease re-enter value --> ",imax,imin,key);
		*ierr = get_arg_user(b_prompt,iarg,'i');
		break;

	    case 1 :
		if (strcmp(prompt,"noprompt")!=0)
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value >= 0\n%s ",prompt);
		else
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value >= 0\nKey = %s\nPlease re-enter value --> ",key);
		*ierr = get_arg_user(b_prompt,iarg,'i');
		break;

	    case 2 :
		if (strcmp(prompt,"noprompt")!=0)
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value > 0\n%s ",prompt);
		else
		    sprintf(b_prompt,"ERROR - Parameter Out of Bounds\n\
looking for a value > 0\nKey = %s\nPlease re-enter value --> ",key);
		*ierr = get_arg_user(b_prompt,iarg,'i');
		break;
	}
    }



    if ( strcmp(key,"nokey") != 0 )
        if ((*ierr==0)&&(make))
	    put_line(key,iarg,'i');

}
