/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vblurlace.h
 >>>>            Author: Donna Koechner, John Rasure
 >>>> Date Last Updated: Mon Apr 15 22:13:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vblurlace_h_
#define _vblurlace_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vblurlace Argument Structure
*
****************************************************************/

typedef struct _vblurlace  {

/*
 *  input interlace image (Required infile)
 */
char	*i_file;	/* input interlace image FILENAME */
int	 i_flag;	/* input interlace image FLAG */

/*
 *  correct output image (Required outfile)
 */
char	*o_file;	/* correct output image FILENAME */
int	 o_flag;	/* correct output image FLAG */

/*
 *  number of pixels to shift (Optional integer)
 */
int	 s_int; 	/* number of pixels to shift INT */
int	 s_flag;	/* number of pixels to shift FLAG */

}  vblurlace_struct;

vblurlace_struct *vblurlace;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vblurlace->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vblurlace: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_dim(program,image,0,TRUE); \
        \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE); \
        \
        (void) propertype(program, image, VFF_TYP_1_BYTE, FALSE)


/* -include_macros_end */

#endif
