'\"t
.if t .TH IMFILE 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMFILE 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
imfile  -  Discern the image format of a file(s)
.SH SYNOPSIS
\fBimfile\fR [\fIoptions\fR] \fIfilename1 filename2 ...\fR
.SH DESCRIPTION
\fBimfile\fR attempts to discern the image format of each 
file listed on the command line, much like the UNIX \fBfile\fR(1) utility.
\fBimfile\fR outputs the name of the file and its image file format to 
\fBstdout\fR.
.SH OPTIONS
Invoke \fBimfile\fR with one or more filenames, optionally
preceded by the \fB-infile\fR argument:
.RS +0.5i
.sp 1
.nf
\fBimfile -infile picture.pix newpic.ras\fR
    or
\fBimfile picture.pix newpic.ras\fR
.fi
.RE
.LP
\fBimfile\fR also recognizes the following standard SDSC options:
.LP
\fB-feedback\fR
.RS +0.5i
Create a software feedback (bug report) form in the file \fBimfile\fB.fbk.0\fR.
.RE
.LP
\fB-fullhelp\fR
.RS +0.5i
Display a detailed list of the arguments and how to use \fBimfile\fR.
.RE
.LP
\fB-help\fR
.RS +0.5i
Display an abbreviated list of the arguments and how to use \fBimfile\fR.
.RE
.LP
\fB-register\fR
.RS +0.5i
Create a software user registration form in the file \fBimfile\fB.reg.0\fR.
.RE
.LP
\fB-version\fR
.RS +0.5i
Display the version number and copyright for \fBimfile\fR.
.RE
.LP
All options can be abbreviated to the first few unique characters.
.SH NOTES
\fBimfile\fR discerns the type of a file first by checking the file's magic
number against a magic number list for known image formats.
If the magic number doesn't match any of those in the list, \fBimfile\fR
looks at the filename's suffix (the characters following the last
period in the filename) and checks it against a list of known image filename
suffixes.
.LP
If \fBimfile\fR cannot determine the format of a file, it outputs the
string "Unknown image file format."
.SH EXAMPLES
Discern the types of three files:
.RS 0.5i
.LP
\fBimfile thing1.pix thing2.hdf dr.who\fR
.RE
.LP
The above command outputs:
.RS 0.5i
.LP
.nf
thing1.pix:	'pix', Alias image file, Alias Research, Inc.
thing2.hdf:	'hdf', Hierarchical Data File, NCSA
dr.who:		Unknown image file format
.sp
.fi
.RE
.SH "SEE ALSO"
\fBimconv\fR(1IM), \fBimcopy\fR(1IM), \fBimflip\fR(1IM), \fBimformats\fR(1IM),
\fBimgray\fR(1IM), \fBimmono\fR(1IM), \fBimpaste\fR(1IM), \fBimscale\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR 
.br
