'\"et
.if t .TH IMGRAY 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMGRAY 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
imgray  -  Convert an image to grayscale
.SH SYNOPSIS
\fBimgray\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimgray\fR converts an input image to grayscale, then writes
it to an output image file.  If the input file contains multiple images,
\fBimgray\fR converts each one and writes it to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimgray\fR has a variety of options in the following four categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.SH NOTES
Conversion from color to grayscale computes the gray value for each pixel
using the NTSC Y equation:
.sp 1
.ce
.EQ
Gray ~~=~~ 0.30*R ~+~ 0.59*G ~+~ 0.11*B
.EN
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To convert an RGB Alias \fBpix\fR file image to grayscale and store it
in an \fBhdf\fR file, enter any of the following command lines:
.RS 0.5i
.LP
.nf
\fBimgray picture.pix picture.hdf\fR
    or
\fBimgray -pix picture.pix -hdf picture.hdf\fR
    or
\fBimgray -pix - picture.hdf < picture.pix\fR
    or
\fBimgray -pix picture.pix -hdf - > picture.hdf\fR
    or
\fBimgray -pix - -hdf - < picture.pix > picture.hdf\fR
    or
\fBcat picture.pix | imgray -pix - -hdf - | cat > picture.hdf\fR
.fi
.RE
.SH "SEE ALSO"
\fBimconv\fR(1IM), fBimcopy\fR(1IM), \fBimfile\fR(1IM), \fBimflip\fR(1IM),
\fBimformats\fR(1IM),
\fBimmono\fR(1IM), \fBimscale\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
