/*--------------------------------------------------------------*/
/*	Regis Driver 1.0 (TURBO  C) , for GLE V3.0		*/
/*--------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
int ingraphmode;
extern struct gmodel g;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
#define BLACKANDWHITE 1
#define ESC 27
#define false 0
#define dbg if ((gle_debug & 64)>0)
#define stop if ((gle_debug & 128)>0) return
extern int gle_debug;
int incap=true;
int getch(void);
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

int i,l,j,ix,iy;
double f;


#define gerr() i = graphresult(); if (i!=0) printf("Graph error: %s \n",grapherrormsg(i));
#define xsizecm 21.0
#define ysizecm 18.0
#define sx(v) ( (int) ((v) * d_xscale))
#define sy(v) ( d_maxy - ((int) ((v) * d_yscale)))
#define rx(v) ( (int) ((v) * d_xscale))
#define ry(v) ( d_maxy - ((int) ((v) * d_yscale)))

double d_scale, d_xscale, d_yscale;
int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth;
int d_maxy;

d_devcmd(char *s)
{}
dxy(double x, double y, int *dx, int *dy)
{
	static double fx,fy;
	g_dev(x,y,&fx,&fy);
	*dx = sx(fx);
	*dy = sy(fy);
}
rxy(double x, double y, int *dx, int *dy)
{
	static double fx,fy,zx,zy;
	g_dev(x,y,&fx,&fy);
	g_dev(0.0,0.0,&zx,&zy);
	*dx = (int) ( (fx-zx) * d_xscale);
	*dy = (int) ( (fy-zy) * d_yscale);
}
/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts */
}
/*---------------------------------------------------------------------------*/
static char lastline[80];
d_message(char *s)
{
	static int single_step;
	int oldcolor,oldx,oldy;
	if (ingraphmode) {
		textmode();
		printf("%s\n",s);
		graphmode();
	} else {
		w_message(s);
	}
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"INTERACTIVE, REGIS, VAX");
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{}
/*---------------------------------------------------------------------------*/
d_newpath()
{
}
/*---------------------------------------------------------------------------*/
d_open(double width, double height)
{

	graphmode();
	ingraphmode = true;

	/* Get largest rectangle we can fit on the screen */
	d_scale = xsizecm / width;
	f = ysizecm / height;
	if (f<d_scale) d_scale = f;

	d_xscale = d_scale * getmaxx() / xsizecm; /* Device Scale X, Device Scale y */
	d_yscale = d_scale * (getmaxy()-20) / ysizecm;
	d_maxy = getmaxy()-20;
	g.userwidth = width;
	g.userheight = height;
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
	textmode();
}
d_close()
{

	g_flush();
	textmode();
	d_message("Press <RETURN> to continue");
	text_inkey();
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	d_lstyle = 2;
	if (strcmp(s,"")==0) d_lstyle = 1;
	if (strcmp(s,"1")==0) d_lstyle = 1;
	printf("W(P%d);\n",d_lstyle);
}
/*---------------------------------------------------------------------------*/
d_fill()
{
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*	fprintf(psfile,"%g %g moveto \n",(*wkx)[0],(*wky)[0]);
	for (i=1;i<nwk;i++)
		fprintf(psfile,"%g %g l \n",(*wkx)[i],(*wky)[i]);
*/
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*
	dxy( (*wkx)[0], (*wky)[0], &ix, &iy);
	moveto(ix,iy);
	for (i=1;i<nwk;i++) {
		dxy( (*wkx)[i], (*wky)[i], &ix, &iy);
		lineto(ix,iy);
	}
*/
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{
}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse() 	/* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	g_line(g.closex,g.closey);
}
/*---------------------------------------------------------------------------*/
d_line(double zx,double zy)
{
	static int ux,uy;
	if (g.xinline==false) {
		dxy(g.curx,g.cury,&ux,&uy);
		printf("P[%d,%d]",ux,uy);
	}
	dxy(zx,zy,&ix,&iy);
	printf("V[%d,%d];\n",ix,iy);
}
/*---------------------------------------------------------------------------*/
d_clear()
{
	double width,height;
	int x1,y1,x2,y2;
	width = g.userwidth;
	height = g.userheight;
	/* now draw bounding box of screen */
	x1 = 0;
	y1 = d_maxy-height*d_yscale;
	x2 = width*d_xscale;
	y2 = d_maxy;
 	printf("F(W(I15)V[%d,%d][%d,%d][%d,%d][%d,%d][%d,%d])"
		,x1,y1,x2,y1,x2,y2,x1,y2,x1,y1);
	printf("W(I0)W(R)");
}
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static int ixr,iyr,icx,icy,ixs,iys;
	double ux,uy,z,xs,ys;

	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	polar_xy(r,t1,&xs,&ys);
	rxy(xs,ys,&ixs,&iys);

	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	printf("P[%d,%d]C(A%d)[%d,%d]\n",icx,icy,(int) t2-t1,ixs,iys);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static int ixr,iyr,icx,icy,ixs,iys;
	double ux,uy,z,xs,ys;

	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	polar_xy(r,t1,&xs,&ys);
	rxy(xs,ys,&ixs,&iys);

	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	printf("P[%d,%d]C(A%d)[%d,%d]",icx,icy,(int) t2-t1,ixs,iys);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
	static int ix1,iy1,ix2,iy2;
	static int ii;
	dxy(x1,y1,&ix1,&iy1);
	dxy(x2,y2,&ix2,&iy2);
	if (ix1>ix2) { ii = ix1; ix1 = ix2; ix2 = ii; }
	if (iy1>iy2) { ii = iy1; iy1 = iy2; iy2 = ii; }
	printf("P[%d,%d]F(V[%d,%d][%d,%d][%d,%d][%d,%d]);\n",ix1,iy1,ix2,iy1
		,ix2,iy2,ix1,iy2,ix1,iy1);
	g.xinline = false;
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
	static int ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4;
	static int ii;
	dxy(x1,y1,&ix1,&iy1);
	dxy(x2,y2,&ix2,&iy2);
	if (ix1>ix2) { ii = ix1; ix1 = ix2; ix2 = ii; }
	if (iy1>iy2) { ii = iy1; iy1 = iy2; iy2 = ii; }
	printf("P[%d,%d]V[%d,%d][%d,%d][%d,%d][%d,%d];\n",ix1,iy1,ix2,iy1
		,ix2,iy2,ix1,iy2,ix1,iy1);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
	static int ixr,iyr;
	int ux,uy;
	rxy(zr,zr,&ixr,&iyr);
	dxy(g.curx,g.cury,&ux,&uy);
	printf("P[%d,%d]C(A%d)[%d,%d]",ux,uy,360,ixr);
	g.xinline = false;
}
d_circle_fill(double zr)
{
	static int ixr,iyr;
	int ux,uy;
	dxy(g.curx,g.cury,&ux,&uy);
	rxy(zr,zr,&ixr,&iyr);
	printf("P[%d,%d]F(C(A%d)[%d,%d])",ux,uy,360,ixr);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	double ax,bx,cx,ay,by,cy,dist;
	double xxx,yyy,i,t,nstep,x0,y0;
	g_get_xy(&x0,&y0);
	dist = fabs(x3-x0) + fabs(y3-y0);
	nstep = 10;
	if (dist>3) nstep = 20;
	if (dist<.5) nstep = 5;
	if (dist<.3) nstep = 3;
 	if (dist<.1) {
		g_line(x3,y3);
		return;
	}
	cx = (x1-x0)*3;
	bx = (x2-x1)*3-cx;
	ax = x3-x0-cx-bx;
	cy = (y1-y0)*3;
	by = (y2-y1)*3-cy;
	ay = y3-y0-cy-by;
	for (i=0;i<=nstep;i++) {
		t = i/nstep;
		xxx = ax*pow(t,3.0) + bx*t*t + cx*t + x0;
		yyy = ay*pow(t,3.0) + by*t*t + cy*t + y0;
		g_line(xxx,yyy);
	}
}
/*---------------------------------------------------------------------------*/
d_set_color(long f)
{
	int i;
	colortyp  cc;
	cc.l = f;
	i = 0;
	if (cc.b[B_R]>100) i = 4;
	if (cc.b[B_B]>100) i = 1;
	if (cc.b[B_G]>100) i = 2;
/*
	if (cc.b[B_R]>100 && cc.b[B_G]>100 && cc.b[B_B]>100) i = getmaxcolor();
	if (i>getmaxcolor()) i = getmaxcolor();
*/
}
d_set_fill(long f)
{
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data *cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
d_char(int font, int cc)
{
	static struct char_data cd;
	static int ix,iy,ix1,ix2,iy1,iy2,fz,fzx;
	static int ux,uy;
	char ss[2];

	ss[0] = cc;
	ss[1] = 0;
	stop;

	if (font_get_encoding(font)>2) {
		my_char(font,cc);
		return;
	}
	font_get_chardata(&cd,font,cc);
	if (g.fontsz==0) g.fontsz = 1;
	dxy(g.curx, g.cury , &ix1, &iy1);

	rxy(g.fontsz * .5,g.fontsz * .7,&fzx,&fz);
	printf("P[%d,%d]T(W(V),S[400,400],U[%d,%d])'%c';\n"
		,ix1,iy1-fz,fzx,fz,cc);
}
graphmode()
{
	ingraphmode = true;
	printf("%cPp",ESC);
}
textmode()
{
	ingraphmode = false;
	printf("%c%c",ESC,'\\');
}
getmaxx()
{
	return 799;
}
getmaxy()
{
	return 479;
}






