#include "defines.h"

/****************************************************************/
/*	Voronoi Output Routines
/****************************************************************/
extern struct VEC2 V2_sum();
extern struct VEC2 V2_sub();
extern struct VEC2 V2_times();
extern double V2_cprod();
extern struct VEC2 V2_cross();
extern double V2_dot();
extern double V2_magn();
extern struct VEC2 circle_center();

plot_dedge(p1, p2)
SITE_PTR p1, p2;
{
    /* plots a Delaunay-triangulation edge on your favorite device. */
    show_line((float) X(p1), (float) Y(p1), (float) X(p2), (float) Y(p2), 1);
}

plot_vedge(p1, p2)
struct VEC2 p1, p2;
{
    /* plots a Voronoi-diagram edge on your favorite device. */
    show_line((float) p1.x, (float) p1.y, (float) p2.x, (float) p2.y, 0);
}


int *earray;

output_voronoi_diagram(which)
int which;
{
    EDGE_PTR nex;

    int i,n;

    if (which & 4)
    {
	n=12*n_sites; /* number of edges */
	my_alloc(earray,int,n);
	for (i = 0; i < n; i++)
	    earray[i] = -1;

	for_tris(nex)
	    assign_color (nex, onext(nex), dprev(nex));
	end_tris(nex)
    }
    if (which & 3)
    {
	for_quad_edges(nex)
	    if (which & 2)
		plot_dedge(orig(nex),dest(nex));
	    if (which & 1)
		plot_vedge(Corner(left(nex)),Corner(right(nex)));
	end_quad_edges(nex);
    }
    if (which & 8)
    {
	for_sites(i)
	    show_vertex(X(i),Y(i));
        end_sites(i)
    }
    if (which & 16)
    {
	for_quad_edges(nex)
	    if (Type(orig(nex)) != Type(dest(nex)))
		plot_vedge(Corner(left(nex)),Corner(right(nex)));
	end_quad_edges(nex)
    }
}

lincoln(fp)
FILE *fp;
{
    EDGE_PTR nex;

    int i, nf;

    fprintf(fp," %7d %7d %7d\n",0,0,0);
    for (i = 0 ; i < n_sites ; i++ )
	fprintf(fp," %g %g 0.0\n", X(i), Y(i));
    nf = 0;

    for_tris(nex)
	fprintf(fp,"3 %d %d %d\n", orig(nex),dest(nex),dest(onext(nex)));
	nf++ ;
    end_tris(nex)

    rewind(fp);
    fprintf(fp," %7d %7d %7d\n",n_sites, nf, n_sites + nf - 1);
    fclose(fp);
    /***** system("/u/geom/bin/vax/off_to_linc 1 < /tmp/vor.off"); ***/
}

assign_color (e12, e13, e32)
  EDGE_PTR e12, e13, e32;
{
  int c12, c13, c23;
  int col, i;
  float xar[3], yar[3];

if ((orig(e32) != dest (e13)) || (dest(e32) != dest (e12))) return;

  c13 = earray[e13];
  c12 = earray[sym (e12)];
  c23 = earray[e32];
  xar[0] = X (orig (e12)); xar[1] = X (dest (e12)) ; xar[2] = X (dest (e13));
  yar[0] = Y (orig (e12)); yar[1] = Y (dest (e12)) ; yar[2] = Y (dest (e13));

  for (i = 0, col = -1; i < 6; i++)
    if (i != c13 && i != c23 && i != c12) {
      col = i;
      break;
    }

  if (col == -1 || col > 3)
    fprintf (stderr, "bad color: %d\n", col), exit (1);

  earray[sym (e13)] = earray[sym (e32)] = earray[e12] = col;

  show_polygon( 3, xar,yar, col + 2 ); 
}
