#include "defines.h"

/****************************************************************/
/*	Quad-edge manipulation primitives
/****************************************************************/
EDGE_PTR makeedge(origin, destination)
SITE_PTR origin, destination;
{
    register EDGE_PTR temp, ans;
    temp = alloc_edge();
    ans = temp;

    onext(temp) = ans;
    orig(temp) = origin;
    onext(++temp) = ans + 3;
    onext(++temp) = ans + 2;
    orig(temp) = destination;
    onext(++temp) = ans + 1;

    return(ans);
};

splice(a,b)
EDGE_PTR a, b;
{
    EDGE_PTR alpha, beta, temp;
    alpha = rot(onext(a));
    beta = rot(onext(b));
    temp = onext(alpha);
    onext(alpha) = onext(beta);
    onext(beta) = temp;
    temp = onext(a);
    onext(a) = onext(b);
    onext(b) = temp;
};

swapedge(e)
EDGE_PTR e;
{
    EDGE_PTR a,b,syme;
    a = oprev(e);
    syme = sym(e);
    b = oprev(syme);
    splice(e, a);
    splice(syme, b);
    splice(e, lnext(a));
    splice(syme, lnext(b));
    orig(e) = dest(a);
    dest(e) = dest(b);
};

EDGE_PTR connect_left(a, b)
EDGE_PTR a,b;
{
    register EDGE_PTR ans;
    ans = makeedge(dest(a), orig(b));
    splice(ans, lnext(a));
    splice(sym(ans), b);
    return(ans);
};

EDGE_PTR connect_right(a, b)
EDGE_PTR a,b;
{
    register EDGE_PTR ans;
    ans = makeedge(dest(a), orig(b));
    splice(ans, sym(a));
    splice(sym(ans), oprev(b));
    return(ans);
};

deleteedge(e)
    /* disconnects e from the rest of the structure and destroys it. */
EDGE_PTR e;
{
    splice(e, oprev(e));
    splice(sym(e), oprev(sym(e)));
    free_edge(e);
};
