./" $Id: gr.tpl,v 2.3 89/09/20 17:01:31 mbp Exp $
./"
./" gr.man: main manual page for GR procedures.
./"
./" by Mark B. Phillips
./"
./" BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
./" 
./" This is a manual page "template". Before formatting to make the
./" actual manual page, this file should be edited to change the
./" following strings to whatever is appropriate:
./" 
./" MANSECTION_VALUE:
./"	extension (section numer) for man page
./" 
./" INCLDIR_VALUE:
./"	pathname of directory containing installed copy of gr.h
./"
./" LIBDIR_VALUE:
./"	pathname of directory containing installed library files
./"	  (libgr.a, libgr3d.a)
./"
./" LIBFLAG_VALUE:
./"	this should be -LLIBDIR_VALUE if LIBDIR_VALUE is
./"	  not on the path of directories normally searched by ld(1).
./"	  If LIBDIR_VALUE *is* on the search path for ld(1), then
./"	  LIBFLAG_VALUE should be the empty string.
./"
./" AUXDIR_VALUE:
./"	pathname of directory containing installed copies of
./"	  auxiliary files (gr_header.ps, gr_trailer.ps, and gr.help)
./"
./" SAMPLEDIR_VALUE:
./"	pathname of directory containing installed copies of
./"	  grdemo.c
./"
./" This can be done with a sed command, which is normally done by the
./" gr makefile during installation, or by the explicit command 'make
./" gr.<n>', where <n> is the number you specify for MANEXT in the
./" Makefile.
./" 
./" EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
.TH GR MANSECTION_VALUE "September 20, 1989"
.SH NAME
gr \- A SunView Vector Graphics Package
.SH SYNOPSIS
.B #include
"INCLDIR_VALUE/gr.h"
.nf

cc myprogram.c LIBFLAG_VALUE -lgr -lm -lsuntool -lsunwindow -lpixrect

.PP
.B gr_initialize(argc, argv)
.B int argc;
.B char \(**\(**argv;
.PP
.B gr_set_frame_label( label )
.B char \(**label;
.PP
.B gr_set_frame_icon( icon )
.B Icon \(**icon;
.PP
.B gr_set_menu(menu)
.B gr_Menu \(**menu;
.PP
.B gr_main_loop()
.PP
.B gr_done()
.PP
.B gr_coordinate_system(x1, y1, x2, y2)
.B double x1, y1, x2, y2;
.PP
.B gr_move(x,y)
.B double x,y;
.PP
.B gr_draw(x,y)
.B double x,y;
.PP
.B gr_arc( xc,yc,  x1,y1,  x2,y2 )
.B double xc,yc,x1,y1,x2,y2;
.PP
.B gr_point()
.PP
.B gr_erase()
.PP
.B gr_message(s, n )
.B char \(**s;
.B int n;
.PP
.B gr_message_clear()
.PP
.B gr_get_string(s)
.PP
.B gr_user_confirm(s)
.PP
.B gr_get_xy(x, y, button, bmask)
.B double \(**x, \(**y;
.B gr_Button \(**button, bmask;
.PP
.B gr_show_cursor(x,y)
.B double x,y;
.PP
.B gr_button_message(Lmsg, Mmsg, Rmsg,
.B "                  SLmsg, SMmsg, SRmsg, ESCmsg)"
.B "char  \(**Lmsg, \(**Mmsg, \(**Rmsg,"
.B "char  \(**SLmsg, \(**SMmsg, \(**SRmsg, \(**ESCmsg;"
.PP
.B gr_button_message_clear()
.PP
.B gr_set_help_file(filename)
.B char \(**filename;
.PP
.B gr_canvas_width()
.PP
.B gr_canvas_height()
.PP
.B double gr_aspect_ratio()
.PP
.B gr_canvas_move(x,y)
.B int x,y;
.PP
.B gr_canvas_draw(x,y)
.B int x,y;
.PP
.B gr_canvas_arc( xc,yc,  x1,y1,  x2,y2 )
.B int xc,yc,x1,y1,x2,y2;
.PP
.B gr_get_canvas_xy(x, y, button, bmask)
.B int \(**x, \(**y;
.B gr_Button \(**button, bmask;
.PP
.B gr_show_canvas_cursor(x,y)
.B int x,y;
.PP
.B gr_set_coordinate_display_proc( proc )
.B char \(**(\(**proc)();
.PP
.B gr_iconic(state)
.B int state;
.PP
.B gr_signal(sig, func)
.B int sig, (*func)();
.PP
.B gr_set_input_func(func, fd)
.B int (*func)(), fd;
.B gr_batch_on()
.PP
.B gr_batch_off()
.PP
.B gr_postscript_begin(fname, logo, label, time)
.B char \(**fname, \(**logo, \(**label, \(**time;
.PP
.B gr_postscript_end()
.PP
.PP
.B gr_print_button(status, redraw_proc)
.B int status;
.B int (\(**redraw_proc)();
.PP
.SH DESCRIPTION
These are the GR library procdedures.  See
.I grintro(MANSECTION_VALUE)
for an introduction to GR.
.SH "INITIALIZATION AND SETUP PROCEDURES"
.PP
.I gr_initialize
initializes GR; your application program should call
.I gr_initialize
before calling any other GR functions.
.I argc
and
.I argv
may specify the list of generic Suntools window (\-W)
arguments from your program's command line.  If
.I argc
is 0 these arguments are ignored (
.I argv
may be NULL in this case).
.I gr_initialize
should be called only once per program run, and it is the
only GR function which is required.  All others are optional.
.I gr_set_frame_label
sets the label which is displayed across the top of the window.
.I gr_set_frame_icon
specifies an icon for the program.
.I icon
should be a pointer to an icon defined with the
.I DEFINE_ICON_FROM_IMAGE
macro described section 13.1 of the
.I "Sunview Programmer's Guide".
.I gr_set_menu
specifies a menu which will be available to the user via the right mouse
button when the cursor is over the graphics canvas.
.I menu
should be a pointer to an object of type
.I gr_Menu
(defined in "gr.h").  This is a structure defined with the following
typedefs:
.nf
.in +5

typedef struct gr_Menu_s {
	char	 *title;
	int	 nopts;
	gr_Opt_pair *list;
	} gr_Menu;

typedef struct gr_Opt_pair_s {
	char	*string;
	int	(*proc)();
	} gr_Opt_pair;

.fi
.in -5
.I "menu->title"
is a string to be used as the menu's title. 
.I "menu->nopts"
is the number of options (entries) in the menu. 
.I "menu->list"
should be a pointer to an array of
.I "menu->nopts"
objects of type
.I gr_Opt_pair.
This object is a structure with two members:
.I string
is the string to be displayed in the option's position in the menu, and
.I proc
is a pointer to a function to be called when the user selects that option
from the menu.  This function should take no arguments and return no
value.  Your program may call
.I gr_set_menu
multiple times to switch between menus.  See the sample program
.I "grdemo.c"
for an example of how to use menus. 
.PP
GR programs, like other Suntools programs, use a notification-based
control structure.  This means that the Suntools notifier handles all
input from the user.
.I gr_main_loop
is the procedure which turns control over to the notifier.  Your application
program should perform whatever initialization it needs to do, including
calling
.I gr_initialize,
and then call 
.I gr_main_loop.
This causes your program's window to appear and your program to enter
the notifier loop.  It is during this loop that all interaction with
the user takes place.  This usually happens through the program's menu
--- the user picks a menu option, and GR calls the corresponding menu
procedure.  (It may also happen through signals or pipe communication;
see
.I gr_signal
and
.I gr_set_input_func
below.)
.I gr_main_loop
does not return until
.I gr_done
is called from within one of your menu procedures, or the user
selects "Quit" from the window's frame menu.
.SH "GRAPHICS PROCEDURES"
.I gr_coordinate_system
defines a coordinate system, called the "user coordinate system" for
the graphics canvas.
.I (x1,y1)
becomes the lower left corner, and
.I (x2,y2)
becomes the upper right corner. The default user coordinate system,
which is what you get if you don't call
.I gr_coordinate_system
explictly, has (0,0) in the lower left and (1,1) in the upper right.
The graphics canvas is NOT square, in general, so in this system
horizontal units are not equal to vertical units.  See
.I gr_aspect_ratio
below for a way to define your user coordinate system to have
the same aspect ratio as the canvas coordinate system.
WARNING:  If you use a different aspect ratio, then calls to
.I gr_arc
will probably produce undesired results.  See
.B "BUGS AND CAVEATS"
below for more details on this. See also
.B "ADVANCED PROCEDURES"
below for procedures which work directly with the canvas's own integer
coordinate system.
.I gr_move
moves the current point to
.I (x,y),
and
.I gr_draw
draws a line from the current point to
.I (x,y)
and leaves the current point at
.I (x,y). 
.I gr_arc
draws an arc of a circle with center
.I (xc,yc).
The arc is drawn clockwise beginning at
.I (x1,y1)
and continuing to a point on the ray from
.I (xc,yc)
to
.I (x2,y2). 
.I (x2,y2)
is used only to determine the final angle of the arc. If
.I (x1,y1)
and
.I (x2,y2)
are the same point, an entire circle is drawn.
.I gr_arc
leaves the current point unchanged. 
.I gr_point
draws a point at the current point. 
.I gr_erase
erases the graphics canvas. 

Note that no graphics will actually appear on the screen until
.I gr_main_loop
is called, since it is this call which causes the GR window to appear.
The canvas is stored internally, however, so that if you make graphics
calls before the call to
.I gr_main_loop,
the results will be visible on the canvas when it appears.

.SH "USER INTERACTION PROCEDURES"
.I gr_message
displays a message in one of two available message lines in the
message panel. 
.I s
is the message to be displayed, and
.I n
is the number of the message line to display it in (1 or 2).  The
message should be at most
.I
GR_MESSAGE_LENGTH
(defined in "gr.h") chars long; if it is longer it will be truncated
to this length.
.I gr_get_string
reads a string from the keyboard, echoing it in the message panel as
it is typed.  Characters up to and including a newline are read from
the keyboard and stored in
.I s,
with the newline replaced by the null character.  The maximum
length of a string read with
.I gr_get_string
is
.I GR_INPUT_TEXT_LENGTH. 
.I gr_user_confirm
pops up a window with a prompt question
.I s
in it, and forces the user to answer yes or no.  It returns 1 if the
user answers yes, and 0 if no.  Although the message should be short
for stylistic reasons, there is no limit on its length (up to the
width of the screen).  The confirmer window is scaled so that the message
will fit inside it.

.I gr_get_xy
gets the coordinates of a point in the canvas from the user.  It waits
until the user presses one of several buttons, and returns in
.I (x,y)
the coordinates of the cursor location at the time the button was
pressed.  These coordinates are in the user coordinate system.
GR recoginizes seven "buttons": the three mouse buttons, the three
mouse buttons with the keyboard shift key held down, and the escape
key on the keyboard.  The type
.I gr_Button
(defined in "gr.h") is used to specify these buttons.  This type
has the values
.I GR_LEFT,
.I GR_MIDDLE,
.I GR_RIGHT,
.I GR_SHIFT_LEFT,
.I GR_SHIFT_MIDDLE,
.I GR_SHIFT_RIGHT,
and
.I GR_ESC.
.I bmask
is a mask used to specify which buttons you want to recognize; it should be
a logical OR (|) of
.I gr_Button
values.
For example, to recognize the left mouse button or the escape key, set
.I bmask
=
.I "GR_LEFT\ |\ GR_ESC".
.I bmask
must include at least one button type.  The special value
.I GR_ALL_BUTTONS
may be used to specify that all buttons should be recognized.  When
.I gr_get_xy
returns, it sets
.I "*button"
to the 
.I gr_Button
value corresponding to the button that the user pressed.
.I gr_show_cursor
is the opposite of
.I gr_get_xy;
it moves the mouse cursor to the point
.I (x,y)
(in the user coordinate system).

.I gr_button_message
displays up to seven short messages in the message panel, one for each
button recognizable by calls to
.I gr_get_xy,
These messages are displayed next to images which graphically
represent the correponding button, as a way of showing the user what
the program will do in response to the different possible buttons.
Each message string passed to
.I gr_button_message
must be either "" (string of length 0) or a positive-length string to
be displayed.  If it is "", the corresponding image is not shown.  The
button messages must each be at most
.I GR_BUTTON_MESSAGE_LENGTH
chars long; any longer ones are truncated.
.I gr_button_message_clear
clears all the button messages which were turned on with the last call
to
.I gr_button_message.
.I gr_set_help_file
specifies the name of a file to display in the help window when the user
selects the "Help" button in the upper right corner of the GR window.
.I gr_set_help_file
may be called different times to switch between help files.
.SH "ADVANCED PROCEDURES"
.I gr_canvas_width
returns the width, in pixels, of the GR graphics canvas.
.I gr_canvas_height
returns its height.
.I gr_aspect_ratio
returns the ratio of the width to the height; it is equivalent to
.nf

.ce 1
(double)gr_canvas_width() / (double)gr_canvas_height()

.fi
This aspect ratio can be used to determine a user coordinate system
in which vertical and horizontal units appear equal.
.PP
The canvas width, height (and hence the aspect ratio) never change
during the execution of a program (the canvas may not be resized).  In
fact, these values are specified by constants in the GR source code and
will therefore be the same every time the program is run.  To provide
compatibility with future versions of GR in which these constants may be
changed, however, it is recommeded that you rely on these procedures
rather than using the values directly.
.PP
The procedures
.I gr_canvas_move,
.I gr_canvas_draw,
.I gr_canvas_arc,
.I gr_get_canvas_xy,
and
.I gr_show_canvas_cursor 
do the same as the analogous GR procedures with the same names but
without the word "canvas", except that these procedures work in the
canvas's integer (pixel) coordinate system.  This has (0,0) in the
upper left corner, and (w,h) in the lower right, where w is the canvas
width and h is its height, in pixels.  These procedures are provided
for applications for which speed is crucial; they are faster because
they do not have to do floating point operations to change coordinate
systems.

.I gr_set_coordinate_display_proc
specifies a procedure to be used for formatting a string containing
the cursor's coordinates which will be displayed in the message
panel during calls to
.I gr_get_xy
or (
.I gr_get_canvas_xy
).
.I proc
should be a pointer to a function declared as follows
.nf

.in +5
char *proc(x,y)
int x,y;
.in -5

.fi
.I (x,y)
are the coordiantes of the cursor in the canvas's integer coordinate
system.  (See
.B "GR MACROS"
for how to convert between this coordinate system and the user
coordinate system).
.I proc
should return a pointer to a null-terminated string; 
.I proc
is called and the string redisplayed each time the user moves the mouse
during calls to
.I gr_get_xy
or
.I gr_get_canvas_xy.
If
.I proc
is NULL, which is the default, no coordinates are displayed.

.I gr_iconic
alters whether the GR window is iconic or not;
.I state
= 1 makes it iconic, and
.I state
= 0 makes it non-iconic.

.I gr_signal
and
.I gr_set_input_func
set traps for Unix signals, and should be used instead of the Unix
.I signal(3)
procedure.  In both of these,
.I func
is a pointer to a function which will be called when a certain signal
is received.
.I gr_set_input_func
specifies that the function is to be called when input is available to
be read from file descriptor
.I fd;
.I gr_signal
specifies that the function is to be called when signal
.I sig
is received.  See
.I signal(3)
for a list of valid signals.

.I gr_batch_on
and
.I gr_batch_off
turn "batching" on and off.  When batching is on, graphics operations
are done in memory only and are not displayed on the screen. Turning
batching off causes the canvas to be painted with the image from
memory.  To improve speed, you should turn batching on just before any
long sequence of graphics operations, and turn it off at the end.

.I gr_postscript_begin
and
.I gr_postscript_end
can be used to generate a file of PostScript commands.
.I fname
is the name of the file to write to.
.I logo
is a short text string which will be displayed in the upper left corner
of the picture; it is meant to be used for a program logo.
.I label
is a string which will be centered under your picture as a caption,
and
.I time
is a string which should contain the current date and time; it will
be displayed in the upper right corner of the picture.  If either
of
.I "logo, label,"
or
.I "time"
is
.I NULL,
the corresponding string is omitted from the picture.
Calling
.I gr_postscript_begin,
puts GR is in "PostScript" mode.  In this mode,
all GR graphics procedures (except
.I gr_erase
) send their output to the PostScript file rather than to the GR
canvas.  Calling
.I gr_postscript_end
causes this file to be closed and returns GR to its normal mode.  The
file then contains a PostScript image of what would have been drawn on
the screen by the graphics calls while in the PostScript mode.
.I gr_erase
has no effect on either the graphics canvas or the PostScript file
while GR is PostScript mode.  Note: see the section below on
.B "GR ENVIRONMENT VARIABLES"
for more information on how GR creates PostScript files.

.I gr_print_button
can be used to enable a "printer" button in the GR control panel.
This buttons provides easy access to the PostScript capability of GR.
When the user presses this button, a "PostScript" frame pops up in
which the user can specify various settings and then write or print a
PostScript file.  The code which implements the PostScript frame
handles calls the calls to
.I gr_postscript_begin
and
.I gr_postscript_end
automatically.
.I redraw_proc
specifies a procedure which will be called in PostScript mode to
create the file; it should "redraw" the current picture. (Since it
will be called only in PostScript mode, nothing will actually be
redrawn on the canvas.)
.I state
= 1 turns the printer button on;
.I state
= 0 turns it off.  Note: see the section below on
.B "GR ENVIRONMENT VARIABLES"
for more information on how GR's printer button sends PostScript files
to the printer.

.SH "GR MACROS"
The file "gr.h" defines several preprocessor macros which your application
program may use.
.I GR_CANVAS_X
and
.I GR_CANVAS_Y
convert from the user coordinate system to the canvas's integer coordinate
system:  if
.I (x,y)
is a point in user space, then
.I "(GR_CANVAS_X(x),GR_CANVAS_Y(y))
is the equivalent point in canvas space.
.I GR_SAVNAC_X
and
.I GR_SAVNAC_Y
go in the other direction: if is a point in canvas space, then
.I "(GR_SAVNAC_X(x),GR_SAVNAC_Y(y))
is the equivalent point in user space.  ("SAVNAC" is "CANVAS" spelled
backwards.)
.I "gr_move, gr_draw, gr_arc,"
and 
.I gr_show_cursor
are also  macros which call the corresponding "canvas" procedures
(see
.B "ADVANCED PROCEDURES"
) using these coordinate system conversion macros.

.SH "GR ENVIRONMENT VARIABLES"
You can control some aspects of GR's behavior by setting certain
enviroment variables.  Each PostScript file which GR creates contains
some common initial and terminal PostScript commands.  These commands
are contained in header and trailer files named "gr_header.ps" and
"gr_trailer.ps".  The standard versions of these files are distributed
with the GR source code, and their locations on your system are
specified to GR at the time that the GR library is built.  Whenever a
GR program creates a PostScript file, it looks in this location for
these files.  If you want to use alternate versions of these files, or
if you are using a GR program on a system other than that on which it
was compiled, you can specify another location for these files by
setting the environment variable
.I GR_LIB.
GR always checks this variable when creating PostScript files, and if
it has a value, that value is used as the pathname of a directory in
which to look for "gr_header.ps" and "gr_trailer.ps".  This is done
before looking for the standard versions of these files, so that
.I GR_LIB
can be used to override the standard versions.

GR also looks in the location specified by the
.I GR_LIB
environment variable for the default help file which is displayed in
the help window when the uses clicks on the "help" button.  Note that
if your GR program specifies its own help file (which it should),
however, the default help file is never needed.

You can also control the command which the "print" button in
the PostScript window (see
.I gr_printer_button
above) uses to print PostScript files.  Usually it uses a standard
command (such as 'lpr') which was specified for your system when the
GR library was built.  If you want to use a different command, for
example to have the output sent to a different printer, you can set
the enviroment variable
.I GR_SPOOL
to the command that you want to use.  This should be a command which
will send a PostScript file, whose name is given as an argument to the
command, to a printer.  The command may consist of several words
separated by spaces (for example to specify options to a command).
When the user of a GR program clicks on the "printer" button, GR
creates a temporary PostScript file, and then checks to see if
.I GR_SPOOL
is defined.  If it is, a command is constucted by concatenating
the value of
.I GR_SPOOL
and the name of the temporary PostScript file, separated by a space.
This command is executed in a subshell with a call to
.I system(3),
and then the temporary PostScript file is deleted.  If
.I GR_SPOOL
is not defined, the process is the same except that the default
spooling command is used.

.SH "RESERVED NAMESPACES"
All external symbols in GR begin with either gr_, or GR_.
Application programs should avoid using any names (identifiers or
preprocessor macros) which begin with these sequences.  In addition,
since GR uses SunView, application programs should avoid names
beginning with sequences (in upper, lower, or mixed case) reserved for
SunView.  These are given at the end of chapter 3 of the SunView
Programmer's Guide, and at the time of this writing are: attr_,
canvas_, cursor_, defaults_, ei_, es_, ev_, event_, frame_, icon_,
menu_, notify_, panel_, pixrect_, pixwin_, pr_, pw_, rect_, rl_,
scrollbar_, scroll_, seln_, textsw_, text_, toolsw_, tool_, ttysw_,
tty_, window_, win_, and wmgr_.

.SH "ERROR HANDLING"
The present version of GR does not do a very good job of reporting
errors.  Each GR procedure, unless it is a function which is
documented to return a certain value, returns the value of 0 or 1.  0
means that the call was successful, 1 means that some sort of error
occurred.  GR keeps no record of what the error actually was.

.SH "BUGS AND CAVEATS"
.I gr_arc
can give undesired results if the user space aspect ratio is not the
same as the canvas aspect ratio.  This is because the arc drawn by
.I gr_arc 
is designed to always appear circular on the canvas.  If the aspect
ratios are not equal, then circles in user space correspond to
ellipses in canvas space, and vice versa.  Hence the arc drawn by
.I gr_arc,
which will be circular in canvas space, may not correspond to a
circular arc in user space.  To avoid this, it is best to use
.I gr_aspect_ratio
to determine the canvas aspect ratio, and then set your user
coordinate system to have this same ratio.

If you move a GR program to a computer system other than the one on
which the program was compiled, you should also move the files
"gr_header.ps", "gr_trailer.ps", and "gr_helpfile".  Also read the
section
.B "GR ENVIRONMENT VARIABLES"
above for how to tell your GR program where to look for these files on
the new system.

.SH "THREE DIMENSIONAL VERSION"
GR does two dimesional vector graphics.  There is a version of GR,
however, which is meant to be used with a three dimensional vector
graphics package called
.I LGD.
For details of using this, see the manual pages for
.I LGD.

.SH FILES
.in +2
.ti -2
LIBDIR_VALUE/libgr.a: GR library file for 2D version
.ti -2
LIBDIR_VALUE/libgr3d.a: GR library file for 3D
version
.ti -2
INCLDIR_VALUE/gr.h: application program header
file
.ti -2
SAMPLEDIR_VALUE/grdemo.c: sample GR program
.ti -2
AUXDIR_VALUE/gr_header.ps: header file for PostScript output
.ti -2
AUXDIR_VALUE/gr_trailer.ps: trailer file for
PostScript output
.ti -2
AUXDIR_VALUE/gr.help: default help file; used
by programs which do not specify a help file
.in -2

.SH "SEE ALSO"
.I "grintro(MANSECTION_VALUE), lgdintro(MANSECTION_VALUE), lgd(MANSECTION_VALUE)"

.SH "Author"
Mark B. Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.sp1
Copyright (C) 1989 by Mark B. Phillips
.sp1
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Mark B. Phillips or
the University of Maryland not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.  This software is provided "as is" without express
or implied warranty.
.sp
PostScript is a trademark of Adobe System, Incorporated.
.sp
Sun Workstation is a trademark of Sun Microsystems, Incorporated.
.sp
Unix is a trademark of AT&T Bell Laboratories.
