/* Copyright 1988 John M. Sullivan.  See main program for details. */
#ifndef _STANDARD_
#define _STANDARD_

/* include information about system routines we need */
#include <stdio.h>
#include <math.h>
/*#include <malloc.h>*/
char *malloc();
#include <varargs.h>
#include <ctype.h>

#ifndef SINGLE
typedef double real;	/* we always use doubles, but could change this */
#else
typedef float real;
#endif
typedef FILE * file;
typedef char * string;
typedef int bool;	/* boolean variables */
#ifndef TRUE
#define TRUE	(1+1==2)
#define FALSE	(2+2==5)
#endif

#ifndef MAXINT
#define MAXINT ((1<<31)-1)
#endif

#define Flag(c) Flags[c-'a']
extern int Flag('z'+1);
extern string Progname;
#define Main() main(argc,argv) int argc; string argv[];
#define init_err() (Progname = *argv)
#define do_flags(set) handle_flags(&argc,&argv,set)
#define open_arg(fp,default,mode)	\
    if (argc-- <= 0) fp = default;	\
    else if (!(fp = fopen(*argv++,mode))) error("can't open file %s",*--argv);
#define open_arg_in(fp) open_arg(fp,stdin,"r")
#define open_arg_out(fp) open_arg(fp,stdout,"w")

#define aargc aa_cmd.vcnt
#define open_aarg(n,fp,default,mode)	\
    if (aargc < n) fp = default;	\
    else if (!(fp = fopen(aargv[n],mode)))	\
	error("can't open file %s",aargv[n]);

/* easy memory allocation for typdef'ed structures */
char * myalloc();
#define mem_alloc(number,type)	\
    ((type) myalloc((number)*sizeof(struct type)))
/* easy memory allocation for other types */
#define mem_palloc(number,type)	\
    ((type *) myalloc((number)*sizeof(type)))
#define mem_free(x) free((char *)(x))

#define putstr(s) fputs(s,stdout)
#define concatstr(s,t,u) ((s) = malloc((unsigned)(strlen(t)+strlen(u)+1)), \
			    strcpy(s,t), strcat(s,u))

#ifndef VAX
double drand48();
#define RANDOM_SEED srand48(time(0))
#define RANDOM (2*drand48()-1)
#else
int random();
#define RANDOM_SEED srandom(time(0))
#define RANDOM (random()/(double)(1<<30))
#endif

#ifdef CRAY
#define HZ (2048*120000.0)
#else
#define HZ 60.0
#endif
#define print_utime() {long _T_[4]; times(_T_);	\
	fprintf(stdout,"%s: execution time so far %.2lf\n",Progname,*_T_/HZ);}

/* swap any two longword values (like pointers)*/
#define swap(type,a,b) {register type _x_; _x_ = a; a = b; b = _x_;}

#define max(a,b) ((a)>(b)? (a) : (b))
#define min(a,b) ((a)<(b)? (a) : (b))
#define abs(x) max((x),-(x))

#ifdef CRAY
#define rint(x) ((int)(ceil((x)-.5)))
#undef HUGE
#define HUGE 1e100
#endif

#define until(x) while(!(x))
#define unless(x) if (!(x))
#define if_cant(x) unless(x)

#define IDENT(x) x
#define CONCAT(x,y) IDENT(x)y

#ifdef DEBUG
extern int Debug_Level;
#define DBG(lvl,x) if (Debug_Level>=lvl) {x;};
#else
#define DBG(lvl,x)
#endif

#endif
