/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "standard.h"

typedef struct point	/* store three coordinates of a point in a structure */
{
    real x,y,z;
}
* point;		/* we will always pass around pointers to these */

/* declarations of routines in point.c */
point new_point_x();
#define new_point(x,y,z) new_point_x(x,y,z,mem_alloc(1,point))
#define set_to_0(p) new_point_x(0.,0.,0.,p)
#define copy_pt(p,q) ((p)->x = (q)->x, (p)->y = (q)->y, (p)->z = (q)->z)

point fread_point_x();
#define read_point_x(P) fread_point_x(stdin,P)
#define fread_point(fp) fread_point_x(fp,mem_alloc(1,point))
#define read_point() fread_point(stdin)

point scalar();
point scalar_x();
#define scalar_q(a,p) ((p)->x *= (a), (p)->y *= (a), (p)->z *= (a))
point sum();
point sum_x();
#define sum_q(p,q) ((p)->x += (q)->x, (p)->y += (q)->y, (p)->z += (q)->z)
point diff();
point diff_x();
#define diff_q(p,q) ((p)->x -= (q)->x, (p)->y -= (q)->y, (p)->z -= (q)->z)

point cross();
point cross_x();
point area();
point area_x();

real dot();
#define dot_q(p,q) ((p)->x*(q)->x + (p)->y*(q)->y + (p)->z*(q)->z)
real triple();
real volume();
real norm2();
#define norm2_q(p) dot_q(p,p)
real dist2();
#define dist2_q(p,q) ((p->x-q->x)*(p->x-q->x) +		\
			(p->y-q->y)*(p->y-q->y) +	\
			(p->z-q->z)*(p->z-q->z))
real area2();

point voronoi_corner_x();
#define voronoi_corner(p,q,r,s) voronoi_corner_x(p,q,r,s,mem_alloc(1,point))
point vor_corner_prep(); /* really returns pointer to 3 structs--1st is area */
point do_vor_corner_x(); /* takes 4th point, vc_prep, and volume */
#define do_vor_corner(p,ans,vol) do_vor_corner_x(p,ans,vol,mem_alloc(1,point))

void fprint_point();
#define print_point(p) fprint_point(stdout,p)

/* Here are synonyms for some of the above: */
/* create a new point easily.  type casts allow pt(0,0,0) etc. */
#define pt(x,y,z) (new_point((real) (x), (real) (y), (real) (z)))
/* divide point by a scalar */
#define divide(p,a) scalar(1./(real) (a), p)
#define divide_x(p,a,P) scalar_x(1./(real) (a), p, P)
#define divide_q(p,a) scalar_q(1./(real) (a), p)

/* global variables */
extern point Origin /* =pt(0,0,0) */;
