/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "vcs.h"
#define RND (RANDOM/1000)

site Sites;
int N_Sites;
int N_Pos_Sites = -1;

int N_DEdge = 0, N_DTri = 0, N_DTet = 0, N_BndryTri = 0;
clr Max_color;
static struct point Torus_D = {1.,1.,1.};
point Torus = &Torus_D;
bool Torus_Same;
real Omit_Level = 0.;
point *Gradients;
point Area_Grad;
point Motion;
real *Volumes,*Desired_Changes;
real *Targets = 0;
real Total_Area = 0.;
real Total_Energy = 0.;
real Total_Volume = 0.;
real Int_Dev = 0.;
bool Pos_Err = FALSE;

static point_with_norm2 Locations;

static void add_six_pts();
void init_arrays();

int
read_sites(fp)
file fp;
{
    register site s;
    int n_alloc;
    point_with_norm2 l;
    char c;

    RANDOM_SEED;
    if (fscanf(fp,"%d",&N_Sites)!=1)
	error("Can't read number of sites");

    n_alloc = N_Sites;
    if (Flag_torus)
	n_alloc *= TORUS_FACTOR;
    if (Flag_infty)
	n_alloc += EXTRA_SITES;

    Sites = mem_alloc(n_alloc, site);
    Locations = mem_alloc(n_alloc, point_with_norm2);
		/* Put in array for optim. later */
    Max_color = -MAXINT;
    l = Locations;
    for_sites(s)
    {
	while((c=getc(fp))=='\n' && c!=EOF)
	    ;
	if (c == 'f')
	{
	    while((c=getc(fp))!='\n' && c!=EOF)
		;
	    N_Pos_Sites = s-Sites;
	}
	else
	    ungetc(c,fp);
	if_cant (fread_point_x(fp,pnt(l)))
	    error("Can't read point for site number %d",s-Sites+1);;
	init_site(s,pnt(l));
	if (Flag_random)
	    pnt(l)->x += RND, pnt(l)->y += RND, pnt(l)->z += RND;
	if (Flag_torus)
	    reduce(pnt(l));
	l->nrm2 = norm2_q(pnt(l));
	l++;
	if (fscanf(fp," : %d",&s->color)!=1)
	    error("Can't read site number %d",s-Sites+1);
	if (s->color < 0)
	    error("Color for site %d must be non-negative, not %d",
		    s-Sites+1,s->color);
	if (s->color > Max_color)
	    Max_color = s->color;
    }
    if (N_Pos_Sites<0)
	N_Pos_Sites = N_Sites;
    if (Max_color > MAXC)
	error("Color out of range: %d must be at most %d", Max_color,MAXC);
    return N_Sites;
}

void
extra_sites()
{
    register site s,t;
    real tmp;
    point_with_norm2 l;

    if (Flag_torus)
    {
	for_sites(s)
	{
	    register int i,j,k;
	    t = s;
	    for(i = -1; i <= 1; ++i)
	      for(j = -1; j <= 1; ++j)
		for(k = -1; k <= 1; ++k)
		    if (i || j || k)
		    {
			t += N_Sites;
			l = Locations+(t-Sites);
			new_point_x( s->loc->x + i*Torus->x + RND/10,
				     s->loc->y + j*Torus->y + RND/10,
				     s->loc->z + k*Torus->z + RND/10, l);
			init_site(t,l);
			l->nrm2 = norm2_q(pnt(l));
			t->color = - s->color;
		    }
	}
	N_Sites *= TORUS_FACTOR;
    }

    if (Flag_kelvin)
	for_moving_sites(s)
	{
	    /*
	    tmp = s->loc->x-rint(s->loc->x); Int_Dev += tmp*tmp;
	    tmp = s->loc->y-rint(s->loc->y); Int_Dev += tmp*tmp;
	    tmp = s->loc->z-rint(s->loc->z); Int_Dev += tmp*tmp;
	    */
	}

    if (Flag_infty)
	add_six_pts();
}

void
init_arrays()
{
    int n_clrs;
    clr k;
    site s;

    n_clrs = Max_color+1;

    Volumes = mem_palloc(n_clrs,real);
    Desired_Changes = mem_palloc(n_clrs,real);
    Gradients = mem_palloc(n_clrs,point);
    for_colors(k)
    {
	Volumes[k] = 0.;
	Desired_Changes[k] = 0.;
	Gradients[k] = mem_alloc(N_Pos_Sites,point);
	for_moving_sites(s)
	    new_point_x(0.,0.,0.,vol_grad(k,s));
    }

    Area_Grad = mem_alloc(N_Pos_Sites,point); /* area grads */
    Motion = mem_alloc(N_Pos_Sites,point);
    Wulff_Grad = mem_alloc(N_Pos_Sites,point);
    for_moving_sites(s)
    {
	set_to_0(area_grad(s));
	if (Flag_jump)
	    new_point_x(RANDOM/5,RANDOM/5,RANDOM/5,motion(s));
	else
	    set_to_0(motion(s));
	set_to_0(wulff_grad(s));
    }
}

void
write_sites(fp)
file fp;
{
    register site s;
    int n = 0;
    int no = 0;

    for_sites(s)
    {
	if (Flag_torus && s->color<=0)
	    break;
	if (Flag_torus)
	    reduce(s->loc);
	if (Flag_omit && !s->flag)
	{
	    no++;
	    continue;
	}
	if (s->volume < Omit_Level)
	{
	    warning("Site %d omitted because volume was %f",s-Sites,s->volume);
	    continue;
	}
	n++;
    }

    fprintf(fp,"%d\n",n);
    for_sites(s)
    {
	if (Flag_torus && s->color<=0)
	    break;
	if ((Flag_omit && !s->flag) || s->volume < Omit_Level)
	    continue;
	if (s==Sites+N_Pos_Sites)
	    fprintf(fp,"fix\n");
	fprint_point(fp,s->loc);
	fprintf(fp,": %d\n",s->color);
    }
    if (no)
	warning("%d sites omitted",no);
}

reduce(p)
point p;
{
    while(p->x < 0)
	p->x += Torus->x;
    while(p->x >= Torus->x)
	p->x -= Torus->x;
    while(p->y < 0)
	p->y += Torus->y;
    while(p->y >= Torus->y)
	p->y -= Torus->y;
    while(p->z < 0)
	p->z += Torus->z;
    while(p->z >= Torus->z)
	p->z -= Torus->z;
}

#define new(a,b,c)	\
	    init_site(Sites+N_Sites++, new_point_x(a,b,c,l)),\
	    l->nrm2 = norm2_q(pnt(l)), l++

static void
add_six_pts()
{
    register site s;
    register point mx,mn,dif,mid;
    point_with_norm2 l;

    mx = pt(-HUGE,-HUGE,-HUGE);
    mn = pt(HUGE,HUGE,HUGE);

    for_sites(s)
    {
	if (s->loc->x < mn->x) mn->x = s->loc->x;
	if (s->loc->y < mn->y) mn->y = s->loc->y;
	if (s->loc->z < mn->z) mn->z = s->loc->z;

	if (s->loc->x > mx->x) mx->x = s->loc->x;
	if (s->loc->y > mx->y) mx->y = s->loc->y;
	if (s->loc->z > mx->z) mx->z = s->loc->z;
    }
    dif = diff(mx,mn);
    scalar_x(2.,dif,dif); /* only need to do 1+epsilon */
    mid = sum(mx,mn);
    divide_x(mid,2.,mid);

    l = Locations+N_Sites;

    /* color will be 0 */
    new(mx->x + dif->x,mid->y,mid->z);
    new(mid->x,mx->y + dif->y,mid->z);
    new(mid->x,mid->y,mn->z - dif->z);

    new(mn->x - dif->x,mid->y,mid->z);
    new(mid->x,mn->y - dif->y,mid->z);
    new(mid->x,mid->y,mx->z + dif->z);
}

point Wulff_Grad;
point Wulff_Vect;
int Wulff_Count = 0;
#define WBLOCK 200

read_wulff(fp)
{

    Wulff_Vect = mem_alloc(WBLOCK,point);
    while (Wulff_Count<WBLOCK && fread_point_x(fp,Wulff_Vect+Wulff_Count))
	Wulff_Count++;
}

read_vols(fp)
file fp;
{
    clr k;

    Targets = mem_palloc(Max_color+1, real);
    for_colors(k)
	if (fscanf(fp,"%lf",Targets+k) < 1)
	    error("Can't read volume for color %d",k);
}

write_vols(fp)
file fp;
{
    clr k;
    for_colors(k)
	fprintf(fp,"%lf\n",Volumes[k]);
}
