#include "targs.h"

int n_args;

static char **targs;

enum ARG_T { NONE, STRING, INT, FLOAT };

#define N_ARG_MAX 20

static int arg_type[N_ARG_MAX];

static union {
	char *sval;
	int ival;
	float fval;
} arg_val[N_ARG_MAX];

void Help()
{ int i=0; 
  char *strg;

   if (n_args>=1) {
    strg=s_arg(1);
    do  
      if (!strncmp(strg,cmds[i].format,strlen(strg)))
        { printf("%s\n",cmds[i].calling);
          printf("%s\n",cmds[i].comments);  }
    while (strcmp(cmds[i++].format,"exit"));
    }
   else     do       
       printf("\t%s\n",cmds[i].calling);
    while (strcmp(cmds[i++].format,"exit"));
}
 
void Quit()
{ exit(0); }

double d_arg(j)
  int j;
{
	return (double) f_arg(j);
}

float f_arg(j)
  int j;
{
  if ( j > n_args )
  	{ printf("Not enough arguments (returning 0)\n");
	  return 0; }
  if ( j < 1 )
        { printf("Tried to read the command name (returning 0)\n");
	  return 0; }
  if ( arg_type[j-1] != FLOAT )
	{ printf("Argument %d has wrong type\n",j);
	  return 0; }

	return arg_val[j-1].fval;
}

int i_arg(j)
  int j;
{
  if ( j > n_args )
  	{ printf("Not enough arguments\n");	exit(1); }
  if ( j < 1 )
        { printf("Tried to read the command name\n");	exit(1); }
  if ( arg_type[j-1] != INT )
	{ printf("Argument %d has wrong type\n",j);
	  return 0; }

	return arg_val[j-1].ival;
}

char* s_arg(j)
  int j;
{
  if ( j > n_args )
  	{ printf("Not enough arguments\n");	exit(1); }
  if ( j < 1 )
        { printf("Tried to read the command name\n");	exit(1); }
  if ( arg_type[j-1] != STRING )
	{ printf("Argument %d has wrong type\n",j);
	  return 0; }

  return arg_val[j-1].sval;
}

static int command;

int targok()
/*
 *	Check that the arguments provided match the template
 *	Return 1 if ok, 0 if bad
 */
{ int i=0,j=0,k=0, ok,iarg;
  char *c;
  c=cmds[command].format;
  while ((j<n_args) && *c)
  {
    while (*c && *c!='%') c++;
    if (*c=='%') {j++; c++;}
  }  
  if (j<n_args) ok=0;	/* Too many arguments typed on command line */
  else
  {  
    while (*c && *c!='[' && *c!='%') c++;
    if ((*c=='[') || (!*c)) ok=1; else ok=0; /* Right number */
  }
  for ( iarg=0 ; iarg<N_ARG_MAX ; iarg++ )	arg_type[iarg] = NONE;

    if (ok)
	{
	c = cmds[command].format;
	for ( iarg=0 ; iarg<n_args ; iarg++ )
		{
		while ( *c && *c!='%' ) c++;	/*  Find next percent sign  */
		if (!(*c))	{ printf("error in template\n");	ok=0; }
		c++;
		switch(*c)
		   {
		   case 's':
			arg_val[iarg].sval = targs[iarg+1];
			arg_type[iarg] = STRING;
			break;
		   case 'd':
			if (sscanf(targs[iarg+1],"%d",&arg_val[iarg].ival)!=1)
				ok=0;
			arg_type[iarg] = INT;
			break;
		   case 'f':
			if (sscanf(targs[iarg+1],"%f",&arg_val[iarg].fval)!=1)
				ok=0;
			arg_type[iarg] = FLOAT;
			break;
		    default:	printf("error in template\n");	ok=0;
		    }
		}
	}
    return ok;
}
   
main(argc,argv)
  int argc;
  char **argv;
{
char *cmdl,cmdl2[200];
int i,j,k,quote,done=0;
char c;

targs=(char **)malloc(100);
cmdl=cmdl2;
*cmdl='\0'; 

for(i=0;i<=10;i++)
*(targs+i) =(char *)malloc(1000);
for(i=0;i<=10;i++) strcpy(*(targs+i),"");
while (--argc>0)
  strcat(strcat(cmdl,*++argv)," ");

while (!done)
{

  if (!strlen(cmdl)) {printf("> "); fgets(cmdl2,100,stdin); cmdl=cmdl2;}
  i=0;
  j=0; quote=0; c='*';
  while (*(cmdl+i) && *(cmdl+i)!='-')
  { k=0;
    while ((c = *(cmdl+i++)) && (c!=((quote) ? '"' : ' ')) && c!='\n')
      if (c=='"') quote=!quote; else *(*(targs+j)+k++)=c; 
    if (c=='"') quote=!quote;
    if (k>0) {*(*(targs+j)+k)='\0'; j++;} 
  }
  if (*(cmdl+i)=='-') cmdl+=i+1; else *cmdl='\0';
  n_args=j;
  if (n_args--) {
    i=0; j=0;
    do  
      if (!strncmp(*targs,cmds[i].format,strlen(*targs)))
        { j++; command=i; }
    while (strcmp(cmds[i++].format,"exit"));

    if (j==0)			/*  No command matches the description  */
	printf("Unknown command \"%s\"\n",*targs);
    else if (j==1)		/*  Exactly one commands matches:  do it */
	{
	if (targok())	cmds[command].f();
	else		printf("\tArgument list doesn\'t match template\n");
	}
    else if (j>1)
	{
      printf("\tAmbiguous:\n");
      i=0; 
      do  
        if (!strncmp(*targs,cmds[i].format,strlen(*targs)))
          printf("\t\t%s\n",cmds[i].calling); 
      while (strcmp(cmds[i++].format,"exit"));
      printf("\tPlease type more of the command name\n"); 
    }
  }
}
}
