#include "targs.h"

/****************************************************************************/
/*	COMMANDS GO HERE  */

void Example()
{
	printf("The first argument is %d\n", i_arg(1) );
	if (n_args>1)
		/*  Note:  according to the command definition below, if
			there is a second argument, there is always a third
			argument.  This is checked in the main program.  */
		{ printf("The second argument is %lg\n", f_arg(2) );
		  printf("The third argument is \"%s\"\n", s_arg(3) ); }
}

void Plot()
{
	double xmin, xmax, dx;
	int i, npts;

	printf("Specified function is \"%s\"\n",s_arg(1));
	xmin = d_arg(2); 	xmax = d_arg(3); 
	npts = 10;	if (n_args>=4) npts = i_arg(4);

	dx = (xmax-xmin)/(npts-1);
	for ( i=0 ; i<npts ; i++ )
      {  	regs['x'-'a']=i*dx+xmin; 
		printf("%12.6lf  %12.6lf\n",regs['x'-'a'],expr_tof(s_arg(1))); 
	}
}

/****************************************************************************/
/*	COMMAND DEFINITIONS GO HERE  */

struct cmd cmds[]={
{Example,"example %d [%f %s]","example num [ float string ] ",
	"\tThis command is an example, to illustrate how to define\n\
	and use functions in targs."},
{Plot,"plot %s %f %f [%d]","plot f(x) xmin xmax [npts]",
	"\t\"Plot\" the given function, that is, output (x,y) pairs.  First\n\
	argument is the expression for the function of x.  The expression\n\
	may contain numeric constants, the constants pi and twopi, the\n\
	single variable x, the usual arithmetic functions (log(), cos(),\n\
	etc), and conditional expressions:  a ? b : c  and  if(a,b,c)\n\
	both mean \"if(a) then b else c\".  The second and third arguments\n\
	are the lower and upper limits for the plot range.  The fourth\n\
	argument, if present, is the number of points to plot; default is\n\
	10."},
{Help,"? [%s]","? [command]",
	"\tPrint list of all commands or detailed\n\
	information about a single command"},
{Help,"help [%s]","help [command]",
	"\tPrint list of all commands or detailed\n\
	information about a single command"},
{Quit,"quit","quit",
	"\tExit program"},
{Quit,"exit","exit",
	"\tExit program"}
};
