        SUBROUTINE  NSFC
     *      (N, R, IC, IA,JA, JLMAX,IL,JL,IJL, JUMAX,IU,JU,IJU,           CD 513
     *       Q, IRA,JRA, IRAC, IRL,JRL, IRU,JRU, FLAG)                    CD 514
C                                                                         CD 515
C       INPUT VARIABLES:  N, R, IC, IA, JA, JLMAX, JUMAX.                 CD 516
C       OUTPUT VARIABLES: IL, JL, IJL, IU, JU, IJU, FLAG.                 CD 517
C                                                                         CD 518
C       PARAMETERS USED INTERNALLY:                                       CD 519
C NIA   \ Q     - SUPPOSE  M'  IS THE RESULT OF REORDERING  M.  IF        CD 520
C       \           PROCESSING OF THE ITH ROW OF  M'  (HENCE THE ITH      CD 521
C       \           ROW OF  U) IS BEING DONE,  Q(J)  IS INITIALLY         CD 522
C       \           NONZERO IF  M'(I,J) IS NONZERO (J.GE.I).  SINCE       CD 523
C       \           VALUES NEED NOT BE STORED, EACH ENTRY POINTS TO THE   CD 524
C       \           NEXT NONZERO AND  Q(N+1)  POINTS TO THE FIRST.  N+1   CD 525
C       \           INDICATES THE END OF THE LIST.  FOR EXAMPLE, IF N=9   CD 526
C       \           AND THE 5TH ROW OF  M'  IS                            CD 527
C       \              0 X X 0 X 0 0 X 0                                  CD 528
C       \           THEN  Q  WILL INITIALLY BE                            CD 529
C       \              A A A A 8 A A 10 5           (A - ARBITRARY).      CD 530
C       \           AS THE ALGORITHM PROCEEDS, OTHER ELEMENTS OF  Q       CD 531
C       \           ARE INSERTED IN THE LIST BECAUSE OF FILLIN.           CD 532
C       \           Q  IS USED IN AN ANALOGOUS MANNER TO COMPUTE THE      CD 533
C       \           ITH COLUMN OF  L.                                     CD 534
C       \           SIZE = N+1.                                           CD 535
C NIA   \ IRA,  - VECTORS USED TO FIND THE COLUMNS OF  M.  AT THE KTH     CD 536
C NIA   \ JRA,      STEP OF THE FACTORIZATION,  IRAC(K)  POINTS TO THE    CD 537
C NIA   \ IRAC      HEAD OF A LINKED LIST IN  JRA  OF ROW INDICES I       CD 538
C       \           SUCH THAT I .GE. K AND  M(I,K)  IS NONZERO.  ZERO     CD 539
C       \           INDICATES THE END OF THE LIST.  IRA(I)  (I.GE.K)      CD 540
C       \           POINTS TO THE SMALLEST J SUCH THAT J .GE. K AND       CD 541
C       \           M(I,J)  IS NONZERO.                                   CD 542
C       \           SIZE OF EACH = N.                                     CD 543
C NIA   \ IRL,  - VECTORS USED TO FIND THE ROWS OF  L.  AT THE KTH STEP   CD 544
C NIA   \ JRL       OF THE FACTORIZATION,  JRL(K)  POINTS TO THE HEAD     CD 545
C       \           OF A LINKED LIST IN  JRL  OF COLUMN INDICES J         CD 546
C       \           SUCH J .LT. K AND  L(K,J)  IS NONZERO.  ZERO          CD 547
C       \           INDICATES THE END OF THE LIST.  IRL(J)  (J.LT.K)      CD 548
C       \           POINTS TO THE SMALLEST I SUCH THAT I .GE. K AND       CD 549
C       \           L(I,J)  IS NONZERO.                                   CD 550
C       \           SIZE OF EACH = N.                                     CD 551
C NIA   \ IRU,  - VECTORS USED IN A MANNER ANALOGOUS TO  IRL AND JRL      CD 552
C NIA   \ JRU       TO FIND THE COLUMNS OF  U.                            CD 553
C       \           SIZE OF EACH = N.                                     CD 554
C                                                                         CD 555
C  INTERNAL VARIABLES:                                                    CD 556
C    JLPTR - POINTS TO THE LAST POSITION USED IN  JL.                     CD 557
C    JUPTR - POINTS TO THE LAST POSITION USED IN  JU.                     CD 558
C    JMIN,JMAX - ARE THE INDICES IN  A OR U  OF THE FIRST AND LAST        CD 559
C                ELEMENTS TO BE EXAMINED IN A GIVEN ROW.                  CD 560
C                FOR EXAMPLE,  JMIN=IA(K), JMAX=IA(K+1)-1.                CD 561
C                                                                         CD 562
        INTEGER CEND, QM, REND, RK, VJ                                    CD 563
        INTEGER IA(1), JA(1), IRA(1), JRA(1), IL(1), JL(1), IJL(1)        CD 564
        INTEGER IU(1), JU(1), IJU(1), IRL(1), JRL(1), IRU(1), JRU(1)      CD 565
        INTEGER R(1), IC(1), Q(1), IRAC(1), FLAG                          CD 566
C                                                                         CD 567
C  ******  INITIALIZE POINTERS  ****************************************  CD 568
        NP1 = N + 1                                                       CD 569
        JLMIN = 1                                                         CD 570
        JLPTR = 0                                                         CD 571
        IL(1) = 1                                                         CD 572
        JUMIN = 1                                                         CD 573
        JUPTR = 0                                                         CD 574
        IU(1) = 1                                                         CD 575
        DO 1 K=1,N                                                        CD 576
          IRAC(K) = 0                                                     CD 577
          JRA(K) = 0                                                      CD 578
          JRL(K) = 0                                                      CD 579
   1      JRU(K) = 0                                                      CD 580
C  ******  INITIALIZE COLUMN POINTERS FOR A  ***************************  CD 581
        DO 2 K=1,N                                                        CD 582
          RK = R(K)                                                       CD 583
          IAK = IA(RK)                                                    CD 584
          IF (IAK .GE. IA(RK+1))  GO TO 101                               CD 585
          JAIAK = IC(JA(IAK))                                             CD 586
          IF (JAIAK .GT. K)  GO TO 105                                    CD 587
          JRA(K) = IRAC(JAIAK)                                            CD 588
          IRAC(JAIAK) = K                                                 CD 589
   2      IRA(K) = IAK                                                    CD 590
C                                                                         CD 591
C  ******  FOR EACH COLUMN OF L AND ROW OF U  **************************  CD 592
        DO 41 K=1,N                                                       CD 593
C                                                                         CD 594
C  ******  INITIALIZE Q FOR COMPUTING KTH COLUMN OF L  *****************  CD 595
          Q(NP1) = NP1                                                    CD 596
          LUK = -1                                                        CD 597
C  ******  BY FILLING IN KTH COLUMN OF A  ******************************  CD 598
          VJ = IRAC(K)                                                    CD 599
          IF (VJ .EQ. 0)  GO TO 5                                         CD 600
   3        QM = NP1                                                      CD 601
   4        M = QM                                                        CD 602
            QM =  Q(M)                                                    CD 603
            IF (QM .LT. VJ)  GO TO 4                                      CD 604
            IF (QM .EQ. VJ)  GO TO 102                                    CD 605
              LUK = LUK + 1                                               CD 606
              Q(M) = VJ                                                   CD 607
              Q(VJ) = QM                                                  CD 608
              VJ = JRA(VJ)                                                CD 609
              IF (VJ .NE. 0)  GO TO 3                                     CD 610
C  ******  LINK THROUGH JRU  *******************************************  CD 611
   5      LASTID = 0                                                      CD 612
          LASTI = 0                                                       CD 613
          IJL(K) = JLPTR                                                  CD 614
          I = K                                                           CD 615
   6        I = JRU(I)                                                    CD 616
            IF (I .EQ. 0)  GO TO 10                                       CD 617
            QM = NP1                                                      CD 618
            JMIN = IRL(I)                                                 CD 619
            JMAX = IJL(I) + IL(I+1) - IL(I) - 1                           CD 620
            LONG = JMAX - JMIN                                            CD 621
            IF (LONG .LT. 0)  GO TO 6                                     CD 622
            JTMP = JL(JMIN)                                               CD 623
            IF (JTMP .NE. K)  LONG = LONG + 1                             CD 624
            IF (JTMP .EQ. K)  R(I) = -R(I)                                CD 625
            IF (LASTID .GE. LONG)  GO TO 7                                CD 626
              LASTI = I                                                   CD 627
              LASTID = LONG                                               CD 628
C  ******  AND MERGE THE CORRESPONDING COLUMNS INTO THE KTH COLUMN  ****  CD 629
   7        DO 9 J=JMIN,JMAX                                              CD 630
              VJ = JL(J)                                                  CD 631
   8          M = QM                                                      CD 632
              QM = Q(M)                                                   CD 633
              IF (QM .LT. VJ)  GO TO 8                                    CD 634
              IF (QM .EQ. VJ)  GO TO 9                                    CD 635
                LUK = LUK + 1                                             CD 636
                Q(M) = VJ                                                 CD 637
                Q(VJ) = QM                                                CD 638
                QM = VJ                                                   CD 639
   9          CONTINUE                                                    CD 640
              GO TO 6                                                     CD 641
C  ******  LASTI IS THE LONGEST COLUMN MERGED INTO THE KTH  ************  CD 642
C  ******  SEE IF IT EQUALS THE ENTIRE KTH COLUMN  *********************  CD 643
  10      QM = Q(NP1)                                                     CD 644
          IF (QM .NE. K)  GO TO 105                                       CD 645
          IF (LUK .EQ. 0)  GO TO 17                                       CD 646
          IF (LASTID .NE. LUK)  GO TO 11                                  CD 647
C  ******  IF SO, JL CAN BE COMPRESSED  ********************************  CD 648
          IRLL = IRL(LASTI)                                               CD 649
          IJL(K) = IRLL + 1                                               CD 650
          IF (JL(IRLL) .NE. K)  IJL(K) = IJL(K) - 1                       CD 651
          GO TO 17                                                        CD 652
C  ******  IF NOT, SEE IF KTH COLUMN CAN OVERLAP THE PREVIOUS ONE  *****  CD 653
  11      IF (JLMIN .GT. JLPTR)  GO TO 15                                 CD 654
          QM = Q(QM)                                                      CD 655
          DO 12 J=JLMIN,JLPTR                                             CD 656
            IF (JL(J) - QM)  12, 13, 15                                   CD 657
  12        CONTINUE                                                      CD 658
          GO TO 15                                                        CD 659
  13      IJL(K) = J                                                      CD 660
          DO 14 I=J,JLPTR                                                 CD 661
            IF (JL(I) .NE. QM)  GO TO 15                                  CD 662
            QM = Q(QM)                                                    CD 663
            IF (QM .GT. N)  GO TO 17                                      CD 664
  14        CONTINUE                                                      CD 665
          JLPTR = J - 1                                                   CD 666
C  ******  MOVE COLUMN INDICES FROM Q TO JL, UPDATE VECTORS  ***********  CD 667
  15      JLMIN = JLPTR + 1                                               CD 668
          IJL(K) = JLMIN                                                  CD 669
          IF (LUK .EQ. 0)  GO TO 17                                       CD 670
          JLPTR = JLPTR + LUK                                             CD 671
          IF (JLPTR .GT. JLMAX)  GO TO 103                                CD 672
            QM = Q(NP1)                                                   CD 673
            DO 16 J=JLMIN,JLPTR                                           CD 674
              QM = Q(QM)                                                  CD 675
  16          JL(J) = QM                                                  CD 676
  17      IRL(K) = IJL(K)                                                 CD 677
          IL(K+1) = IL(K) + LUK                                           CD 678
C                                                                         CD 679
C  ******  INITIALIZE Q FOR COMPUTING KTH ROW OF U  ********************  CD 680
          Q(NP1) = NP1                                                    CD 681
          LUK = -1                                                        CD 682
C  ******  BY FILLING IN KTH ROW OF REORDERED A  ***********************  CD 683
          RK = R(K)                                                       CD 684
          JMIN = IRA(K)                                                   CD 685
          JMAX = IA(RK+1) - 1                                             CD 686
          IF (JMIN .GT. JMAX)  GO TO 20                                   CD 687
          DO 19 J=JMIN,JMAX                                               CD 688
            VJ = IC(JA(J))                                                CD 689
            QM = NP1                                                      CD 690
  18        M = QM                                                        CD 691
            QM = Q(M)                                                     CD 692
            IF (QM .LT. VJ)  GO TO 18                                     CD 693
            IF (QM .EQ. VJ)  GO TO 102                                    CD 694
              LUK = LUK + 1                                               CD 695
              Q(M) = VJ                                                   CD 696
              Q(VJ) = QM                                                  CD 697
  19        CONTINUE                                                      CD 698
C  ******  LINK THROUGH JRL,  ******************************************  CD 699
  20      LASTID = 0                                                      CD 700
          LASTI = 0                                                       CD 701
          IJU(K) = JUPTR                                                  CD 702
          I = K                                                           CD 703
          I1 = JRL(K)                                                     CD 704
  21        I = I1                                                        CD 705
            IF (I .EQ. 0)  GO TO 26                                       CD 706
            I1 = JRL(I)                                                   CD 707
            QM = NP1                                                      CD 708
            JMIN = IRU(I)                                                 CD 709
            JMAX = IJU(I) + IU(I+1) - IU(I) - 1                           CD 710
            LONG = JMAX - JMIN                                            CD 711
            IF (LONG .LT. 0)  GO TO 21                                    CD 712
            JTMP = JU(JMIN)                                               CD 713
            IF (JTMP .EQ. K)  GO TO 22                                    CD 714
C  ******  UPDATE IRL AND JRL, *****************************************  CD 715
              LONG = LONG + 1                                             CD 716
              CEND = IJL(I) + IL(I+1) - IL(I)                             CD 717
              IRL(I) = IRL(I) + 1                                         CD 718
              IF (IRL(I) .GE. CEND)  GO TO 22                             CD 719
                J = JL(IRL(I))                                            CD 720
                JRL(I) = JRL(J)                                           CD 721
                JRL(J) = I                                                CD 722
  22        IF (LASTID .GE. LONG)  GO TO 23                               CD 723
              LASTI = I                                                   CD 724
              LASTID = LONG                                               CD 725
C  ******  AND MERGE THE CORRESPONDING ROWS INTO THE KTH ROW  **********  CD 726
  23        DO 25 J=JMIN,JMAX                                             CD 727
              VJ = JU(J)                                                  CD 728
  24          M = QM                                                      CD 729
              QM = Q(M)                                                   CD 730
              IF (QM .LT. VJ)  GO TO 24                                   CD 731
              IF (QM .EQ. VJ)  GO TO 25                                   CD 732
                LUK = LUK + 1                                             CD 733
                Q(M) = VJ                                                 CD 734
                Q(VJ) = QM                                                CD 735
                QM = VJ                                                   CD 736
  25          CONTINUE                                                    CD 737
            GO TO 21                                                      CD 738
C  ******  UPDATE JRL(K) AND IRL(K)  ***********************************  CD 739
  26      IF (IL(K+1) .LE. IL(K))  GO TO 27                               CD 740
            J = JL(IRL(K))                                                CD 741
            JRL(K) = JRL(J)                                               CD 742
            JRL(J) = K                                                    CD 743
C  ******  LASTI IS THE LONGEST ROW MERGED INTO THE KTH  ***************  CD 744
C  ******  SEE IF IT EQUALS THE ENTIRE KTH ROW  ************************  CD 745
  27      QM = Q(NP1)                                                     CD 746
          IF (QM .NE. K)  GO TO 105                                       CD 747
          IF (LUK .EQ. 0)  GO TO 34                                       CD 748
          IF (LASTID .NE. LUK)  GO TO 28                                  CD 749
C  ******  IF SO, JU CAN BE COMPRESSED  ********************************  CD 750
          IRUL = IRU(LASTI)                                               CD 751
          IJU(K) = IRUL + 1                                               CD 752
          IF (JU(IRUL) .NE. K)  IJU(K) = IJU(K) - 1                       CD 753
          GO TO 34                                                        CD 754
C  ******  IF NOT, SEE IF KTH ROW CAN OVERLAP THE PREVIOUS ONE  ********  CD 755
  28      IF (JUMIN .GT. JUPTR)  GO TO 32                                 CD 756
          QM = Q(QM)                                                      CD 757
          DO 29 J=JUMIN,JUPTR                                             CD 758
            IF (JU(J) - QM)  29, 30, 32                                   CD 759
  29        CONTINUE                                                      CD 760
          GO TO 32                                                        CD 761
  30      IJU(K) = J                                                      CD 762
          DO 31 I=J,JUPTR                                                 CD 763
            IF (JU(I) .NE. QM)  GO TO 32                                  CD 764
            QM = Q(QM)                                                    CD 765
            IF (QM .GT. N)  GO TO 34                                      CD 766
  31        CONTINUE                                                      CD 767
          JUPTR = J - 1                                                   CD 768
C  ******  MOVE ROW INDICES FROM Q TO JU, UPDATE VECTORS  **************  CD 769
  32      JUMIN = JUPTR + 1                                               CD 770
          IJU(K) = JUMIN                                                  CD 771
          IF (LUK .EQ. 0)  GO TO 34                                       CD 772
          JUPTR = JUPTR + LUK                                             CD 773
          IF (JUPTR .GT. JUMAX)  GO TO 106                                CD 774
            QM = Q(NP1)                                                   CD 775
            DO 33 J=JUMIN,JUPTR                                           CD 776
              QM = Q(QM)                                                  CD 777
  33          JU(J) = QM                                                  CD 778
  34      IRU(K) = IJU(K)                                                 CD 779
          IU(K+1) = IU(K) + LUK                                           CD 780
C                                                                         CD 781
C  ******  UPDATE IRU, JRU  ********************************************  CD 782
          I = K                                                           CD 783
  35        I1 = JRU(I)                                                   CD 784
            IF (R(I) .LT. 0)  GO TO 36                                    CD 785
            REND = IJU(I) + IU(I+1) - IU(I)                               CD 786
            IF (IRU(I) .GE. REND)  GO TO 37                               CD 787
              J = JU(IRU(I))                                              CD 788
              JRU(I) = JRU(J)                                             CD 789
              JRU(J) = I                                                  CD 790
              GO TO 37                                                    CD 791
  36        R(I) = -R(I)                                                  CD 792
  37        I = I1                                                        CD 793
            IF (I .EQ. 0)  GO TO 38                                       CD 794
            IRU(I) = IRU(I) + 1                                           CD 795
            GO TO 35                                                      CD 796
C                                                                         CD 797
C  ******  UPDATE IRA, JRA, IRAC  **************************************  CD 798
  38      I = IRAC(K)                                                     CD 799
          IF (I .EQ. 0)  GO TO 41                                         CD 800
  39        I1 = JRA(I)                                                   CD 801
            IRA(I) = IRA(I) + 1                                           CD 802
            IF (IRA(I) .GE. IA(R(I)+1))  GO TO 40                         CD 803
            IRAI = IRA(I)                                                 CD 804
            JAIRAI = IC(JA(IRAI))                                         CD 805
            IF (JAIRAI .GT. I)  GO TO 40                                  CD 806
            JRA(I) = IRAC(JAIRAI)                                         CD 807
            IRAC(JAIRAI) = I                                              CD 808
  40        I = I1                                                        CD 809
            IF (I .NE. 0)  GO TO 39                                       CD 810
  41      CONTINUE                                                        CD 811
C                                                                         CD 812
        IJL(N) = JLPTR                                                    CD 813
        IJU(N) = JUPTR                                                    CD 814
        FLAG = 0                                                          CD 815
        RETURN                                                            CD 816
C                                                                         CD 817
C ** ERROR:  NULL ROW IN A                                                CD 818
 101    FLAG = N + RK                                                     CD 819
        RETURN                                                            CD 820
C ** ERROR:  DUPLICATE ENTRY IN A                                         CD 821
 102    FLAG = 2*N + RK                                                   CD 822
        RETURN                                                            CD 823
C ** ERROR:  INSUFFICIENT STORAGE FOR JL                                  CD 824
 103    FLAG = 3*N + K                                                    CD 825
        RETURN                                                            CD 826
C ** ERROR:  NULL PIVOT                                                   CD 827
 105    FLAG = 5*N + K                                                    CD 828
        RETURN                                                            CD 829
C ** ERROR:  INSUFFICIENT STORAGE FOR JU                                  CD 830
 106    FLAG = 6*N + K                                                    CD 831
        RETURN                                                            CD 832
        END                                                               CD 833
