
#include "extern.h"

static 	int 			newtoncount;

do_one_iteration()
/* Do one Newton iteration.
If the curvatures are small enough, plot the range and return FALSE,
else return TRUE */
{
	int fixindx, tangent = 0;
#ifdef DEBUG
	fprintf(stderr," %d iterating...\n", newtoncount);
#endif

	mynewton(newtoncount);	/* Do one iteration of Newton's method */
	++newtoncount;

	if ((newtoncount > MAXITERATION)		
	|| (maxkappa < TINY))	{
	/* Plot range packing */	

		/* Given radii, find the centers of the circles; all centers are exterior to the unit disk */
		findcenters();	

		/* Invert the range packing into the unit disk */
		invert();
		/* Twist the nullcircle until it lies on the positive real axis */
		fixindx = nullj+nulli*width;
		twist(RCirc[fixindx].x, RCirc[fixindx].y);

		/* Do a Mobius self-map of the unit disk sending the nullcircle to the origin */
		linfract(RCirc[fixindx].x);

		/* Rotate the range packing so the circle immediately to the right of the domain nullcircle
		is centered on the positive real axis */
		twist(RCirc[fixindx+1].x, RCirc[fixindx+1].y);

		/* Scale the range circle centers and radii to the size of the rangewindow */
		scalecircs(RCirc, RANGERAD);

		/* Translate the range circle centers to the rangewindow */
		translate(RCirc, RANGERAD, RANGERAD);

		/* Draw the range packing in the range window */
		drawrange();

		newtoncount = 0;
		return(0);	/* Don't do any more Newton iterations */
	}
	else
		return(1);
} /* do_one_iteration */


guessrad(count)				/*Make initial radius guess*/
int	count;
{
	double 		initialguess, radsum;
	int 		a, b, i, j, indx, gindx, assigning, mypos[6][2], radcount;
	
	initialguess = sqrt ((double) DISKRAD/(4.0*numcircles));
	if (count == 0)	{
	/* make a constant initial guess */
		for (i=0; i<MAXHOLES; ++i) 
			DHole[i].r = 9.0*initialguess;
		for (i=0; i<hw; ++i) 
        		DCirc[i].r = -1.0;
		for (i=0; i<mynorm; ++i) 
    			DCirc[myindex[i]].r = initialguess;
	}
	else	{
	/* guess based on the previous run */
		for (i=0; i<MAXHOLES; ++i) {
			DHole[i].r = GHole[i].r;
			if (DHole[i].r <= 0.0)
				DHole[i].r = 0.01;
		}
		for (i=0; i<hw; ++i) {
        		DCirc[i].r = -1.0;
			RCirc[i] = DCirc[i];
			if (RCirc[i].state > 0)	RCirc[i].state = CANDIDATE;
		}
		/* assign previous radii to the even vertices in DCirc */
		for (a=0,i=0; (a<oldheight)&&(i<height); a++, i+=2) {
			for (b=0,j=0; (b<oldwidth)&&(j<width); b++, j+=2) {
				indx = j+i*width;
				gindx = b+a*oldwidth;
				if ((RCirc[indx].state > 0)
				&& (GCirc[gindx].state > 0))	{
					DCirc[indx].r = GCirc[gindx].r;
					RCirc[indx].state = INTERIOR;
				}
			}
		}
		/* first, interpolate new, interior vertices */
		for (i=0; i<height; i++) {
			for (j=0; j<width; j++) {
				indx = j+i*width;
				if (RCirc[indx].state == CANDIDATE)	{
					radsum = 0.0;
					radcount = 0;
					getccindices(i, j, mypos);
					for (a=0; a<6; ++a)	{
						gindx = mypos[a][1]+mypos[a][0]*width;
						if (RCirc[gindx].state == INTERIOR)	{
							radsum += DCirc[gindx].r;
							radcount++;
						}
					}
					if (radcount > 0)	{
						DCirc[indx].r = radsum/((double)radcount);
						RCirc[indx].state = DEEPINSIDE;
					}
				}
			}
		}
		/* assign averaged radii to the unassigned vertices in DCirc */
		assigning = TRUE;
		while(assigning)	{
			for (i=0; i<height; i++) {
				for (j=0; j<width; j++) {
					indx = j+i*width;
					if (RCirc[indx].state == CANDIDATE)	{
						radsum = 0.0;
						radcount = 0;
						getccindices(i, j, mypos);
						for (a=0; a<6; ++a)	{
							gindx = mypos[a][1]+mypos[a][0]*width;
							if (RCirc[gindx].state == INTERIOR)	{
								radsum += DCirc[gindx].r;
								radcount++;
							}
						}
						if (radcount > 0)	{
							DCirc[indx].r = radsum/((double)radcount);
							RCirc[indx].state = DEEPINSIDE;
						}
					}
				}
			}
			/* all at once, graduate the new ones to INTERIOR-hood */
			for (i=0; i<hw; ++i) 
				if (RCirc[i].state == DEEPINSIDE)	RCirc[i].state = INTERIOR;
			/* check for unassigned vertices */
			assigning = FALSE;
			for (i=0; i<mynorm; i++) {
				if (RCirc[myindex[i]].state == 1)	{
					assigning = TRUE;
					goto outside;
				}
			}
			outside:	;
		}
		/* scale down the initial guess */
		for (i=0; i<mynorm; ++i) 
    			DCirc[myindex[i]].r = DCirc[myindex[i]].r/2.0;
	}
	/* Fix two boundary radii */
	indx = fixradj+fixradi*width;
	DCirc[indx].r = DCirc[indx-1].r = DISKRAD;
	
	/* Take this out later */
	for (i=0; i<mynorm; ++i) {
    		if ((DCirc[myindex[i]].state > 0)	
    		&& (DCirc[myindex[i]].r <= 0.0))	{
    			DCirc[myindex[i]].r = 0.001;
		}
	}
} /*guessrad*/
				
