#include 	"extern.h"

/* All these functions perform Mobius transformations */

invert ()		/*Invert circles into the unit disk.	*/
{
	double 		u, v, z, r, e, f, length, denom;
	int 		i, j;
	
	for (i=0; i<mynorm; ++i) {
		u = RCirc[myindex[i]].x;
		v = RCirc[myindex[i]].y;
		z = RCirc[myindex[i]].r;
		r = u*u+v*v;
		denom = r-z*z;
		if (denom != 0.0)	{
			e = u/denom;
			f =  -v/denom;
			length = z/denom;
			RCirc[myindex[i]].x = -e;
			RCirc[myindex[i]].y = f;
			RCirc[myindex[i]].r = fabs(length);
		}
	} /*if*/
	/* Invert holes if the domain is multiply connected */
	for (i=0; i<numholes; ++i) {
		u = RHole[i].x;
		v = RHole[i].y;
		z = RHole[i].r;
		r = u*u+v*v;
		denom = r-z*z;
		if (denom != 0.0)	{
			e = u/denom;
			f =  -v/denom;
			length = z/denom;
			RHole[i].x = -e;
			RHole[i].y = f;
			RHole[i].r = fabs(length);
		}
	} /*for i*/
} /*invert*/

				
	
linfract (a)    
				/*Mobius map of the unit disk onto itself,*/
				/*sending the circle centered at a>0 to a circle centered at the origin. */
double		a;
{
	double 			c, x, u, v, h, k, r, s, lambda, rho, temp, rootvictim;
	double			xx, xh, hh, kk, rr;	/* intermediate products */
	int 			i, j;
	
	c = a;
	/* If nulli == 0 the nullpoint is a hole circle */
	if (nulli > 0)	r = RCirc[nullj+nulli*width].r;
	else	r = RHole[nullj].r;
	temp = 2*r- (1+r+c) * (1+r-c);
	rootvictim = (temp*temp-4*r*r);
	if (rootvictim<0)	rootvictim = fabs(rootvictim);
	rootvictim = sqrt(rootvictim);
	if ((-temp-rootvictim)/(2*r) > 0)	
		rho = (-temp-rootvictim)/(2*r);
	else	
		rho = (-temp+rootvictim)/(2*r);
	x = (2*r* (1+rho)+2*(c+r)*(c-r-1))/(2*(c-r-1)+2*r*(1+rho));
	/* x is the point that gets sent to the origin */
	xx = x*x;	

	for (i=0; i<mynorm; ++i) {
		h = RCirc[myindex[i]].x;
		k = RCirc[myindex[i]].y;
		r = RCirc[myindex[i]].r;
		hh = h*h;	
		kk = k*k;	
		xh = x*h; 	
		rr = r*r;
		u = (-x+h*xx+h-x*(hh+kk-rr))/(1.0-2.0*xh+(xx)*(hh+kk-rr));
		v = (k*xx-k)/(1.0-2.0*xh+(xx)*(hh+kk-rr));
		lambda = (-x/(xx)+h)*(-x/(xx)+h)+kk-rr;
		s = r*(1.0-xx)/(lambda*(xx));
		RCirc[myindex[i]].x = -u;
		RCirc[myindex[i]].y = v;
		RCirc[myindex[i]].r = fabs(s);
	} 
	/* Map holes if the domain is multiply connected */
	for (i=0; i<numholes; ++i) {
		h = RHole[i].x;
		k = RHole[i].y;
		r = RHole[i].r;
		hh = h*h;	
		kk = k*k;	
		xh = x*h; 	
		rr = r*r;
		u = (-x+h*xx+h-x*(hh+kk-rr))/(1.0-2.0*xh+(xx)*(hh+kk-rr));
		v = (k*xx-k)/(1.0-2.0*xh+(xx)*(hh+kk-rr));
		lambda = (-x/(xx)+h)*(-x/(xx)+h)+kk-rr;
		s = r*(1.0-xx)/(lambda*(xx));
		RHole[i].x = -u;
		RHole[i].y = v;
		RHole[i].r = fabs(s);
	} 
} /*linfract*/


scalecircs (mycirc, factor)	/* Scale circles of mycirc by factor. */
circleinfo	*mycirc;
double		factor;
{
	int 		i, j;
	
	for (i=0; i<mynorm; ++i) 	{
		RCirc[myindex[i]].x *= factor;
		RCirc[myindex[i]].y *= factor;
		RCirc[myindex[i]].r *= factor;
	} 
	if (mycirc == RCirc)
		for (i=0; i<numholes; ++i) {
			RHole[i].x *= factor;
			RHole[i].y *= factor;
			RHole[i].r *= factor;
		}
} /*scalecircs*/


translate (mycirc, a, b)
/* Translate coordinates of mycirc by (a, b).	*/
circleinfo		*mycirc;
double			a, b;
{
	int 		i, j;	
	
	for (i=0; i<mynorm; ++i) {
		mycirc[myindex[i]].x += a;
		mycirc[myindex[i]].y += b;
		RPlot[myindex[i]].x = mycirc[myindex[i]].x;
		RPlot[myindex[i]].y = mycirc[myindex[i]].y;
		RPlot[myindex[i]].state = mycirc[myindex[i]].state;
	} /*if*/
	if (mycirc == RCirc)		/* Translate holes */
		for (i=0; i<numholes; ++i) {
			RHole[i].x += a;
			RHole[i].y += b;
		}
} /*translate*/


twist (a, b)		/*Rotate the range packing until the point (a, b) lies on the positive real axis.*/
double		a, b;	
{
	double 			x, y, u, v, norm, theta, temp;
	int 			i, j;
	
	x = a;
	y = b;
	if ((x!=0) || (y!=0))	{
		theta = atan2(y, x);	/* theta is the rotation factor */
		for (i=0; i<mynorm; ++i) {
			u = RCirc[myindex[i]].x;
			v = RCirc[myindex[i]].y;
			if ((u!=0) || (v!=0))	{
				norm = sqrt(u*u+v*v);
				temp =  atan2(v, u)-theta;
				RCirc[myindex[i]].x = norm*cos(temp);
				RCirc[myindex[i]].y = norm*sin(temp);
			}
		}
		for (i=0; i<numholes; ++i) {
			u = RHole[i].x;
			v = RHole[i].y;
			if ((u!=0) || (v!=0))	{
				norm = sqrt(u*u+v*v);
				temp =  atan2(v, u)-theta;
				RHole[i].x = norm*cos(temp);
				RHole[i].y = norm*sin(temp);
			}
		} 
	}
} /*twist*/

