
#include "extern.h"

/* Functions used only in Thurston boundary modification */

assignxangles()
/* Determine intersection angles in the domain. */
{
	extern		edgeinfo		*myedge;

	int	i, j, k, indx, n, edgecount = 0;
	int 	pos[6][2], cnc, cnn;
	double	enorm, maxe, x1, y1, x2, y2, a, b, c, phi;

	c = 2.0*fillrad*fillrad;
	maxe = 2.0*c;

	for (i=0; i<height; ++i) {
		for (j=0; j<width; ++j) {
			indx = j+i*width;
			if (DCirc[indx].state > INTERIOR) {

				x1 = DCirc[indx].x;
				y1 = DCirc[indx].y;
				getccindices (i, j, pos);
				for (n=0; n<6; ++n)	{
					k = pos[n][1]+pos[n][0]*width;
					if (DCirc[k].state > OUTSIDE)	{
					/* This neighbor lies in the region */
						x2 = DCirc[k].x;
						y2 = DCirc[k].y;
						a = x2-x1;
						b = y2-y1;
						enorm = a*a + b*b;
						cnc = DCirc[indx].cnum;
						cnn = DCirc[k].cnum;
						/* Edges are stored as ordered pairs (cnum1,cnum2) of cnums;
						cnum1 must be less than cnum2 */
						if (cnc < cnn)	{
							myedge[edgecount].cnum1 = cnc;
							myedge[edgecount].cnum2 = cnn;
						}	
						else	{
							myedge[edgecount].cnum1 = cnn;
							myedge[edgecount].cnum2 = cnc;
						}	
						if (enorm < maxe)
						/* circles intersect; otherwise, leave zero edge angle */
							myedge[edgecount].angle = PI - acos((c-enorm)/c);
						++edgecount;

						/* Check memory */
						if (edgecount >= normbdry)	{
							printf("Insufficient memory allocated for edges.\n");
							printf("Must increase the constant AVE_EDGES in mapdefs.h to 5.0.\n");
							exit(1);
						}
					}
				}
			} 
		} 
	} 
} /*assignxangles*/

double	getxangle(cnuma, cnumb)
/* Return intersection angle assigned to edge connecting circles indexed cnuma, cnumb. */
int	cnuma, cnumb;
{
	extern		edgeinfo		*myedge;

	int	i;
	double	myxangle;

	/* cnuma must be less than cnumb */
	if (cnuma > cnumb)	{
		i = cnumb;
		cnumb = cnuma;
		cnuma = i;
	}

	if (cnuma <= 0)	{
	/* No intersection angle stored; return 0.0 for tangency */
		return(0.0);
	}
	else	{
		myxangle = 0.0;
		/* Scan myedge[] for the edge (cnuma,cnumb) */
		for (i=0; i<normbdry; ++i) {
			if ((myedge[i].cnum1 == cnuma) 
			&& (myedge[i].cnum2 == cnumb)) 	{
			/* Found the intersection angle */
				myxangle = myedge[i].angle;
				goto	outer;
			}
		} 
		outer:	return(myxangle);
	}
} /*getxangle*/

getdeepin()	{
/* Called when in THURSTONMODE to identify those inner circles whose only neighbors are inner circles.*/
	extern		circleinfo		*DCirc;
	extern		int			width, height;
	
	int		mynbrs[6], mypos[6][2], i, j, n, mystate, indx;
	Bool		deepin;
	
	for (i=1; i<height-1; ++i) {
		for (j=1; j<width-1; ++j) {
			indx = j+i*width;
			mystate = DCirc[indx].state;
			if (mystate == INTERIOR)	{	/* At an inner circle */
				deepin = TRUE;
				getccindices(i, j, mypos);
				for (n=0; n<NUMNBRS; ++n)	{
					mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
					if (mynbrs[n] >= OUTERBDRY) 		/* A neighbor is a border circle */
						deepin = FALSE;
				}
				if (deepin)	/* Change state label appropriately */
					DCirc[indx].state = DEEPINSIDE;
			} 
		}
	}
} /*getdeepin*/
