
/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *  Written by Steve Anderson and Toby Orloff, summer 1990.
 */

#include "omni_proc.h"

Parse (argc,argv)
int argc;
char **argv;
{
  int i, j, round, listlength, argc2;
  FILE *fp;
  char *argv2[40];
  char argv3[40][20];

  if (argc < 3) {
    Usage (argv);
    exit (1);
  }

  for (i=1; i<argc;) {

    if (strcmp (argv[i], "-debug") == 0) {
      debug = 1;
      printf ("Debug activated.\n");
      remove_arg (i, &argc, argv);
      continue ;
    }

    if ((strcmp (argv[i],"-all") == 0) && (type == ASCII)) {
      target = FLOAT_AND_INT;
      if (debug) printf ("Target set to both floats and integers.\n");
      remove_arg (i, &argc, argv);
      continue ;
    }

    if ((strcmp (argv[i],"-float") == 0) && (type == ASCII)) {
      target = FLOAT_NOT_INT;
      if (debug) printf ("Target set to floats only.\n");
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i],"-int") == 0) {
      target = INT_NOT_FLOAT;
      if (debug) printf ("Target set to ints only.\n");
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i],"-bin") == 0) {
      type = BINARY;
      if (debug) printf ("Set to receive binary file.\n");
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i], "-tag") == 0) {
      if (!increment (i, &argc, argv)) {
	fprintf (stderr, "%s: tag must be followed by argument.\n", argv[0]);
	exit (1);
      }
      sprintf (tag, "%s", argv[i]);
      if (debug) printf ("Tag on target values is %s.\n");
      remove_arg (i, &argc, argv);
      continue;
    }

    if (strcmp (argv[i], "-tail") == 0) {
      if (!increment (i, &argc, argv) || (is_an_int(argv[i]) == 0) || ((tail = atoi (argv[i])) < -1)) {
	fprintf (stderr, "%s: tail must precede positive integer.\n", argv[0]);
        exit (1);
      }
      remove_arg (i, &argc, argv);
      continue;
    }

    if (strcmp (argv[i],"-skip") == 0) {
      if (!increment (i, &argc, argv) || (is_an_int(argv[i]) == 0) || ((skip = atoi (argv[i])) < 0)) {
	fprintf (stderr, "%s: -skip must be followed by ",argv[0]);
	fprintf (stderr, "a nonnegative integer.  Stop.\n");
	exit (1);
      }
      if (debug) printf ("Will skip and copy first %d lines.\n", skip);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i],"-chunk") == 0) {
      if (!increment (i, &argc, argv) || (is_an_int(argv[i]) == 0) || ((chunk = atoi (argv[i])) < 0)) {
	fprintf (stderr, "%s: -chunk must be followed by ",argv[0]);
	fprintf (stderr, "a positive integer.  Stop.\n");
	exit (1);
      }
      if (debug) printf ("Will process numbers in chunks of %d.\n", chunk);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if ((strcmp (argv[i],"-round") == 0) || (strcmp (argv[i],"-trunc") == 0)) {
      if (!increment (i, &argc, argv) || (is_an_int(argv[i]) == 0) || ((round = atoi (argv[i])) < 0)) {
	fprintf (stderr, "%s: %s must be followed by ",argv[0], argv[i-1]);
	fprintf (stderr, "a nonnegative integer.  Stop.\n");
	exit (1);
      }
      sprintf (fformat, "%%1.%df",round);
      if (debug) printf ("Will round off floating pt output to %d decimal places.\n", round);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i],"-F") == 0) {
      if (!increment (i, &argc, argv) || !is_an_int(argv[i]) || ((listlength = atoi (argv[i])) < 1)) {
	fprintf (stderr, "%s: -F must be followed by a positive ",argv[0]);
	fprintf (stderr, "integer and a series of floats.  Stop.\n");
	exit (1);
      }
      if (listlength>FMAX) {
	fprintf (stderr, "%s: -F cannot handle more than %d values.  Stop.\n",argv[0], FMAX);
        exit (1);
      }
      for (j=0; j<listlength; j++) {
	if (!(increment (i, &argc, argv)) || !(is_a_float(argv[i]))) {
	  fprintf (stderr, "%s: -F %d must be followed ", argv[0], listlength);
	  fprintf (stderr, "by %d floats.  Stop.\n", listlength);
	  exit (1);
	}
	F[j] = atof (argv[i]);
	if (debug) printf ("Setting F[%d] to %f.\n",j,F[j]);
      }
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i],"-dF") == 0) {
      if (!increment (i, &argc, argv) || !is_an_int(argv[i]) || ((listlength = atoi (argv[i])) < 1)) {
	fprintf (stderr, "%s: -dF must be followed by a positive ",argv[0]);
	fprintf (stderr, "integer and a series of floats.  Stop.\n");
	exit (1);
      }
      if (listlength>FMAX) {
	fprintf (stderr, "%s: -dF cannot handle more than %d values.  Stop.\n",argv[0], FMAX);
        exit (1);
      }
      for (j=0; j<listlength; j++) {
	if (!(increment (i, &argc, argv)) || !(is_a_float(argv[i]))) {
	  fprintf (stderr, "%s: -dF %d must be followed ", argv[0], listlength);
	  fprintf (stderr, "by %d floats.  Stop.\n", listlength);
	  exit (1);
	}
	dF[j] = atof (argv[i]);
	if (debug) printf ("Setting dF[%d] to %f.\n",j,dF[j]);
      }
      remove_arg (i, &argc, argv);
      continue ;
    }

    if ((strncmp (argv[i], "-F", 2) == 0) && (is_an_int(argv[i]+2))) {
      j = atoi (argv[i]+2);
      if (j<0 || j>9) {
	fprintf (stderr,"%s: The floating point contstants are ",argv[0]);
	fprintf (stderr,"numbered 0-9.  Stop.\n");
	exit (1);
      }
      if (!increment (i,&argc, argv) || !is_a_float (argv[i])) {
	fprintf (stderr, "%s: -F%d must be followed by ",argv[0], j);
	fprintf (stderr, "a floating-point number.  Stop.\n");
	exit (1);
      }
      F[j] = atof (argv[i]);
      if (debug) printf ("Setting F[%d] to %f.\n",j,F[j]);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if ((strncmp (argv[i], "-dF", 3) == 0) && (is_an_int(argv[i]+3))) {
      j = atoi (argv[i]+3);
      if (j<0 || j>9) {
	fprintf (stderr,"%s: The floating point constants are ",argv[0]);
	fprintf (stderr,"numbered 0-9.  Stop.\n");
	exit (1);
      }
      if (!increment (i,&argc, argv) || !is_a_float (argv[i])) {
	fprintf (stderr, "%s: %s must be followed by ",argv[0], argv[i-1]);
	fprintf (stderr, "a floating-point number.  Stop.\n");
	exit (1);
      }
      dF[j] = atof (argv[i]);
      if (debug) printf ("Setting dF[%d] to %f.\n",j,dF[j]);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i], "-animate") == 0) {
      remove_arg (i, &argc, argv);
      if (is_an_int(argv[i]) && (i<argc)) {
	frames = atoi (argv[i]);
	if (frames<0) {
	  fprintf (stderr, "%s: -animate cannot be followed by a ", argv[0]);
	  fprintf (stderr, "negative number.  Not using animation.\n");
	  frames = 0;
	}
	remove_arg (i, &argc, argv);
      } else frames = 10;
      if (debug) printf ("Entering animation mode, %d frames.\n", frames);
      continue ;
    }

    if (strcmp (argv[i], "-suffix") == 0) {
      increment (i, &argc, argv);
      sprintf (suffix, ".%s", argv[i]);
      if (debug) printf ("Setting output suffix to %s\n", suffix);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i], "-read") == 0) {
      if (!increment (i, &argc, argv)) {
	fprintf (stderr, "%s: -read must precede a file name.  Stop.\n", argv[0]);
	exit (1);
      }
      if ((fp = fopen (argv[i],"r")) == NULL) {
	fprintf (stderr, "%s: Cannot open file %s.  Stop.\n", argv[0], argv[i]);
	exit (1);
      }
      argc2 = 1;
      while (EOF != (fscanf (fp, "%s", argv3[argc2++])));
      argc2--;  /* Correct for extra pass before finding EOF */
         /*  Extra problem is that it is convenient to use a 2-dimensional
             array to store things (argv3), but we must pass an array of
             pointers to strings to Parse. (argv2).  Here they are linked. */
      argc2 += 2;
      sprintf (argv3[argc2-2], "-");
      sprintf (argv3[argc2-1], "-");
      for (j=1; j<argc2; j++) argv2[j] = argv3[j];
      argv2[0] = argv[0];             /* Keep progname, filenames the same */
      if (debug) printf ("Now parsing file %s.\n", argv[i]);
      Parse (argc2, argv2);
      fclose (fp);
      remove_arg (i, &argc, argv);
      continue ;
    }

    if (strcmp (argv[i], "-A") == 0) {
      increment (i, &argc, argv);
      if (!is_a_float (argv[i])) {
	fprintf (stderr, "%s: -A must precede a number. Stop.\n", argv[0]);
	exit (1);
      }
      A = atof (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("A = %f\n", A);
      continue ;
    }

    if (strcmp (argv[i], "-B") == 0) {
      increment (i, &argc, argv);
      if (!is_a_float (argv[i])) {
	fprintf (stderr, "%s: -B must precede a number. Stop.\n", argv[0]);
	exit (1);
      }
      B = atof (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("B = %f\n", B);
      continue ;
    }

    if (strcmp (argv[i], "-C") == 0) {
      increment (i, &argc, argv);
      if (!is_a_float (argv[i])) {
	fprintf (stderr, "%s: -C must precede a number. Stop.\n", argv[0]);
	exit (1);
      }
      C = atof (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("C = %f\n", C);
      continue ;
    }

    if (strcmp (argv[i], "-D") == 0) {
      increment (i, &argc, argv);
      if (!is_a_float (argv[i])) {
	fprintf (stderr, "%s: -D must precede a number. Stop.\n", argv[0]);
	exit (1);
      }
      D = atof (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("D = %f\n", D);
      continue ;
    }

    if (strcmp (argv[i], "-E") == 0) {
      increment (i, &argc, argv);
      if (!is_a_float (argv[i])) {
	fprintf (stderr, "%s: -E must precede a number. Stop.\n", argv[0]);
	exit (1);
      }
      E = atof (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("E = %f\n", E);
      continue ;
    }

    if (strcmp (argv[i], "-J") == 0) {
      increment (i, &argc, argv);
      if (!is_an_int (argv[i])) {
	fprintf (stderr, "%s: -J must precede an integer.  Stop.\n", argv[0]);
	exit (1);
      }
      J = atol (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("J = %d\n", J);
      continue ;
    }

    if (strcmp (argv[i], "-K") == 0) {
      increment (i, &argc, argv);
      if (!is_an_int (argv[i])) {
	fprintf (stderr, "%s: -K must precede an integer.  Stop.\n", argv[0]);
	exit (1);
      }
      K = atol (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("K = %d\n", K);
      continue ;
    }

    if (strcmp (argv[i], "-L") == 0) {
      increment (i, &argc, argv);
      if (!is_an_int (argv[i])) {
	fprintf (stderr, "%s: -L must precede an integer.  Stop.\n", argv[0]);
	exit (1);
      }
      L = atol (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("L = %d\n", L);
      continue ;
    }

    if (strcmp (argv[i], "-M") == 0) {
      increment (i, &argc, argv);
      if (!is_an_int (argv[i])) {
	fprintf (stderr, "%s: -M must precede an integer.  Stop.\n", argv[0]);
	exit (1);
      }
      M = atol (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("M = %d\n", M);
      continue ;
    }

    if (strcmp (argv[i], "-N") == 0) {
      increment (i, &argc, argv);
      if (!is_an_int (argv[i])) {
	fprintf (stderr, "%s: -N must precede an integer.  Stop.\n", argv[0]);
	exit (1);
      }
      N = atol (argv[i]);
      remove_arg (i, &argc, argv);
      if (debug) printf ("N = %d\n", N);
      continue ;
    }

    i++;
  }
  for (i=0; i<FMAX; i++) oF[i] = F[i];
  sprintf (outfileroot, "%s", outfilename);
  if (type==BINARY) target = INT_NOT_FLOAT;
}

increment (i, argc, argv)
int i, *argc;
char **argv;
{
  if (i+1 != *argc) {
    remove_arg (i, argc, argv);
    return 1;
  }
  return 0;
}

remove_arg (i, argc, argv)
int i, *argc;
char **argv;
{
  int j;

  if (*argc-1 < 3) {
    Usage (argv);
    exit(1);
  }
  *argc -= 1;
  for (j=i; j < *argc; j++) {
    argv[j] = argv[j+1];
    if (debug) printf ("%s ", argv[j]);
  }
  if (debug) printf ("\n");
}
