/****
   omni_interp_make.c:  program to build custom versions of "omni_interp".
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

/*	This program automates the process of creating
 *	variations of omni_interp with user-defined
 *	functions.
 *
 *	The calling sequence is
 *		omni_interp_make <sourcefile> <targetname> <compiler-options>
 *	The program scans the source file to see what functions are
 *	provided (user_interp *must* be provided, optional ones are
 *	global_init, global_begin, global_end, and usage), and links
 *	in the necessary object files from OBJ_DIR.  The include files
 *	are in INC_DIR.  These two macros are set when this program is
 *	compiled for the local configuration.
 *
 *	Most of this code is inspired by Steve Anderson's constructor
 *	program for his "omni_proc".  - JSL
 */

#include <stdio.h>
#include <string.h>

char infile[256], outfile[256];	/* File names. */
char *progname;			/* Name of this program */
char target_name[256];		/* Name of target program */

int usage_present;		/* Message: usage () */
int init_present;		/* Initialization:  global_init () */
int begin_present;		/* global_begin () */
int end_present;		/* global_end () */

main (argc, argv)
     int argc;
     char **argv;
{
  int i;
  char compile_buf[600];	/* compile command buffer */
  char link_buf[500];		/* link command buffer */

  progname = argv[0];

  Initialize_globals ();
  Parse_args (argc, argv);
  Check_presence (argv);

  /* Compile user's module to object format. */
  sprintf (compile_buf, "cc -c -g -I%s %s", INC_DIR, infile);
  execute (compile_buf);

  /* Convert source name to object file name. */
  infile[strlen (infile) - 1] = 'o';

  /* Create command for linking */
  sprintf (link_buf, "%s/mn.o %s/init.o %s/util.o %s/standard_interp.o %s",
	   OBJ_DIR, OBJ_DIR, OBJ_DIR, OBJ_DIR, infile);
  if (!usage_present)
    sprintf (link_buf, "%s %s/usage.o", link_buf, OBJ_DIR);
  if (!init_present)
    sprintf (link_buf, "%s %s/global_init.o", link_buf, OBJ_DIR);
  if (!begin_present)
    sprintf (link_buf, "%s %s/global_begin.o", link_buf, OBJ_DIR);
  if (!end_present)
    sprintf (link_buf, "%s %s/global_end.o", link_buf, OBJ_DIR);

  sprintf (compile_buf, "cc -g -o %s %s -lm", target_name, link_buf);

  for (i = 3; i < argc; i++)
    sprintf (compile_buf, "%s %s", compile_buf, argv[i]);
  execute (compile_buf);
}


Initialize_globals ()
{
  int i;

  usage_present = 0;
  init_present = 0;
  begin_present = 0;
  end_present = 0;
}


Parse_args (argc, argv)
     int argc;
     char *argv[];
{
  if (argc < 2)
    {
      fprintf (stderr,
	       "Usage: %s <filename.c> <targetname> [compiler options]\n",
	       progname);
      fprintf (stderr, "(Note that filename.c must be the first argument!)\n");
      exit (1);
    }
  if (strcmp (argv[1] + strlen (argv[1]) - 2, ".c"))
    {
      fprintf (stderr, "%s: function file name must end in .c\n",progname);
      exit (1);
    }
  sprintf (infile, argv[1]);
  sprintf (target_name, argv[2]);
}


execute (command)
     char *command;
{
  fprintf (stderr, "%s\n",command);
  if (system (command))
    {
      fprintf (stderr, "%s:  error - stopping program.\n", progname);
      exit (1);
    }
}


Check_presence (argv)
     char *argv[];
{
  FILE *fp;
  char line[25];
  int interp_present;

  if (!(fp = fopen (infile, "r")))
    {
      fprintf (stderr,
	       "%s: Cannot open input file %s for examination.  Stop.\n",
	       progname, infile);
      exit (1);
    }
  while (fgets (line, 24, fp))
    {
      if (strncmp (line, "user_interp", 11) == 0)
	interp_present = 1;
      if (strncmp (line, "usage", 5) == 0)
	usage_present = 1;
      if (strncmp (line, "global_init", 11) == 0)
	init_present = 1;
      if (strncmp (line, "global_begin", 12) == 0)
	begin_present = 1;
      if (strncmp (line, "global_end", 10) == 0)
	end_present = 1;
    }
  fclose (fp);
  if (!interp_present)
    {
      fprintf (stderr,
	       "%s:  Source file %s does not have function user_interp.\n",
	       progname, infile);
      fprintf (stderr, "(Remember that function names must be on the left margin!)\n");
      exit (1);
    }
}
