/****
   init.c:  The initialization routines for "omni_interp".
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

#include <stdio.h>
#include "types.h"
#include "globals.h"

double atof ();


/*	Initialize all global variables to default values.
 */

InitializeInterp ()
{
  type = ASCII;
  bytes = 1;
#ifdef USER_FUN
  style = USER;
#else /* not USER_FUN */
  style = LINEAR;
#endif /* not USER_FUN */
  skip = 0;
  data_chunk = 1;
  file_chunk = 1000;
  integer = 0;
  suffix[0] = '\0';
  number = 10;
  num_in = -1;			/* To be set later */
  num_out = -1;
}


/*	Process the command line, and echo changes to stdout.
 */

ProcessInterpCommandLine (argc, argv, recursion)
     int *argc;
     char *argv[];
     int recursion;		/* Is this a recursive funciton call? */
{
  int i,j;

  if (!recursion)
    progname = argv[0];		/* Get program name form command line. */

  for (i=0; i<*argc; ++i)	/* loop through argument list */
    {
      if (strcmp ("-LINEAR", argv[i]) == 0)
	{
	  style = LINEAR;
	  fprintf (stderr, "%s: style changed to LINEAR.\n", progname);

	  for(j=i+1; j<*argc; ++j) /* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}

      if (strcmp ("-CARDINAL", argv[i]) == 0)
	{
	  style = CARDINAL;
	  fprintf (stderr, "%s: style changed to CARDINAL.\n", progname);

	  for(j=i+1;j<*argc;++j)	/* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}

#ifdef USER_FUN
      if (strcmp ("-USER", argv[i]) == 0)
	{
	  style = USER;
	  fprintf (stderr, "%s: style changed to USER.\n", progname);

	  for(j=i+1;j<*argc;++j)	/* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}
#endif /* USER_FUN */

      if (strcmp ("-ASCII", argv[i]) == 0)
	{
	  type = ASCII;
	  fprintf(stderr, "%s: file type changed to type ASCII.\n", progname); 

	  for(j=i+1;j<*argc;++j)	/* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}

      if (strcmp ("-BINARY", argv[i]) == 0)
	{
	  type = BINARY;
	  fprintf(stderr,"%s: file type changed to type BINARY.\n", progname); 

	  for (j=i+1;j<*argc;++j)	/* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}

      if (strcmp ("-all", argv[i]) == 0)
	{
	  integer = 1;
	  fprintf (stderr, "%s: interpolating integers.\n", progname);

	  for (j=i+1; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-1] = argv[j];
	  *argc -= 1;
	  i--;

	  continue;
	}

        
      if (strcmp ("-skip",argv[i]) == 0)
	{
	  skip = atoi(argv[i+1]);
	  fprintf (stderr, "%s: skip changed to %d.\n", progname, skip);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;

	  continue;
	}

      if (strcmp ("-data_chunk", argv[i]) == 0)
	{
	  data_chunk = atoi (argv[i+1]);
	  fprintf (stderr, "%s: data_chunk changed to %d.\n",
		 progname, data_chunk);

	  for (j = i + 2; j < *argc; j++) /* Update i, argc and argv */
	    argv[j - 2] = argv[j];
	  *argc -= 2;
	  i--;

	  continue;
	}

      if (strcmp ("-file_chunk", argv[i]) == 0)
	{
	  file_chunk = atoi(argv[i+1]);
	  fprintf (stderr, "%s: file_chunk changed to %d.\n", progname,
		file_chunk);

	  for(j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;

	  continue;
	}

      if (strcmp ("-number",argv[i]) == 0)
	{
	  if (num_out == -1)		/* Otherwise ignore this setting */
	    {
	      number = atoi(argv[i+1]);
	      fprintf(stderr, "%s: number changed to %d.\n", progname, number);
	    }

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;

	  continue;
	}

      if (strcmp ("-suffix", argv[i]) == 0)
	{
	  strcpy(suffix,argv[i+1]);
	  fprintf(stderr, "%s: suffix changed to %s.\n", progname, suffix);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;

	  continue;
	}

      if (strcmp ("-in_time", argv[i]) == 0)
	{
	  num_in = atoi(argv[i+1]);
	  if (num_in < 2)
	    {
	      fprintf(stderr, "%s: Impossible number of input files.\n",
		      progname);
	      usage ();
	      exit(0);
	    }

	  in_time = (double *) malloc(num_in * sizeof(double));

	  for (j=0; j<num_in; ++j)
	    in_time[j] = atof(argv[i+2+j]);

	  for (j=i+2+num_in; j<*argc; ++j) /* Update i, argc and argv */
	    argv[j-2-num_in] = argv[j];
	  *argc -= num_in + 2;
	  i--;

	  continue;
	}

      if (strcmp ("-out_time", argv[i]) == 0)
	{
	  num_out = atoi(argv[i+1]);
	  number = num_out;
	  if (num_out < 1)
	    {
	      fprintf(stderr, "%s: Impossible number of output files.\n",
		      progname);
	      usage ();
	      exit(0);
	    }

	  out_time = (double *) malloc(num_out * sizeof(double));

	  for(j=0;j<num_out;++j)
	    out_time[j] = atof(argv[i+2+j]);

	  for (j=i+2+num_out; j<*argc; ++j) /* Update i, argc and argv */
	    argv[j-2-num_out] = argv[j];
	  *argc -= num_out + 2;
	  i--;

	  continue;
	}

#ifdef USER_FUN
      if (strcmp ("-A", argv[i]) == 0)
	{
	  A = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting A to %lf.\n", progname, A);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}

      if (strcmp ("-B", argv[i]) == 0)
	{
	  B = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting B  to %lf.\n", progname, B);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}

      if (strcmp ("-C", argv[i]) == 0)
	{
	  C = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting C to %lf.\n", progname, C);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}

      if (strcmp ("-D", argv[i]) == 0)
	{
	  D = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting D to %lf.\n", progname, D);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}

      if (strcmp ("-E", argv[i]) == 0)
	{
	  E = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting E to %lf.\n", progname, E);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}

      if (strcmp ("-F", argv[i]) == 0)
	{
	  F = atof (argv[i + 1]);
	  fprintf (stderr, "%s: setting F to %lf.\n", progname, F);

	  for (j=i+2; j<*argc; ++j)	/* Update i, argc and argv */
	    argv[j-2] = argv[j];
	  *argc -= 2;
	  i--;
	}
#endif /* USER_FUN */

      if (strcmp ("-read", argv[i]) == 0)
	{
	  FILE *fp;
	  int argc2, j;
	  char *argv2[200];	/* Hardcoded values are bogus.  Fix this. */
	  char argv3[200][40];

	  fp = fopen (argv [i+1], "r");
	  if (!fp)
	    {
	      fprintf (stderr, "%s:  couldn't open file %s.\n",
		       progname, argv [i+1]);
	      exit (1);
	    }
	  fprintf (stderr, "%s:  reading file %s...\n",
		   progname, argv [i+1]);

	  argc2 = 1;
	  while ((fscanf (fp, "%s", argv3 [argc2++])) != EOF)
	    ;
	  argc2--;		/* Corrent for extra pass before findig EOF. */

	  for (j = 1; j < argc2; j++)
	    argv2 [j] = argv3 [j];

	  argv2 [0] = argv [0];
	  ProcessInterpCommandLine (&argc2, argv2, 1);
	  close (fp);

	  for (j = i+2; j < *argc; j++)
	    argv [j-2] = argv [j];
	  *argc -= 2;
	  i--;

	  continue;
	}
    }					/* End parsing command line. */


  /* Initialize in and out times if necessary */

  if (!recursion && *argc < 4)		/* Not enough arguments */
    return;

  if (num_in == -1)			/* Set it now */
    {
      num_in = (*argc) - 2;
      in_time = (double *) malloc(num_in * sizeof(double));

      /* Distribute evenly for now */

      for (i=0; i<num_in; ++i)
        in_time[i] = (double) i;
    }

  if (!recursion && num_in != *argc - 2)
    {
      fprintf (stderr, "%s: Incorrect number of input files.\n", progname);
      usage ();
      exit (0);
    }

  if (num_out == -1)			/* Out times need to be set */
    {
      num_out = number;
      out_time = (double *) malloc(number * sizeof(double));

      /* Distribute evenly between in_times  */

      for (i=0;i<number;++i)
        out_time[i] = (double) i * (double) (num_in-1) / (double) (number-1);
    }
}
