/*
### determine color for each orbit computed ###

Return: color (always >0): color=-1 for error and no drawing
*/

#define COLORMAP_DEPTH 1
#define COLORMAP_NLDEPTH 2
#define COLORMAP_TIME 6  /* colormap_option */

int
pen_mode(w_var, iter)
double w_var[];
int iter;
{
	int color;
	extern int int_driver,mapping_on,i_start,i_max,i_step,show_transient,forward_toggle;
	extern int var_colormap_size,colormap_option,colorcode_depth_index,cur_color,symbol_type,f_color,ft_color,b_color,bt_color;
	extern double colorcode_min,colorcode_max,time,int_start,int_end;

	if (iter > i_start || show_transient) {
		if (iter % i_step == 0){
			if(colormap_option == COLORMAP_DEPTH || colormap_option == COLORMAP_NLDEPTH) {
				if (w_var[colorcode_depth_index] < colorcode_min)
					color = 1;
				else if (w_var[colorcode_depth_index] > colorcode_max)
					color = var_colormap_size - 2;
				else
					color = 1 + (var_colormap_size - 2) * (w_var[colorcode_depth_index] - colorcode_min) / (colorcode_max - colorcode_min);
				return (color);
			}
			else if(colormap_option == COLORMAP_TIME) {
				if(int_driver==0 || mapping_on){
					if (iter < i_start )
						color = 1;
					else
						color = 1 + (var_colormap_size - 2) * (iter - i_start) / (i_max - i_start);
				}
				else {
					if(time <int_start)
						color = 1;
					else 
						color = 1 + (var_colormap_size - 2) * (time - int_start ) / (int_end - int_start);
				}
				return (color);
			}
			else { 		
				/* all colors for these colormap_options
				are predefined in compute_orbit() */
				if (iter > i_start) {
					if(forward_toggle==1)
						return(f_color);
					else
						return(b_color);
				}
				else {
					if(forward_toggle==1)
						return(ft_color);
					else
						return(bt_color);
				}
			}
		}
		else
			return (-1);
	}
	else
		return (-1);
}
