/*
### load window parameter header from a given file ###
*/

#include <stdio.h>

load_param_new(ffp)
FILE *ffp;
{
	int i,j,aux_max_new,ds_class_loaded,model_loaded,var_dim_loaded,param_dim_loaded,func_dim_loaded;
	extern int new_data_format,big_length,func_on,clipping,more_digits_on,symbol_size,symbol_type,cur_color;

	extern int aux_max,*aux_on,*aux_win_mode,**aux_cur_index;
	extern double **aux_x_min,**aux_x_max;

	extern int ds_class_old,model_old,func_on_old,polar_coord_old;
	extern int var_dim,func_dim,param_dim,full_dim,func_dim_max;
	extern int n_displayed_data1,n_displayed_data0,ds_class,var_dim,param_dim;
	extern int model,int_algorithm,polar_coord,draw_all,show_transient,dot_size,invert_background,colormap_option,colorcode_depth_index;
	extern int i_start,i_step,i_max;
	extern int var_cur_index[],param_cur_index[];
	extern int save_option,polar_section,linear_interpolation,section_index,n_poincare;
	extern double colorcode_min,colorcode_max,time_step,section_constant;
	extern double *param,*win_var_i,*win_var_f,*all_min,*all_max;
	extern double *all_min_top,*all_max_top,*func_min_top,*func_max_top;
	extern double average_return_time,*func_i,*func_f;
	extern char lstring[],string[];

	/*-------------------- DS flags --------------------------------*/

	fgets(lstring,big_length,ffp);
	fgets(lstring,big_length,ffp);
	sscanf(lstring, "%*s %*s %d %d %d %d %d",&ds_class_loaded,&model_loaded,&var_dim_loaded,&param_dim_loaded,&func_dim_loaded);
	if(ds_class != ds_class_loaded){
		sprintf(lstring,"Inconsistency in Loading! Installed DS Class=%d", Loaded DS Class=%d",&ds_class,&ds_class_loaded);
		system_mess_proc(1,lstring);
		sprintf(lstring,"Either reinstall new DS class or edit the
		header of DS being loaded DS");
		system_mess_proc(0,lstring);
		stop = 1;
		return;
	}
	fgets(lstring,big_length,ffp);
	scanf(lstring,"%*s %*s %d %d %d %d %d",&ds_map,&ds_hamiltonian,&ds_invertible,&ds_symmetry,&ds_smooth,&ds_

	/*-------------------- kaos flags --------------------------------*/

	sscanf(lstring,"%*s %*s %d",func_on_loaded);

	/* check model and install a new one if necessary */
	if(model != model_loaded){
		/* reset model */
		model = model_loaded;
		sprintf(string,"A NEW model is being loaded...");
		system_mess_proc(0,string);
		(void) model_init();
	}
	/* take care of function feature */
	else if(func_on_old != func_on)
		(void) func_init();
	/* take care of polar coordinate feature */
	else if(polar_coord_old != polar_coord)
		(void) reset_params();
		
	/* check if the loaded dimensions are consistent with installed
	ones */
	if(var_dim != var_dim_loaded){
		sprintf(string,"Inconsistency in loading model=%d! Installed phase space dim=%d, Loaded phase space dim=%d",model,var_dim,var_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}
	else if(param_dim != param_dim_loaded){
		sprintf(string,"Inconsistency in loading model=%d! Installed param space dim=%d, Loaded param space dim=%d",model,param_dim,param_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}
	else if(func_dim != func_dim_loaded){
		sprintf(string,"Inconsistency in loading model=%d! Installed func space dim=%d, Loaded func space dim=%d",model,func_dim,func_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}

	/*-------------------- graphic flags --------------------------------*/

	fscanf(ffp, "%*s %*s %d %d %d %d %d %d %d %d",
		&int_algorithm, &polar_coord, &draw_all, &show_transient, &dot_size, &invert_background, &colormap_option, &colorcode_depth_index);
	fscanf(ffp, "%*s %*s %lg %lg", &colorcode_min, &colorcode_max);

	fscanf(ffp,"%*s %*s %d %d %d %d %d",&clipping,&more_digits_on,&symbol_type,&symbol_size,&cur_color);

	fscanf(ffp, "%*s %*s %d", &save_option);

	fscanf(ffp, "%*s %*s %d %d %d %d %lg", &polar_section, &linear_interpolation, &section_index, &n_poincare, &section_constant);

	fscanf(ffp, "%*s %*s %d %lg %lg %lg %lg %lg", &n_displayed_data1, &average_return_time, &func_i[0], &func_f[0], &func_i[1], &func_f[1]);

	fscanf(ffp, "%*s %*s");

	/*-------------------- Data flags --------------------------------*/

	fscanf(ffp, "%*s %*s");
	for (i = 0; i < param_dim; i++)
		fscanf(ffp, "%lg", &param[i]);
	fscanf(ffp, "%*s %*s");
	for (i = 0; i < var_dim; i++)
		fscanf(ffp, "%lg", &win_var_i[i]);
	fscanf(ffp, "%*s %*s %d %d %d", &i_start, &i_max, &i_step);
	fscanf(ffp, "%*s %*s %lg", &time_step);
	fscanf(ffp, "%*s %*s");
	for (i = 0; i < var_dim; i++)
		fscanf(ffp, "%lg", &win_var_f[i]);

	fscanf(ffp, "%*s %*s %d %d %d %d", &var_cur_index[0], &var_cur_index[1], &param_cur_index[0], &param_cur_index[1]);

	fscanf(ffp, "%*s %*s");
	for (i = 0; i < full_dim;i++) fscanf(ffp, "%lg %lg", &all_min[i], &all_max[i]);
	fscanf(ffp, "%*s %*s");
	for (i = full_dim; i < full_dim+param_dim; i++) fscanf(ffp, "%lg %lg", &all_min[i], &all_max[i]);

	for (i = 0; i < full_dim+param_dim; i++)
		fscanf(ffp, "%lg %lg", &all_min_top[i], &all_max_top[i]);
}
