int nlmathieu_init()
{
	title_label = "Nonlinear Mathieu Eq";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 3;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "t";
	param_label[0] = "omega";
	param_label[1] = "ampl";
	param_label[2] = "damp";
	func_label[0] = "Undefined";
	func_label[1] = "Undefined";

	param[0] = 1;
	param[1] = 0;
	param[2] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;

	f_p = nlmathieu_f;
	func_p = nlmathieu_func;
}
/* nonlinar mathieu equation */
int nlmathieu_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	f[0] = x[1];
	f[1] = -p[2] * x[1] - (p[0] * p[0] + p[1] * cos(x[2])) * sin(x[0]);
	f[2] = 1;
	
}
int nlmathieu_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
}
