/*
	This file is automatically written by kwrite_f.
*/
/* KAOS DYNAMICAL SYSTEM CLASS = class_demo */

#include "model.h"


int d4hammm_init()
{
	title_label = "D4 Nilpotent Hamiltonian --";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 2;
	func_dim = 3;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "mu";
	param_label[1] = "delta";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";
	func_label[2] = "t";

	param[0] = 2;
	param[1] = 1;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;
	func_min[2]= 0; func_max[2]= 10000;

	f_p = d4hammm_f;
	func_p = d4hammm_func;
}
/* D4 Hamitonian */
int d4hammm_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v2sq;

	/* Hamiltonian vector field: 0: dH/dy 2: dH/dw 1:-dH/dx 3:-dH/dz */
	if(index !=2) {
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index !=1){
		v0sq = x[0] * x[0];
		v2sq = x[2] * x[2];
		f[1] = x[0] * (p[0] - (v0sq+v2sq)) + p[1] * x[0] * v2sq;
		f[3] = x[2] *(p[0] - (v0sq+v2sq))+p[1]*x[2]*v0sq; 
	}
	
}
int d4hammm_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * ((x[1] * x[1] + x[3] * x[3]) - p[0]*(v0sq+v2sq) + 0.5 *
	(v0sq+v2sq)*(v0sq+v2sq) - p[1] * v0sq* v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	f[2] = t;
	
}

int d4hampp_init()
{
	title_label = "D4 Nilpotent Hamiltonian ++";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 2;
	func_dim = 3;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "mu";
	param_label[1] = "delta";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";
	func_label[2] = "t";

	param[0] = 2;
	param[1] = 1;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;
	func_min[2]= 0; func_max[2]= 10000;

	f_p = d4hampp_f;
	func_p = d4hampp_func;
}
/* D4 Hamitonian */
int d4hampp_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v2sq;

	/* Hamiltonian vector field: 0: dH/dy 2: dH/dw 1:-dH/dx 3:-dH/dz */
	if(index !=2) {
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index !=1){
		v0sq = x[0] * x[0];
		v2sq = x[2] * x[2];
		f[1] = x[0] * (p[0] + (v0sq+v2sq)) + p[1] * x[0] * v2sq;
		f[3] = x[2] * (p[0] + (v0sq+v2sq)) + p[1] * x[2] * v0sq; 
	}
	
}
int d4hampp_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * (( x[1] * x[1] + x[3] * x[3]) - p[0]*(v0sq+v2sq)
		+ 0.5 * (v0sq+v2sq)*(v0sq+v2sq) - p[1] * v0sq* v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	f[2] =  t;
}

int d4dissmmp_init()
{
	title_label = "D4 Diss. -- +";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 6;
	func_dim = 2;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "mu";
	param_label[1] = "delta";
	param_label[2] = "epsilon";
	param_label[3] = "nu";
	param_label[4] = "Axzw";
	param_label[5] = "Ayz2";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";

	param[0] = 2;
	param[1] = 0;
	param[2] = 0;
	param[3] = 0;
	param[4] = 0;
	param[5] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	param_min[4]= -5; param_max[4]= 5;
	param_min[5]= -5; param_max[5]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	f_p = d4dissmmp_f;
	func_p = d4dissmmp_func;
}
int d4dissmmp_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v2sq;
	if(index !=2) {
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index !=1){
		v0sq = x[0] * x[0];
		v2sq = x[2] * x[2];
		f[1] = x[0] * (p[0]-(v0sq+v2sq)) + p[1] * x[0] * v2sq
			+ p[2] * (-(v0sq+v2sq) * x[1] + p[3] * x[1] + p[4] * x[0]*(x[0]*x[1]+x[2]*x[3]) + p[5] * x[1] * v2sq);
		f[3] = x[2] *(p[0] - (v0sq+v2sq))+p[1]*x[2]*v0sq
			+ p[2] * (-(v0sq+v2sq) * x[3] + p[3] * x[3] + p[4] * x[2]*(x[0]*x[1]+x[2]*x[3]) + p[5] * x[3] * v0sq);
	}
}
int d4dissmmp_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * ((x[1] * x[1] + x[3] * x[3]) - p[0] * (v0sq+v2sq)
		+ 0.5 * (v0sq+v2sq) * (v0sq+v2sq) - p[1] * v0sq * v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	
}
/* Lorenz system */

int lorenz_init()
{
	title_label = "Lorenz system";

	mapping_on = 0; 
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 3;
	param_dim = 3;
	func_dim = 3;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	param_label[0] = "sigma";
	param_label[1] = "rho";
	param_label[2] = "beta";
	func_label[0] = "t";
	func_label[1] = "x+y";
	func_label[2] = "x-y";

	param[0] = 10;
	param[1] = 28;
	param[2] = 2.6666666666666;
	var_i[0] = 0.1;
	var_i[1] = 0.1;
	var_i[2] = 0.1;

	param_min[0]= -20; param_max[0]= 20;
	param_min[1]= 0; param_max[1]= 40;
	param_min[2]= -5; param_max[2]= 5;
	var_min[0]= -30; var_max[0]= 30;
	var_min[1]= -30; var_max[1]= 30;
	var_min[2]= -5; var_max[2]= 50;
	func_min[0]= 0; func_max[0]= 100;
	func_min[1]= -60; func_max[1]= 60;
	func_min[2]= -60; func_max[2]= 60;

	f_p = lorenz_f;
	func_p = lorenz_func;
}

int lorenz_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	f[0] = p[0] * ( x[1] - x[0] );
	f[1] = p[1] * x[0] - x[1] - x[0] * x[2];
	f[2] = - p[2] * x[2] + x[0] * x[1];
	
}
int lorenz_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
	f[1] = x[0] + x[1];
	f[2] = x[0] - x[1];
}
int nlmathieu_init()
{
	title_label = "Nonlinear Mathieu Eq";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 3;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "t";
	param_label[0] = "omega";
	param_label[1] = "ampl";
	param_label[2] = "damp";
	func_label[0] = "Undefined";
	func_label[1] = "Undefined";

	param[0] = 1;
	param[1] = 0;
	param[2] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;

	f_p = nlmathieu_f;
	func_p = nlmathieu_func;
}
/* nonlinar mathieu equation */
int nlmathieu_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	f[0] = x[1];
	f[1] = -p[2] * x[1] - (p[0] * p[0] + p[1] * cos(x[2])) * sin(x[0]);
	f[2] = 1;
	
}
int nlmathieu_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
}

int dpfosc2_init()
{
	title_label = "Diss Period. Forced Oscillator";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	var_dim = 2;
	param_dim = 5;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "f-omega";
	param_label[1] = "acampl";
	param_label[2] = "dcampl";
	param_label[3] = "damp";
	param_label[4] = "n-omega";
	func_label[0] = "t";
	func_label[1] = "Undefined";

	param[0] = 2;
	param[1] = 1;
	param[2] = 0;
	param[3] = 0;
	param[4] = 0;

	var_i[0] = 0;
	var_i[1] = 0.5;

	/* stating values of parameter window box */
	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	param_min[4]= -5; param_max[4]= 5;

	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= -5; var_max[1]= 5;
	func_min[0]= -10; func_max[0]= 10;

	f_p = dpfosc2_f;
	func_p = dpfosc2_func;
}
int dpfosc2_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	f[0] = x[1];
	f[1] = p[2] + p[1]*cos(twopi*p[0]* t) - p[3] * x[1] - p[4] * sin(twopi*x[0]);
}
int dpfosc2_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
}
int henonmap_init()
{
	title_label = "Henon Map";

	mapping_on = 1;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	
	var_dim = 2;
	param_dim = 2;
	func_dim = 0;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "a";
	param_label[1] = "b";

	param[0] = 1.34;
	param[1] = 0.3;

	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;

	f_p = henonmap_f;
	func_p = henonmap_func;
}
/* Henon map */
int henonmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	/* an example of a mapping */
	/* forward mapping */
	if(index ==1) {
		f[0] = 1. + x[1] - p[0] * x[0] * x[0];
		f[1] = p[1] * x[0]; 
	}
	/* backward mapping */
	else if(index ==0) {
		f[0] = 1./p[1] * x[1];
		f[1] = -1. + x[0] + p[0]/p[1]/p[1] * x[1] * x[1]; 
	}
	
}
int henonmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	/* an example of no definition */
}
int kotorusmap_init()
{
	title_label = "Kim-Ostlund Torus Map";
	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	
	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;
	period_len[1] = 1;
	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "wx";
	param_label[1] = "wy";
	param_label[2] = "a";
	param_label[3] = "asymm";
	func_label[0] = "rhox";
	func_label[1] = "rhoy";

	param[0] = 0.6;
	param[1] = 0.805;
	param[2] = 0.7;
	param[3] = 1;
	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 1;
	param_min[2]= 0; param_max[2]= 2;
	param_min[3]= 0; param_max[3]= 2;
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;

	f_p = kotorusmap_f;
	func_p = kotorusmap_func;
}
/* Kim-Ostlund strongly coupled torus map */
int kotorusmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	/* forward map */
	if(index ==1) {
		f[0] = x[0] + p[0] - p[2] * p[3] / twopi * sin(twopi * x[1]);
		f[1] = x[1] + p[1] - p[2] / p[3] / twopi * sin(twopi * x[0]);
	}
	/* inverse map not defined */
}
int kotorusmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = v[0]-x[0]-p[0];
	f[1] = v[1]-x[1]-p[1];
}
int dissstandmap_init()
{
	title_label = "(Dissipative) Standard Map";
	mapping_on = 1;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	var_dim = 2;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;
	period_len[1] = 0;
	
	var_label[0] = "x";
	var_label[1] = "r";
	param_label[0] = "w";
	param_label[1] = "k";
	param_label[2] = "b";
	func_label[0] = "Rhox";
	func_label[1] = "Undefined";

	param[0] = 0;
	param[1] = 0.97;
	param[2] = 1;
	var_i[0] = .5;
	var_i[1] = .5;

	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 1;
	param_min[2]= 0; param_max[2]= 1;
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	func_min[0]= 0; func_max[0]= 1;

	f_p = dissstandmap_f;
	func_p = dissstandmap_func;
}
/* Diss. Standard Map */
int dissstandmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v1sq,v2sq,v3sq;

	/* forward map */
	if(index ==1) {
		f[1] = p[2] * x[1] - p[1] / twopi * sin(twopi * x[0]);
		f[0] = x[0] + p[0] + f[1];
	}
	/* backward map */
	else if(index ==0) {
		f[0] = x[0] - p[0] -x[1];
		f[1] = (x[1] + p[1]/twopi * sin(twopi * f[0]))/p[2];
	}
	
}
int dissstandmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = v[0]-x[0];
}
int siegelmap_init()
{
	title_label = "Siegel Map";

	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	
	var_dim = 2;
	param_dim = 2;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "rho";
	param_label[1] = "p";
	func_label[0] = "|Rho|^2";
	func_label[1] = "Undefined";

	param[0] = 0.618;
	param[1] = 1.;
	var_i[0] = 1.;
	var_i[1] = 0.;

	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 10;
	var_min[0]= -2; var_max[0]= 2;
	var_min[1]= -2; var_max[1]= 2;
	func_min[0]= 0; func_max[0]= 4;

	f_p = siegelmap_f;
	func_p = siegelmap_func;
}
/* Siegel map */
int siegelmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double xp,yp,xt,yt,theta,rr,alpha,sigma,cx,cy,cossigma,sinsigma;
	if(index ==1) {
		xt = x[0];
		yt= x[1];
		alpha = p[1];
		sigma = p[0];
		sinsigma = sin(twopi*sigma);
		cossigma = cos(twopi*sigma);
		xp = 1-xt;
		yp = -yt;
		if(xp==0){
			if(yp>0)
				theta = twopi/4;
			else
				theta = -twopi/4;
		}
		else {
			theta = atan(yp/xp);
			if(xp>0 && yp>=0)
				theta = theta; 
			else if(xp>0 && yp<0)
				theta = theta;
			else if(xp<0 && yp>0)
				theta = twopi/2 + theta;
			else if(xp<0 && yp<0)
				theta = -(twopi/2 - theta);
		}
		rr = xp*xp + yp*yp;
		rr = exp((alpha+1)/2 * log(rr));
		cx = 1 - rr * cos((alpha+1) * theta);
		cy = -rr * sin((alpha+1) * theta);
		cx = cx / (alpha+1);
		cy = cy / (alpha+1);
		f[0] = cossigma * cx - sinsigma * cy; 
		f[1] = sinsigma * cx + cossigma * cy; 
	}
	/* inverse map not defined */
}
int siegelmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = 0;
	for(i=0;i<dim;i++)
		f[0] += (v[i]-x[i])*(v[i]-x[i]);
	
}
/*
This is a martyd3 subroutine. "martyd3" should be
substituted with the proper string for a dynamical system
to be installed. Define all initialization parameters
here. Parameters are assigned to the default values before this program is
called.
*/
int martyd3_init()
{
	title_label = "Marty's D3 Map";

	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "alpha";
	param_label[1] = "lambda";
	param_label[2] = "beta";
	param_label[3] = "gamma";
	func_label[0] = "Modulus";
	func_label[1] = "Re(Z^3)";

	param[0] = -1;
	param[1] = 1.52;
	param[2] = .1;
	param[3] = -.8;
	var_i[0] = 0.01;
	var_i[1] = 0.057;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	var_min[0]= -1.5; var_max[0]= 1.5;
	var_min[1]= -1.5; var_max[1]= 1.5;

	f_p = martyd3_f;
	func_p = martyd3_func;
}
/*
second user dynamical system 
*/
	
int martyd3_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double z2r,z2i,z3r,z3i,iv;
        cmul(&z2r,&z2i,x[0],x[1],x[0],x[1]);
	cmul(&z3r,&z3i,z2r,z2i,x[0],x[1]);
	iv = p[0] * (x[0]*x[0] + x[1]*x[1]) + p[1] + p[2] * z3r; 
	if(index ==1) {
		f[0] = iv * x[0] + p[3] * z2r;
		f[1] = iv * x[1] - p[3] * z2i;
	}
}

cmul(x,y,x1,y1,x2,y2)
double *x,*y,x1,y1,x2,y2;
{
	*x = x1 * x2 - y1 * y2; 
	*y = x1 * y2 + x2 * y1; 
}
/* cmul() is a subroutine local for this model */
int martyd3_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	double z2r,z2i,z3r,z3i,iv;
        cmul(&z2r,&z2i,x[0],x[1],x[0],x[1]);
	cmul(&z3r,&z3i,z2r,z2i,x[0],x[1]);
	f[0] = x[0]*x[0] + x[1]*x[1];
	f[1] = z3r;
}

int henonheiles_init()
{
	title_label = "Henon-Heiles";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	var_dim = 4;
	param_dim = 1;
	func_dim = 3;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "px";
	var_label[2] = "y";
	var_label[3] = "py";
	param_label[0] = "epsilon";
	func_label[0] = "Energy";
	func_label[1] = "Ang Mon";
	func_label[2] = "t";

	param[0] = 1;

	var_i[0] = 0.1;
	var_i[1] = 0.1;
	var_i[2] = 0.1;
	var_i[3] = 0.1;

	/* stating values of parameter window box */
	param_min[0]= 0; param_max[0]= 5;

	var_min[0]= -1; var_max[0]= 1;
	var_min[1]= -1; var_max[1]= 1;
	var_min[2]= -1; var_max[3]= 1;
	var_min[3]= -1; var_max[2]= 1;
	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;
	func_min[2]= 0; func_max[2]= 10000;

	f_p = henonheiles_f;
	func_p = henonheiles_func;
}

int henonheiles_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	if(index!=2){
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index!=1){
		f[1] = - x[0] - p[0]*2.*x[0]*x[2];
		f[3] = - x[2] - p[0]*(x[0]*x[0]-x[2]*x[2]);
	}
}

int henonheiles_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	double x0sq,x2sq;
	x0sq = x[0]*x[0];
	x2sq = x[2]*x[2];
	f[0] = 0.5 * (x[1]*x[1] + x[3]*x[3] + x0sq + x2sq) + p[0]*(x0sq*x[2] - x2sq*x[2]/3.);
	f[1] = x[0]*x[3] - x[1]*x[2];
	f[2] = t;
}
int vanderpol_init()
{
	title_label = "Van der Pol's Eq";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 2;
	param_dim = 3;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "alpha";
	param_label[1] = "beta";
	param_label[2] = "omega";
	func_label[0] = "t";
	func_label[1] = "Undefined";

	param[0] = 1;
	param[1] = 0;
	param[2] = 1;

	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= 0; param_max[2]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;

	f_p = vanderpol_f;
	func_p = vanderpol_func;
}
/* Van der Pol's equation */
int vanderpol_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double cos();
	f[0] = x[1] - p[0]*(x[0]*x[0]*x[0]/3. - x[0]);
	f[1] = -x[0] + p[1]*cos(p[2]*t);
}
int vanderpol_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
	f[1] = 0;
}
int duffing_init()
{
	title_label = "Duffing's Eq";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "p";
	param_label[0] = "delta";
	param_label[1] = "beta";
	param_label[2] = "gamma";
	param_label[3] = "omega";
	func_label[0] = "t";
	func_label[1] = "Undefined";

	param[0] = 0.25;
	param[1] = 1;
	param[2] = 0.3;
	param[3] = 1;

	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= 0; param_max[3]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;

	f_p = duffing_f;
	func_p = duffing_func;
}
/* Duffing's equation */
int duffing_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double cos();
	f[0] = x[1];
	f[1] = p[1]*x[0] - x[0]*x[0]*x[0] - p[0]*x[1] + p[2]*cos(p[3]*t);
}
int duffing_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
	f[1] = 0;
}
int simpletorusmap_init()
{
	title_label = "Simple Torus Map";
	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	
	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	period_len[0] = 1;
	period_len[1] = 1;
	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "wx";
	param_label[1] = "wy";
	param_label[2] = "a";
	param_label[3] = "e";
	func_label[0] = "rhox";
	func_label[1] = "rhoy";

	param[0] = 0.1;
	param[1] = 1.;
	param[2] = 0.2;
	param[3] = 0.1;
	var_i[0] = 0;
	var_i[1] = 0;

	param_min[0]= -1.5; param_max[0]= 1.5;
	param_min[1]= -1.5; param_max[1]= 1.5;
	param_min[2]= 0; param_max[2]= 2;
	param_min[3]= 0; param_max[3]= 2;
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;

	f_p = simpletorusmap_f;
	func_p = simpletorusmap_func;
}
/* Kim-Ostlund strongly coupled torus map */
int simpletorusmap_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	/* forward map */
	if(index ==1) {
		f[0] = x[0] + p[3]*(p[0] + cos(2*pi*x[0]) + p[2]*cos(2*pi*x[1]));
		f[1] = x[1] + p[3]*(p[1] + sin(2*pi*x[0]) + p[2]*sin(2*pi*x[1]));
	}
	/* inverse map not defined */
}
int simpletorusmap_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	int i;
	extern int forward_toggle;
	extern double *v;
	extern int (*f_p)();
	
	(int) f_p(v,forward_toggle,x,p,t,dim);
	f[0] = v[0]-x[0];
	f[1] = v[1]-x[1];
}
