/* Patrick Worfolk   
   January 22, 1990
   Fractal dimension algorithm functions
   */


/* DIMS_SORT sorts an array using a quicksort.
  data[x][y] is considered as a list where x indexes the different
  elements and y indexes the different components of one element.
  */



#define M 7
#define NSTACK 50
#define FM 7875
#define FA 211
#define FC 1663
#define TRUE 1
#define FALSE 0

void dims_sort(data,xsize,ysize)
int xsize,ysize;
double **data;
{
	int l=1,jstack=0,j,ir,iq,i,k,okay;
	int istack[NSTACK+1];
	long int fx=0L;
	double *temp;

	ir=xsize;
	for (;;) {
		if (ir-l < M) {
			for (j=l+1;j<=ir;j++) {
				temp=data[j-1];
		/* for (i=j-1;data[i-1]>temp && i>0;i--) data[i]=data[i-1]; */
				i=j-1;
				okay = TRUE;
				while (i>0 && okay) {									k=0;
					while ((k<ysize-1) && 
					  (((int) data[i-1][k])==((int) temp[k]))) 
						k++;
					if (data[i-1][k]>temp[k]) {
						data[i]=data[i-1];
						i--;
						}
					else okay=FALSE;
					}
				data[i]=temp;
			}
			if (jstack == 0) return;
			ir=istack[jstack--];
			l=istack[jstack--];
		} else {
			i=l;
			j=ir;
			fx=(fx*FA+FC) % FM;
			iq=l+((ir-l+1)*fx)/FM;
			temp=data[iq-1];
			data[iq-1]=data[l-1];
			for (;;) {
				/* while (j > 0 && temp < data[j-1]) j--;*/
				okay=TRUE;
				while (j>0 && okay) {
					k=0;
					while ((k<ysize-1) &&
					  (((int) temp[k])==((int) data[j-1][k])))
						k++;
					if (temp[k]<data[j-1][k]) j--;
					else okay=FALSE;
					}
				if (j <= i) {
					data[i-1]=temp;
					break;
				}
				data[-1+i++]=data[j-1];
				/* while (temp > data[i-1] && i <= xsize) i++;*/
				okay=TRUE;
				while (i<=xsize && okay) {
					k=0;
					while ((k<ysize-1) &&
					  (((int) temp[k])==((int) data[i-1][k])))
						k++;
					if (temp[k]>data[i-1][k]) i++;
					else okay=FALSE;
					}
				if (j <= i) {
					data[(i=j)-1]=temp;
					break;
				}
				data[--j]=data[i-1];
			}
			if (ir-i >= i-l) {
				istack[++jstack]=i+1;
				istack[++jstack]=ir;
				ir=i-1;
			} else {
				istack[++jstack]=l;
				istack[++jstack]=i-1;
				l=i+1;
			}
			if (jstack > NSTACK) 
			  system_mess_proc(1,
				"(Box algoritm) NSTACK too small in QCKSRT");
		}
	}
}

#undef M
#undef NSTACK
#undef FM
#undef FA
#undef FC
