/*
### forward mapping ###
Compute i_max orbits (x(1),...,x(i_max)). NOte that x(0) is displayed
but not recorded.

Bug: No polar coords allowed for maps at the moment
*/

int
map_forward()
{
	int i,iter,color;
	double time,*vn2,*vn,*vfull,*dvector();
	void free_dvector();
	extern int var_dim,func_dim,param_dim,full_dim;
	extern int forward_toggle,stop,var_dim,model,i_max,polar_coord;
	extern double cutoff,*win_var_i,*win_var_f,*param;
	extern int (*f_p)();

	
	stop=0;
	vn = dvector(0,var_dim-1);
	vn2 = dvector(0,var_dim-1);
	vfull = dvector(0,full_dim-1);

	/* initialize from window variable */
	from_window_variables(vn,win_var_i,polar_coord);
	
	/* draw starting point not record */
	to_full_variables(vfull,vn,polar_coord);
	(void) draw_record_orbit(vfull,0,0);

	/* main loop */
	for (iter=1;iter<=i_max;iter++){
		/* check divergence */
		for(i=0;i<var_dim;i++) {
			if(vn[i] > cutoff || vn[i] < -cutoff) {
				system_mess_proc(1,"Orbits appear to diverge off to an infinity! Stop!");
				goto done;
			}
		}
		(int) f_p(vn2,forward_toggle,vn,param,time,var_dim);
		to_full_variables(vfull,vn2,polar_coord);
		(void) draw_record_orbit(vfull,iter,1);
		for(i=0;i<var_dim;i++)
			vn[i] = vfull[i];
		if(stop ) {
			goto done;
		}
	}
	
	done:
	/* to window variable */
	for(i=0;i<var_dim;i++)
		win_var_f[i]=vn[i];
	free_dvector(vn,0,var_dim-1);
	free_dvector(vn2,0,var_dim-1);
	free_dvector(vfull,0,full_dim-1);
	return(iter);
}
