/*
### create combined space windows ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "../include/x11r2_kaos_def.h"
#include "../modellib/class_kaos_def.h"

void create_aux_windows(awi)
int awi;
{
        void aux_handle_event(),aux_resize_proc(),aux_win_mode_proc(),aux_quit_proc(),aux_copy_proc(),aux_x_proc(),aux_y_proc(),aux_repaint_proc();
        int i;
        extern Frame frame,*aux_frame;
        extern Panel *aux_panel;
        extern Canvas *aux_canvas;
	extern Cursor *aux_cursor;
        extern Pixwin **aux_pw;
        extern Pixfont *courier10;
        extern Panel_item *aux_quit_item,*aux_copy_item,*aux_win_mode_item,*aux_x_item,*aux_y_item,*aux_x_min_item,*aux_x_max_item,*aux_y_min_item,*aux_y_max_item;
        extern char string[];
	extern int panel_colormap_on;
	extern int auto_option;
        extern int model,my_colormap_size;
	extern int var_dim,param_dim,func_dim,full_dim;
        extern int aux_xcanvas,aux_ycanvas,aux_xwindow,aux_ywindow,aux_xwidth,aux_ywidth,aux_panel_height;
        extern int *aux_on,*aux_win_mode,**aux_cur_index;
        extern char string[],**all_label,**func_label;
	extern double *all_min,*all_max,*param_min,*param_max;
        extern double **aux_x_min,**aux_x_max,*win_var_i;
        
	/* Turn on the flag */	
	if(aux_on[awi]){
		window_set(aux_frame[awi],WIN_SHOW,TRUE,0);
		return;
	}
	else
		aux_on[awi]=1;

	/* Initialize the window size from phase space and parameter space box */
	for(i=0;i<full_dim+param_dim;i++){
		aux_x_min[i][awi]=all_min[i];
		aux_x_max[i][awi]=all_max[i];
	}
	if(auto_option>0){
		auto_translate_param(awi);
	}

	/* Initialize the window configuration */
        aux_xcanvas = aux_xwindow;
        aux_ycanvas = aux_ywindow;
        aux_xwidth = aux_xcanvas;
        aux_ywidth = aux_ycanvas-aux_panel_height;

	/* Frame Label */
        sprintf(string,"auxiliary space[%d]",awi);
	/* Create aux frame */
        aux_frame[awi] = window_create(frame,FRAME,
                FRAME_NO_CONFIRM,       TRUE,
                FRAME_LABEL,    string,
                FRAME_SHOW_LABEL,       TRUE,
                WIN_SHOW,       TRUE,
                WIN_X,  1152-aux_xwindow,
                WIN_Y,  aux_ywindow*awi,
                WIN_HEIGHT,     aux_ywindow,
                WIN_WIDTH,      aux_xwindow,
                0);
	if(aux_frame[awi] == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		aux_on[awi] = 0;
		return;
	}
	/* Create aux canvas */
        aux_canvas[awi] = window_create(aux_frame[awi], CANVAS, CANVAS_RETAINED, FALSE,0);
	if(aux_canvas[awi] == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_aux_windows(awi);
		return;
	}
	aux_cursor[awi]  = cursor_create(CURSOR_SHOW_CROSSHAIRS,TRUE,
                       CURSOR_CROSSHAIR_COLOR,my_colormap_size-1,
                       CURSOR_CROSSHAIR_LENGTH,10,0),
        window_set(aux_canvas[awi],
                CANVAS_RETAINED,        TRUE,
                CANVAS_AUTO_SHRINK,     TRUE,
                CANVAS_AUTO_EXPAND,     TRUE,
                CANVAS_WIDTH,           aux_xcanvas,
                CANVAS_HEIGHT,          aux_ycanvas,
                WIN_CONSUME_KBD_EVENTS, WIN_ASCII_EVENTS,WIN_TOP_KEYS,WIN_RIGHT_KEYS,0,
                WIN_CONSUME_PICK_EVENTS,     WIN_MOUSE_BUTTONS, LOC_DRAG,0,
                WIN_EVENT_PROC,             aux_handle_event,
                WIN_CURSOR,     aux_cursor[awi],
                CANVAS_RESIZE_PROC,     aux_resize_proc,
		/*
                CANVAS_REPAINT_PROC,    aux_repaint_proc,
		*/
                0);
	/* Define Pixwin */
        aux_pw[awi] = (Pixwin *) canvas_pixwin(aux_canvas[awi]);    
	/* Load colormap */
        aux_load_colormap(awi);
	/* Create Panel */
        aux_panel[awi] = window_create(aux_frame[awi], PANEL,
                WIN_X, 0,
                WIN_Y, 0,
                WIN_HEIGHT,     aux_panel_height,
                WIN_FONT, courier10,
                0);
	if(aux_panel[awi] == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_aux_windows(awi);
		return;
	}
	/* Create panel items */
        aux_quit_item[awi]= panel_create_item(aux_panel[awi], PANEL_BUTTON,
                PANEL_LABEL_Y, ATTR_ROW(0),
                PANEL_LABEL_X, ATTR_COL(0),
                PANEL_LABEL_IMAGE, panel_button_image(aux_panel[awi], "Quit", 4, courier10),
                PANEL_NOTIFY_PROC, aux_quit_proc,
                0);
        aux_copy_item[awi] = panel_create_item(aux_panel[awi], PANEL_BUTTON,
                PANEL_LABEL_Y, ATTR_ROW(0),
                PANEL_LABEL_X, ATTR_COL(9),
                PANEL_LABEL_IMAGE, panel_button_image(aux_panel[awi], "Copy", 9, courier10),
                PANEL_NOTIFY_PROC, aux_copy_proc,
                0);
        aux_win_mode_item[awi]= panel_create_item(aux_panel[awi], PANEL_CYCLE,
                PANEL_LABEL_Y, ATTR_ROW(0),
                PANEL_LABEL_X, ATTR_COL(25),
                PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
                PANEL_LABEL_STRING, "Mode:",
                PANEL_CHOICE_STRINGS, "SimulView","AllPurpose",0,
                PANEL_VALUE, aux_win_mode[awi],
                PANEL_NOTIFY_PROC, aux_win_mode_proc,
                0);
        aux_x_item[awi]= panel_create_item(aux_panel[awi], PANEL_CYCLE,
                PANEL_LABEL_Y, ATTR_ROW(1),
                PANEL_LABEL_X, ATTR_COL(0),
                PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
                PANEL_LABEL_STRING, "Aux Plane:",
                PANEL_CHOICE_STRINGS, ALL_LABELS,0,
                PANEL_VALUE, aux_cur_index[awi][0],
                PANEL_NOTIFY_PROC, aux_x_proc,
                0);
        aux_y_item[awi]= panel_create_item(aux_panel[awi], PANEL_CYCLE,
                PANEL_LABEL_Y, ATTR_ROW(1),
                PANEL_LABEL_X, ATTR_COL(20),
                PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
                PANEL_LABEL_STRING, ":",
                PANEL_CHOICE_STRINGS, ALL_LABELS,0,
                PANEL_VALUE, aux_cur_index[awi][1],
                PANEL_NOTIFY_PROC, aux_y_proc,
                0);
        sprintf(string, "%lg", aux_x_min[aux_cur_index[awi][0]][awi]);
        aux_x_min_item[awi] = panel_create_item(aux_panel[awi], PANEL_TEXT,
                        PANEL_LABEL_Y, ATTR_ROW(2),
                        PANEL_LABEL_X, ATTR_COL(0),
                        PANEL_VALUE, string,
                        PANEL_VALUE_DISPLAY_LENGTH, 12,
                        PANEL_LABEL_STRING,"[Hor]:",
                        0);
        sprintf(string, "%lg", aux_x_max[aux_cur_index[awi][0]][awi]);
        aux_x_max_item[awi] = panel_create_item(aux_panel[awi], PANEL_TEXT,
                        PANEL_LABEL_Y, ATTR_ROW(2),
                        PANEL_LABEL_X, ATTR_COL(20),
                        PANEL_VALUE, string,
                        PANEL_VALUE_DISPLAY_LENGTH, 12,
                        PANEL_LABEL_STRING,":",
                        0);
        sprintf(string, "%lg", aux_x_min[aux_cur_index[awi][1]][awi]);
        aux_y_min_item[awi] = panel_create_item(aux_panel[awi], PANEL_TEXT,
                        PANEL_LABEL_Y, ATTR_ROW(3),
                        PANEL_LABEL_X, ATTR_COL(0),
                        PANEL_VALUE, string,
                        PANEL_VALUE_DISPLAY_LENGTH, 12,
                        PANEL_LABEL_STRING,"[Ver]:",
                        0);
        sprintf(string, "%lg", aux_x_max[aux_cur_index[awi][1]][awi]);
        aux_y_max_item[awi] = panel_create_item(aux_panel[awi], PANEL_TEXT,
                        PANEL_LABEL_Y, ATTR_ROW(3),
                        PANEL_LABEL_X, ATTR_COL(20),
                        PANEL_VALUE, string,
                        PANEL_VALUE_DISPLAY_LENGTH, 12,
                        PANEL_LABEL_STRING,":",
                        0);
        window_fit_height(aux_panel[awi]);

	if(panel_colormap_on)
        	init_panel_colormap((Pixwin *) window_get(aux_panel[awi],WIN_PIXWIN), "aux_cms");
}
