/*
### Execute an auto executable and pipe the output to the combined space box ###
--------------------------------------------------------------------------------
In case of AUTO86 executables recognized by "@auto", it sets
the region_index to 2, aux_win_mode of the appropriate aux window to 1.
------------------------------------------------------------------------------*/
#include <stdio.h>


#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
static FILE *fp_auto_fromchild,*fp_auto_tochild;
static int auto_fromchild,auto_tochild;
static int auto_childpid;

void
auto_panel_go_proc()
{
	static Notify_value auto_pipe_reader();
	static Notify_value auto_dead_child();
	int pipefrom[2],pipeto[2];
	int c,numfds;

	int i;
	extern int auto_option;
	extern int region_index;
	extern char string[],lstring[],auto_dir_name[],auto_file_name[],auto_input_name[];
	extern FILE *popen();
	extern Textsw auto_textsw;
	extern Panel_item auto_panel_go_item,auto_dir_name_item,auto_file_name_item,auto_input_name_item;
	
	all_reset();

	/* Scan the executable file name and determine if it is from AUTO86.
	If it is, set region_index to 2 which is necessary for recording the
	data to data2 by record_data() */
	/* WORKING VERSION */
	if(strncmp(auto_file_name,"@auto",5)==0){
		auto_option = 1;  /* default choice, will be changed by
					get_auto_option */
		region_index = 2;
        	sprintf(lstring,"%s/%s",auto_dir_name,auto_file_name);
		system_mess_proc(0,"running AUTO86 preprocessor...");
	/*
        	textsw_store_file(auto_textsw,lstring,0,0);
        	sprintf(lstring,"%s/%s^%s",auto_dir_name,auto_file_name,auto_dir_name,auto_input_name);
	*/
	}
	else {
        	sprintf(lstring,"%s/%s",auto_dir_name,auto_file_name);
	}

	/* Decode an executable string replacing ^ with a white space */
	if(lstring!= NULL){
		i=0;
		while(lstring[i] != '\0'){
			if(lstring[i] == '^')
				string[i]=' ';
			else
				string[i]=lstring[i];
			i++;
		}
		string[i] = '\0';
	}
	strcpy(lstring,string);

	/* Create a pipe */
        if(pipe(pipefrom)<0){
                perror("new process");
		system_mess_proc(1,"Error: Piping failed! Check the file name!");
		return;
	}
	if(pipe(pipeto) < 0){
                perror("new process");
		system_mess_proc(1,"Error: Piping failed! Check the file name!");
		return;
	}

	/* Fork a child */
        switch (auto_childpid = fork()){
                case -1:
                        perror("new process");
                        exit(1);
                case 0:
                        /* use dup2 to set the child's stdout to
                        the pipe */
                        dup2(pipeto[0],0);
                        dup2(pipefrom[1],1);

                        /* close all other fds (except stderr) since child
                        process doesn't know about or need them */
                        numfds = getdtablesize();
                        for (c = 3; c < numfds; c++)
                                close(c);
                        (void) execl("/bin/csh","csh","-c",lstring,0);
                        perror("new process: child");
                        exit(1);
                default:
                        close(pipeto[0]);
                        auto_tochild = pipeto[1];
                        fp_auto_tochild = fdopen(auto_tochild, "w");
                        close(pipefrom[1]);
                        auto_fromchild = pipefrom[0];
                        fp_auto_fromchild = fdopen(auto_fromchild, "r");

                        /* The pipe should be unbuffered or "new process" 
                        will not get any data until 1024 characters have
                        been sent */
                        setbuf(fp_auto_tochild,NULL);
                        setbuf(fp_auto_fromchild,NULL);
                        break;
        }

	/* Register input and wait3 functions to the notifier */
        (void) notify_set_input_func(auto_panel_go_item,auto_pipe_reader,auto_fromchild);
        (void) notify_set_wait3_func(auto_panel_go_item,auto_dead_child,auto_childpid);
	return;
}


/*------------------------------------------------------------------------------
Read the input pending on the pipe
------------------------------------------------------------------------------*/
 

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>

static Notify_value
auto_pipe_reader(item,fd)
Panel_item item;
int fd;
{
	extern FILE *fp_auto_fromchild;
	extern char auto_file_name[];

	if(strncmp(auto_file_name,"@auto",5)==0){
		auto_load_data(fp_auto_fromchild);
	}
	return(NOTIFY_DONE);
}


/*------------------------------------------------------------------------------
Close the pipe and let the notifier know if the child process dies
------------------------------------------------------------------------------*/
 

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>

static Notify_value
auto_dead_child(item,pid,status,rusage)
Panel_item item;
int     pid;
union wait *status;
struct rusage *rusage;
{
	extern int auto_fromchild;
        (void) notify_set_input_func(item,NOTIFY_FUNC_NULL,auto_fromchild);
        close(auto_fromchild);
        return(NOTIFY_DONE);
}
