#include "extern.h"

/* These functions open windows */
	
#define DSTRING	"Domain"
#define RSTRING	"Range"
#define MSTRING	"Draw"

XWMHints	xwmh = {
    			(InputHint|StateHint),		/* flags */
    			True,				/* input */
    			NormalState,			/* initial_state */
    			0,				/* icon pixmap */
    			0,				/* icon window */
    			0, 0,				/* icon location */
    			0,				/* icon mask */
    			0,				/* Window group */
		};

dofill(ac, av) 	
/* Open domain and range windows, draw the "unit" circle
and fill the unit circle with the regular hexagonal packing */
int ac;
char **av;
{
    	unsigned long 		fg, bg, bd, bw, mymask;		
    	XGCValues   		gcv;		
    	XEvent      		myevent;	
    	XSizeHints  		xsh;	
    	XSetWindowAttributes 	xswa;	
	int			i, x, y, vcount, diskdiam, diskrad;

	LRATIO = sizeof(double)/sizeof(int);
	
	/* Diameter of domain disk */
	diskdiam = 0.9*WINSIZE;
	diskrad = diskdiam/2.0;

	/* Set up display */
	XSetErrorHandler(NULL);
    	dpy = XOpenDisplay(NULL);
	XSynchronize(dpy, TRUE);

	/* Set up domain window */
    	bd = BlackPixel(dpy, DefaultScreen(dpy));
    	bg = WhitePixel(dpy, DefaultScreen(dpy));
    	fg = BlackPixel(dpy, DefaultScreen(dpy));

    	bw = 1;

    	xsh.flags = PSize;
	xsh.width = WINSIZE;
	xsh.height = WINSIZE;

    	domainwin = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, xsh.width, xsh.height, bw, bd, bg);
    	XSetStandardProperties(dpy, domainwin, DSTRING, DSTRING, None, av, ac, &xsh);
    	XSetWMHints(dpy, domainwin, &xwmh);
	
    	xswa.colormap = DefaultColormap(dpy, DefaultScreen(dpy));
    	xswa.bit_gravity = CenterGravity;
    	XChangeWindowAttributes(dpy, domainwin, (CWColormap | CWBitGravity), &xswa);

    	gcv.foreground = fg;
    	gcv.background = bg;
    	gc = XCreateGC(dpy, domainwin, (GCForeground | GCBackground), &gcv);

	/* Wait for user to open domain window */
    	XSelectInput(dpy, domainwin, ExposureMask);
    	XMapRaised(dpy, domainwin);
	XNextEvent(dpy, &myevent);
    	
	/* Set up range window */
    	rangewin = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, xsh.width, xsh.height, bw, bd, bg);
    	XSetStandardProperties(dpy, rangewin, RSTRING, RSTRING, None, av, ac, &xsh);
    	XSetWMHints(dpy, rangewin, &xwmh);
    	XChangeWindowAttributes(dpy, rangewin, (CWColormap | CWBitGravity), &xswa);
    	gc = XCreateGC(dpy, rangewin, (GCForeground | GCBackground), &gcv);

	/* Wait for user to open range window */
    	XSelectInput(dpy, rangewin, ExposureMask);
    	XMapRaised(dpy, rangewin);
	XNextEvent(dpy, &myevent);
	while (XCheckTypedEvent(dpy, Expose, &myevent));
	XDefineCursor(dpy, rangewin, XCreateFontCursor(dpy, XC_draft_small));

	XDefineCursor(dpy, domainwin, XCreateFontCursor(dpy, XC_draft_small));
	XSetForeground(dpy, gc, 1);
	XSetLineAttributes(dpy, gc, 2, LineSolid, CapNotLast, JoinMiter);

	x = y = WINSIZE/2.0 - diskrad;
	/* Draw the domain unit circle */
	XDrawArc(dpy, domainwin, gc, x, y, diskdiam, diskdiam, 0, X360DEGREES);
	XFlush(dpy);
	/* Dialog with user to select filling radius and fill */
	{
		double	rad;
		Bool	filling;
			
		XFlush(dpy);
		filling = TRUE;
		while (filling)	{
		/* Prompt user for a filling radius */
			printf ("Enter a filling radius, or 0 if satisfied with the mesh ==>");
			scanf ("%lf", &rad);
			if (rad > 0.0)	{
			/* Fill the circle */
				printf ("Filling...\n");
				endcircs();
				fillrad = rad;
				fillcircles(fillrad);

				/* Find the flower-connected component */
				DCirc[nullj+nulli*width].state = INTERIOR;
				konnect(nulli, nullj);

				/* Flag the boundary states */
				findboundary();

				/* Count the number of circles remaining in the disk */
				numcircles = 0;
				for (i=0; i<hw; ++i)	
					if (DCirc[i].state > OUTSIDE)	
						++numcircles;
				printf ("%d circles\n", numcircles);

				/* Allocate array of colors */
				mycolor = (int *) XtCalloc(numcircles, sizeof(int));

				/* Allocate array of DCirc indices of circles in the region */
				circindex = (int*) XtCalloc(numcircles, sizeof(int));
				vcount = 0;

				/* Store indices of circles in the region */
				for (i=0; i<hw; ++i)	
					if (DCirc[i].state > OUTSIDE)	{
						circindex[vcount] = i;
						++vcount;
					}

				/* Find the DCirc index of the lower right circle */
				findfix();

				/* Store in mycoloor[] a color scheme */
				assigncolor();

				/* Flag the cnums of circles in the region */
				doindexing();

				if (packingmode == SECTMODE)	{
				/* Using Thurston boundary modification */

					/* Free previous edge memory, if any */
					endedge();

					/* Flag state of circles not adjacent to the boundary */
					getdeepin();

					/* Move in circles that overlap the unit circle */
					massagebdry();

					/* Allocate memory for storing intersection angles */
					initedge();

					/* Store intersection angles determined by domain circle positions */
					assignxangles();
				}

				/* Draw the filled domain */
				drawdomain();
				XFlush(dpy);
			}
			else	
			/* A nonpositive filling radius has been entered.
			The user is now satisfied with the mesh */
				filling = FALSE;
		} /* while filling */
	}
} /* dofill */

getdrawwin(argc, argv)
/* Set up window for drawing boundary radius assignment curve */
int argc;
char **argv;
{
    	unsigned long 		fg, bg, bd, bw, mymask;		
    	XGCValues   		gcv;		
    	XEvent      		myevent;	
    	XSizeHints  		xsh;	
    	XSetWindowAttributes 	xswa;	

	XSetForeground(dpy, gc, 1);

	/* Set up draw window */
    	bd = BlackPixel(dpy, DefaultScreen(dpy));
    	bg = WhitePixel(dpy, DefaultScreen(dpy));
    	fg = BlackPixel(dpy, DefaultScreen(dpy));

    	bw = 1;

    	xsh.flags = PSize;
	xsh.width = DRAWWIDTH;
	xsh.height = DRAWHEIGHT;
    	drawwin = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, xsh.width, xsh.height, bw, bd, bg);
    	XSetStandardProperties(dpy, drawwin, MSTRING, MSTRING, None, argv, argc, &xsh);
    	XSetWMHints(dpy, drawwin, &xwmh);
    	XChangeWindowAttributes(dpy, drawwin, (CWColormap | CWBitGravity), &xswa);
    	gc = XCreateGC(dpy, drawwin, (GCForeground | GCBackground), &gcv);

	/* Wait for user to open draw window */
    	XSelectInput(dpy, drawwin, ExposureMask);
    	XMapRaised(dpy, drawwin);
	XNextEvent(dpy, &myevent);
	XDefineCursor(dpy, drawwin, XCreateFontCursor(dpy, XC_pencil));
} /* getdrawwin */

