
/*
  $Header: /usr4/Geom_utilities/Tri2quad/RCS/main.c,v 1.1 91/03/12 16:44:02 meuer Exp $

  Main routine for the tri2quad.

  Reads a bunch of numbers and adds them up.

  Mark Meuer
  #1267045

  */

#include	<strings.h>
#include	"tri2quad.h"

main( argc, argv )
     int	argc;
     char	**argv;
{
    char	*in_file_name, *out_file_name;
    FILE	*in_file, *out_file;
    int		chunk_size;


    fprintf(stderr, "\n%s - convert triangles to quadrilaterals\n", argv[0]);
    fprintf(stderr, "Geometry Supercomputer Project\n\n", argv[0]);
    fflush(stderr);
    /* PARSE THE COMMAND ARGUMENTS */
    parse_command_line( argc, argv, &in_file_name, &out_file_name );

    /* OPEN THE FILES */
    fprintf( stderr, "Reading from %s, writing to %s.\n",
	   ( strcmp(in_file_name, "-") == 0 ) ? "standard input" : in_file_name,
	   ( strcmp(out_file_name, "-") == 0 ) ? "standard output" : out_file_name );
    if ( strcmp(in_file_name, "-") ==  0 )
    {
	in_file = stdin;
    }
    else
    {
	in_file = open_file( in_file_name, "r" );
    }
    
    if ( strcmp(out_file_name, "-") ==  0 )
    {
	out_file = stdout;
    }
    else
    {
	out_file = open_file( out_file_name, "w" );
    }

    /* PROCESS THE NUMBERS */
    process_triangles( in_file, out_file );
    
    /* CLOSE THE FILES */
    if ( in_file != stdin )
    {
	fclose( in_file );
    }

    if ( out_file != stdout )
    {
	fclose( out_file );
    }

    fprintf(stderr, "%s ended normally.\n", argv[0]);
    exit(0);
}
