
/*
  $Header: /usr2/meuer/Geom_utilities/Poly2tri/RCS/process_polygons.c,v 1.3 91/02/20 17:08:42 meuer Exp $


  Read in a list of polygons and feed them one-by-one into the routine that will break them
  into triangles.

  Mark Meuer
  #1267045

  */

#include	"poly2tri.h"

void
process_polygons( in_file, out_file, no_sides )
     FILE 	*in_file, *out_file;
     int	no_sides;
{
    int	success = TRUE;
    Polygon	polygon;
    int	no_polys = 0;	/* Number of polygons processed */
    int order_changed;	/* Flag to indicate that the vertex order has been changed */
    
    /* WHILE NOT AT THE END OF THE LIST, */
    while( (!feof( in_file )) && (success) )
    {
	/* READ ONE POLYGON */
	success = read_polygon(in_file, &polygon, no_sides);
	
	/* IF SUCCESSFUL, */
	if (success)
	{
	    /* PROJECT THE VERTICIES INTO THE XY PLANE IN COUNTER-CLOCKWISE ORDER. */
	    project_verticies_to_xy( &polygon );

	    /* PUT THE VERTICIES IN CLOCKWISE ORDER */
	    order_changed = sort_verticies( &polygon );
    
	    /* BREAK IT INTO TRIANGLES */
	    break_polygon(&polygon, out_file, order_changed);
	    no_polys++;
	}
    }
    fprintf(stderr, "Processed %d polygons.\n", no_polys );
}
