
/*
  $Header: /usr2/meuer/Geom_utilities/Poly2tri/RCS/print_poly.c,v 1.4 91/02/20 17:08:40 meuer Exp $

  Print out all data about a polygon.  Used only if debugging.

  Mark Meuer
  #1267045

  */

#include	"poly2tri.h"

void
print_polygon( out_file, polygon )
     FILE	*out_file;
     Polygon	*polygon;
{
    int	i = 0;
    Vertex	*vertex;

    fprintf(out_file, "---\nPolygon has %d verticies.  They are (world coordinates on left):\n",
	    polygon->no_verticies);
    vertex = polygon->top_vertex;
    if ( vertex )
    {
	do
	{
	    fprintf(out_file, "\t(%f, %f, %f)\t",
		    vertex->world_coords[0],
		    vertex->world_coords[1],
		    vertex->world_coords[2]);

	    fprintf(out_file, "\t(%f, %f, %f)\t",
		    vertex->plane_coords[0],
		    vertex->plane_coords[1],
		    vertex->plane_coords[2]);

	    switch( vertex-> type )
	    {
	      case CONCAVE:
		fprintf(out_file, "CONCAVE");
		break;
		
	      case CONVEX:
		fprintf(out_file, "CONVEX");
		break;
		
	      case UNCLASSIFIED:
		fprintf(out_file, "UNCLASSIFIED");
		break;

	      default:
		fprintf(stderr, "Internal error: Illegal vertex classification: %d\n",
			vertex->type);
		fprintf(stderr, "I quit.\n");
		exit(-1);
		break;
	    }
		
	    fprintf(out_file, "\n");
	    vertex = vertex->next_vertex;
	    i++;
	} while ( vertex != polygon->top_vertex );
    }
    fprintf(out_file, "\n---\n");
    fflush(out_file);
}

