
/* $Header: /usr2/meuer/Geom_utilities/Matrix_util/RCS/transpose_mat.c,v 1.1 91/02/19 16:17:35 meuer Exp $ */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/transpose_mat.c,v $ */

/*
 * Routine to transpose a matrix.  For rotation matricies, this has the
 * effect of inverting them.
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
transpose_matrix(result, source)
Matrix          result;
Matrix          source;
{
	/* DECLARE VARIABLES */
	int             row;
	int             column;

	/* FOR EACH ROW, */
	for (row = 0; row < MATRIX_SIZE; row++)
	{
		/* FOR EACH COLUMN TO THE RIGHT OF THE DIAGONAL, */
		for (column = row; column < MATRIX_SIZE; column++)
		{
			/* SWAP ELEMENTS AROUND THE DIAGONAL */
			result[row][column] = source[column][row];
			result[column][row] = source[row][column];
		}
	}
}
