
/*
 * $Header: /n/poincare/usr2/meuer/5117/RCS/transform_point.c,v 1.5 89/05/06
 * 13:44:03 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/transform_pt.c,v $ */

/*
 * Routine to transformat a point by a matrix
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
transform_point(xform_matrix, in_point, out_point)
Matrix          xform_matrix;
Point           in_point;
Point           out_point;
{
	/* DECLARE VARIABLES */
	int             column;
	int             sub_index;
	PointElement    subtotal;

	/* FOR EACH COLUMN IN THE POINT */
	for (column = 0; column < MATRIX_SIZE; column++)
	{
		/* COMPUTE VALUE FOR THIS POINT */
		/* out_point[row] = 0.0; */
		subtotal = 0.0;
		for (sub_index = 0; sub_index < MATRIX_SIZE; sub_index++)
		{
			/* out_point[row] += */

			/*
			 * (xform_matrix[row][sub_index] *
			 * in_point[sub_index]);
			 */
			subtotal += (in_point[sub_index] * xform_matrix[sub_index][column]);
		}
		out_point[column] = subtotal;
	}
}
