

/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*****************************************************************
*
*  File: softimag.c
*
*  Purpose:  Triangle list file output for Softimage input.
*/

#include "include.h"

static FILE *fd;

/*****************************************************************
*
*  Function: softimage()
*
*  Purpose:  Get file name from user.
*/

void softimage()
{
  char filename[100];
  char name[100];
  vertex_id v_id;
  facet_id f_id;

  prompt("Enter file name (no suffix): ",name);

  /* model file */
  strcpy(filename,name);
  strcat(filename,".mdl");
  fd = fopen(filename,"w");
  if ( fd == NULL )
    { perror(filename);
      return;
    }
  fprintf(fd,"SOFTIMAGE 4D Creative Environment   v 1.6  \"ASCII\"\n\n\n");
  fprintf(fd,"  MODL   \"%s\"\n  {\n    type    PMSH\n",name);
  fprintf(fd,"    nbdef   1\n");
  fprintf(fd,"    scal      1.000000  1.000000  1.000000\n");
  fprintf(fd,"    rot       0.000000  0.000000  0.000000\n");
  fprintf(fd,"    trans     0.000000  0.000000  0.000000\n");
  fprintf(fd,"  }\n");
  fclose(fd);


  strcpy(filename,name);
  strcat(filename,".def");
  fd = fopen(filename,"w");
  if ( fd == NULL )
    { perror(filename);
      return;
    }
  fprintf(fd,"SOFTIMAGE 4D Creative Environment   v 1.6  \"ASCII\"\n\n");
  fprintf(fd,"PMSH   \"%s\"\n  {\n  ",name);

  /* vertex list */
  fprintf(fd,"   vertex %d\n",web.skel[VERTEX].count);
  FOR_ALL_VERTICES(v_id)
    { REAL *x = get_coord(v_id);
      fprintf(fd,"%12d %14.12f %14.12f %14.12f\n",
            ordinal(v_id)+1,x[0],x[1],x[2]);
    } 
 

  /* triangle list */
  fprintf(fd,"\n   polygon %d\n",web.skel[FACET].count);
  FOR_ALL_FACETS(f_id)
    { facetedge_id fe = get_facet_fe(f_id);
      facetedge_id next_fe = get_next_edge(fe);
      fprintf(fd,"    %10d %10d %10d %10d\n",
         ordinal(get_fe_headv(fe))+1,
         ordinal(get_fe_headv(next_fe))+1,
         ordinal(get_fe_tailv(fe))+1,
         ordinal(get_fe_tailv(fe))+1);
    } 
  fprintf(fd,"   }\n\n");
 
  fclose(fd);
}

