# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/**********************************************************
*
*  File:  lex.yy.c
*
*  Contents: lexical analyzer for evolver data files.
*            Constructed from datafile.lex by lex.
*/

/* will have my own input() and output() */
#undef input
#undef unput

#include "include.h"
#include "lex.h"
#include "ytab.h"
#include "express.h"

#ifndef NOPROTO
int yyback(int *,int);
#define yyoutput yyout_unused
#define yyunput yyunput_unused
#endif

extern FILE *data_fd;
extern int int_val;
extern double real_val;
extern char *cmdptr;
int line_no = 1;

int macro_flag;

char *white = " \t\r,:;";   /* whitespace */

#define NAMESIZE 30
struct macro { char name[NAMESIZE];
		    int  offset;    /* start of substitute string */
		    int  subsize;   /* size of substitute string */
		  } *macros;  /* dynamically allocated */
int macro_count;  /* number of macros defined */
int macro_max;    /* number of macro structures allocated */
#define SUBMAX 500
char  *macro_subs;  /* string space for substitution strings */
		    /* dynamically allocated */
int  macro_subs_top;  /* index of top of string space */
int  macro_subs_max;   /* space allocated for strings */

struct dkey { char *name; int token; } datafile_keywords[] =
{
  {"approximate_curvature",APPROX_CURV_},
  {"approx_curvature",APPROX_CURV_},
  {"phasefile",PHASEFILE_},
  {"phase",PHASE_},
  {"autopop",AUTOPOP_},
  {"autochop",AUTOCHOP_},
  {"total_time",TOTAL_TIME_},
  {"effective_area",EFFECTIVE_AREA_},
  {"runge_kutta",RUNGE_KUTTA_},
  {"color",COLOR_},
  {"square_curvature",SQUARE_CURVATURE_},
  {"space_dimension",SPACE_DIMENSION_},
  {"surface_dimension",SURFACE_DIMENSION_},
  {"simplex_representation",SIMPLEX_REP_},
  {"metric",METRIC_},
  {"conformal_metric",CONFORMAL_},
  {"fixed",FIXED_},
  {"symmetry_group",SYMMETRY_GROUP_},
  {"wrap",WRAP_},
  {"torus",TORUS_},
  {"torus_filled",TORUS_FILLED_},
  {"periods",PERIODS_},
  {"string",STRING_},
  {"soapfilm",SOAPFILM_},
  {"wulff",WULFF_},
  {"boundary",BOUNDARY_},
  {"boundaries",BOUNDARY_},
  {"constraint",CONSTRAINT_},
  {"constraints",CONSTRAINT_},
  {"surface_energy",SURFACE_ENERGY_},
  {"formula",FUNCTION_},
  {"function",FUNCTION_},
  {"parameter",PARAMETERS_},
  {"parameters",PARAMETERS_},
  {"parameter_file",PARAMETER_FILE_},
  {"symmetric_content",SYMMETRIC_CONTENT_},
  {"integral_order",INTEGRAL_ORDER_},
  {"constraint_tolerance",CONSTRAINT_TOLERANCE_ },
  {"convex",CONVEX_},
  {"nonnegative",NONNEGATIVE_},
  {"nonpositive",NONPOSITIVE_},
  {"global",GLOBAL_},
  {"energy",ENERGY_},
  {"energies",ENERGY_},
  {"content",CONTENT_},
  {"quadratic",QUADRATIC_},
  {"linear",LINEAR_},
  {"area_normalization",MEAN_CURV_},
  {"jiggle",JIGGLE_},
  {"diffusion",DIFFUSION_},
  {"merit_factor",MERITFACTOR_},
  {"gravity_constant",GRAV_CONST_},
  {"spring_constant",SPRING_CONSTANT_},
  {"scale",SCALE_},
  {"temperature",TEMPERATURE_},
  {"pressure",PRESSURE_},
  {"volume",VOLUME_},
  {"density",DENSITY_},
  {"tension",DENSITY_},
  {"nodisplay",NODISPLAY_},
  {"scale_limit",SCALE_LIMIT_},
  {"zoom_vertex",ZOOM_VERTEX_},
  {"zoom_radius",ZOOM_RADIUS_},
  {"quantity",QUANTITY_ },
  {"volconst",VOLCONST_ },
  {"sin",SIN_},
  {"cos",COS_},
  {"log",LOG_},
  {"exp",EXP_},
  {"tan",TAN_},
  {"asin",ASIN_},
  {"acos",ACOS_},
  {"atan",ATAN_},
  {"sqrt",SQRT_},
  {"sqr",SQR_},
  {"abs",ABS_},
  {"pi",PI_},
  {"e",E_},
  {"g",G_},
  {"tag",TAG_},
  {"original",ORIGINAL_},
  {"vertices",VERTICES_},
  {"edges",EDGES_},
  {"faces",FACES_},
  {"facets",FACES_},
  {"bodies",BODIES_},
  {"facet_edges",FACETEDGES_}
};

struct ckey { char *name; int token; } const_expr_keywords[] =
{
  {"sin",SIN_},
  {"cos",COS_},
  {"log",LOG_},
  {"exp",EXP_},
  {"tan",TAN_},
  {"asin",ASIN_},
  {"acos",ACOS_},
  {"atan",ATAN_},
  {"sqrt",SQRT_},
  {"sqr",SQR_},
  {"pi",PI_},
  {"e",E_},
  {"g",G_}
};

struct ckey command_keywords[] =
{
  {"id",ID_},
  {"and",AND_},
  {"or",OR_},
  {"not",NOT_},
  {"sin",SIN_},
  {"cos",COS_},
  {"log",LOG_},
  {"exp",EXP_},
  {"tan",TAN_},
  {"asin",ASIN_},
  {"acos",ACOS_},
  {"atan",ATAN_},
  {"sqrt",SQRT_},
  {"sqr",SQR_},
  {"abs",ABS_},
  {"pi",PI_},
  {"e",E_},
  {"g",G_},
  {"tag",TAG_},
  {"original",ORIGINAL_},
  {"fixed",FIXED_},
  {"vertices",VERTICES_},
  {"vertex",VERTICES_},
  {"edges",EDGES_},
  {"edge",EDGES_},
  {"facets",FACETS_},
  {"facet",FACETS_},
  {"faces",FACETS_},
  {"face",FACETS_},
  {"facet_edges",FACETEDGES_},
  {"facetedges",FACETEDGES_},
  {"bodies",BODIES_},
  {"body",BODIES_},
  {"everything",EVERYTHING_},
  {"topinfo",TOPINFO_},
  {"length",LENGTH_ },
  {"valence",VALENCE_ },
  {"area",AREA_ },
  {"volume",VOLUME_ },
  {"where",WHERE_ },
  {"list",LIST_ },
  {"show",SHOW_},
  {"delete",DELETE_ },
  {"refine",REFINE_ },
  {"shell",SHELL_},
  {"fixed",FIXED_},
  {"constraint",CONSTRAINT_},
  {"pressure",PRESSURE_},
  {"color",COLOR_},
  {"opacity",OPACITY_},
  {"volume",VOLUME_},
  {"density",DENSITY_},
  {"tension",DENSITY_},
  {"set",SET_},
  {"read",READ_},
  {"unset",UNSET_},
  {"recalc",RECALC_},
  {"integral_order",INTEGRAL_ORDER_}
 }; 

#define MAXCOLOR 17 
struct ckey colornames[MAXCOLOR] = {
    {"clear",CLEAR},     /* transparent */
    {"black",BLACK},		    /* dark colors */
    {"blue",BLUE},
    {"green",GREEN},
    {"cyan",CYAN},
    {"red",RED},
    {"magenta",MAGENTA},
    {"brown",BROWN},
    {"lightgray",LIGHTGRAY},
    {"darkgray",DARKGRAY},		    /* light colors */
    {"lightblue",LIGHTBLUE},
    {"lightgreen",LIGHTGREEN},
    {"lightcyan",LIGHTCYAN},
    {"lightred",LIGHTRED},
    {"lightmagenta",LIGHTMAGENTA},
    {"yellow",YELLOW},
    {"white",WHITE}
    };
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
 { real_val = (REAL)(int_val = atoi(strtok(yytext,white)));
               return(tok=LEAD_INTEGER_); 
	      }
break;
case 2:
case 3:
       { real_val = (REAL)(int_val = atoi(strtok(yytext,white))); 
	      if (datafile_flag && (parens==0))
		 return(tok = INTEGER_); 
              else return (tok = SIGNED_NUMBER_);
	      }
break;
case 4:
     { sscanf(yytext+2,"%x",&int_val); real_val = (REAL)int_val;
	      return(tok = INTEGER_);}
break;
case 5:
     { char *c = yytext;  /* binary */
	      int_val = 0;
	      while ( isdigit(*c) ) { int_val = 2*int_val + *c - '0'; c++;}
	    }
break;
case 6:
  case 7:
  case 8:
    { real_val = atof(strtok(yytext,white));  
	      if (datafile_flag && (parens==0))
		 return(tok = REAL_); 
              else return (tok = SIGNED_NUMBER_);
	      }
break;
case 9:
  case 10:
  case 11:
    { real_val = atof(yytext);  return(tok = REAL_); }
break;
case 12:
  ;
break;
case 13:
      ;
break;
case 14:
       {
             int k,len = strlen(yytext);
	     for ( k = 0 ; k < len-2 ; k++ ) yytext[k] = yytext[k+1];
	     yytext[len-2] = '\0'; 
	     return(tok = QUOTATION_);
	     }
break;
case 15:
 return (tok = minus_type());
break;
case 16:
       { if (datafile_flag && (parens == 0) )  return(tok = UMINUS_);
               else return ( tok = minus_type() );
             }
break;
case 17:
         return(tok = UMINUS_);
break;
case 18:
      return (tok = minus_type());
break;
case 19:
         return(tok = yytext[0]);
break;
case 20:
        {  parens++; return(tok = yytext[0]); }
break;
case 21:
        { parens--; return(tok = yytext[0]);  }
break;
case 22:
    return (tok = '^');
break;
case 23:
      return(tok = POW_);
break;
case 24:
      return(tok = EQ_);
break;
case 25:
      return(tok = NE_);
break;
case 26:
      return(tok = LE_);
break;
case 27:
      return(tok = GE_);
break;
case 28:
      return(tok = OR_);
break;
case 29:
      return(tok = AND_);
break;
case 30:
       return(tok = NOT_);
break;
case 31:
 { int_val = atoi(strtok(yytext,white)+1); return(tok = ENVECT_); }
break;
case 32:
 { int_val = atoi(strtok(yytext,white)+1); return(tok = CONVECT_); }
break;
case 33:
 { int_val = atoi(strtok(yytext,white)+1); return(tok = COORD_); }
break;
case 34:
 { int_val = atoi(strtok(yytext,white)+1); return(tok = QVECT_); }
break;
case 35:
     { int_val = atoi(yytext+1); return(tok = PARAM_); }
break;
case 36:
     { int_val = atoi(yytext+1); return(tok = QVECT_); }
break;
case 37:
     { int_val = atoi(yytext+1); return(tok = COORD_); }
break;
case 38:
         { int_val = 1; return(tok = COORD_); }
break;
case 39:
         { int_val = 2; return(tok = COORD_); }
break;
case 40:
         { int_val = 3; return(tok = COORD_); }
break;
case 41:
   { int_val = atoi(yytext+3); return(tok = USERFUNC_); }
break;
case 42:
   macro_flag = 1;
break;
case 43:
  { if ( macro_flag ) record_macro();
                     else if ( !macro() ) /* search keywords */
		       { int k;
			 /* search parameter names */
                         for ( k = 0 ; k < (NTYPE)web.paramcount ; k++ )
                           if ( strncmp(yytext,web.params[k].name,31) == 0 )
                            { int_val = k;
			      return (tok = IDENT_);
                            }
			 /* search color names */
			 for ( k = 0 ; k < MAXCOLOR ; k++ )
			   if ( strcmp(yytext,colornames[k].name) ==  0 )
			     { real_val = int_val = colornames[k].token;
			       return (tok = INTEGER_);
			     }
			 if ( const_expr_flag )
			  { for ( k = 0 ; k < sizeof(const_expr_keywords)/
			        sizeof(struct ckey) ; k++ )
			     if (strcmp(yytext,const_expr_keywords[k].name)==0)
			       return (tok = const_expr_keywords[k].token);
			  }
			 else if ( datafile_flag )
			  { for ( k = 0 ; k < sizeof(datafile_keywords)/
			        sizeof(struct dkey) ; k++ )
			     if (strcmp(yytext,datafile_keywords[k].name)==0)
			       return (tok = datafile_keywords[k].token);
			  }
			 else
			  { for ( k = 0 ; k < sizeof(command_keywords)/
			      sizeof(struct ckey) ; k++ )
			     if ( strcmp(yytext,command_keywords[k].name) == 0 )
			       return (tok = command_keywords[k].token);
			  }
                         /* if here, then not keyword */
		         return(tok = UNKNOWN) ;
		       }
		   }
break;
case 44:
    ;
break;
case 45:
     ;
break;
case 46:
      { if ( isprint(yytext[0]) )
	    sprintf(errmsg,"Illegal character: %c\n",yytext[0]);
	  else
	    sprintf(errmsg,"Illegal character: 0x%02X\n",yytext[0]);
          yyerror(errmsg);
        }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* My own input() function to handle case insensitivity and macros */
/* and line counting */

#define BUFFSIZE 400
static char buff[BUFFSIZE];
static int  spot = 0;
#define ERRBUFFSIZE 80
static char errbuff[ERRBUFFSIZE];  /* for reporting spot of error */
static int  errspot;

int rawinput()
{
  int c;
  if ( cmdptr )
   {
     if ( !*cmdptr ) return 0;
     else c = *(cmdptr++);
   }
  else
   {
     if ( data_fd == NULL ) return 0;  /* in case read after close */
     c = getc(data_fd);
     if ( c == -1 ) c = 0;
   }
  if ( c == '\n' ) errspot = 0 ;  /* reset for new line */
  errbuff[errspot++] = (char)c;
  if ( errspot == ERRBUFFSIZE ) /* need partial reset */
    { memcpy(errbuff,errbuff+ERRBUFFSIZE/2,ERRBUFFSIZE/2);
      errspot = ERRBUFFSIZE/2;
    }
  return tolower(c);
}

int input()
{
  int c;

  if ( spot > 0 ) 
    c = buff[--spot];
  else
    { 
      c = rawinput();
      if ( c == '\\' )  /* line splicing */
	{ c = rawinput();
	  if ( c == '\n' ) { line_no++; c = ' '; }
	  if ( c == 0 )
	    { outstring("more> ");
	      getstring(msg);
	      cmdptr = msg;
	      c = ' ';  /* linesplicing ends token */
	    }
	}
      else if ( c == '/' ) /* possible comment */
	{ c = rawinput();
	  if ( c == '/' ) /* end-of-line comment */
	    { while ( (c = rawinput()) != '\n' )
	        if ( c == 0 ) { break; } 
	    }
	  else if ( c == '*' ) /* in-line comment */
	    { int state = 0;
	      do 
		{ c = rawinput();
		  if ( c == 0 ) { break; }
		  else  if ( c == '\n' ) { line_no++; state = 0; }
		  else if ( c == '*' ) state = '*';
                  else if ( (c == '/') && (state == '*') )
		    { c = ' '; break; }
		  else state = 0;
		} 
	      while ( state != 1 );
	    }
	  else /* false alarm */
	    { buff[spot++] = (char)c;  /* save char */
	      c = '/';
	    }
	} /* end comment */
	    
    } /* end new char */

  if ( c == '\n' ) line_no++;
  return tolower(c);
}

void unput(c)
int c;
{
  if ( spot >= BUFFSIZE - 1 ) 
    error("lex buffer overflow.\n",UNRECOVERABLE);

  if ( c == '\n' ) line_no--;
  buff[spot++] = (char)c;
}

void dump_buff() /* for error reporting */
{
  int k;
  fprintf(stderr,"  Input line so far: ");
  for ( k = 0 ; k < errspot ; k++ )
    fputc(errbuff[k],stderr);
  fputc('\n',stderr);
  fputc('\n',stderr);
}

int yywrap()
{
  if ( datafile_flag )
    {
      if ( data_fd ) fclose(data_fd);
      data_fd = NULL;
      if ( macro_subs ) free((char *)macro_subs);
      if ( macros ) free ((char *)macros);
      macro_subs = NULL;
      macros = NULL;
      macro_count = macro_subs_top = macro_max = macro_subs_max = 0;
    }
  spot = 0;
  return 1;  /* done */
}

void yylex_init()
{
  spot = 0;
  errspot = 0;
}

/*************************************************************
*
*  Function: record_macro()
*
*  Purpose:  Record macro definition.
*
*/

void record_macro()
{
  int len;
  char *spot;

  macro_flag = 0;

  if ( macro_count >= macro_max )
    { if ( macro_max == 0 )
	{ macro_max = 10; 
	  macros = (struct macro *)mycalloc(macro_max,sizeof(struct macro));
	}
      else
	{ macro_max += 10; 
	  macros = (struct macro *)realloc((char *)macros,
			   macro_max*sizeof(struct macro));
	}
    }

  strncpy(macros[macro_count].name,yytext,NAMESIZE);

  if ( macro_subs_top+SUBMAX >= macro_subs_max )
    { if ( macro_subs_max == 0 )
	{ macro_subs_max = 2*SUBMAX; 
	  macro_subs = (char *)mycalloc(macro_subs_max,1);
	}
      else
	{ macro_subs_max += 2*SUBMAX; 
	  macro_subs = (char *)realloc(macro_subs,macro_subs_max);
	}
    }

  spot = macro_subs+macro_subs_top;
  for ( len = 0 ; len < SUBMAX ; len++ )
    { int c = input();
      if ( (c == '\0') || (c == '\n') ) break;
      spot[len] = (char)c;
    }

  if ( len >= SUBMAX )
     error("Macro definition too long.\n",UNRECOVERABLE);

  /* strip terminal comment */
  if ( strstr(spot,"//") )
    { *strstr(spot,"//") = 0;
      len = strlen(spot);
    }
  else spot[len] = 0;
  macros[macro_count].subsize = len;
  macros[macro_count++].offset = macro_subs_top;
  macro_subs_top += len+1;
}

/*************************************************************
*
*  Function:  macro()
*
*  Purpose: See if yytext is a macro, and do substitution.
*
*  Return:  1 if macro, 0 if not.
*
*/

int macro()
{
  int n,k;
  char *c;

  /* find name, simple linear search */
  for ( n = 0 ; n < macro_count ; n++ )
     if ( strcmp(yytext,macros[n].name) == 0 ) break;

  if ( n == macro_count ) return 0;   /* not found */

  /* insert string into input in reverse order so reads ok */
  c = macro_subs+macros[n].offset;
  for ( k = macros[n].subsize - 1 ; k >= 0 ; k-- )
    unput(c[k]);

  return 1;
}

/* for deciding type of minus sign */
int minus_type()
{
	   { switch ( tok )
		 {  case LEAD_INTEGER_:
		    case SIGNED_NUMBER_:
		    case INTEGER_:
		    case REAL_:
		    case PI_:
		    case E_:
		    case G_:
		    case PARAM_:
		    case COORD_:
		    case IDENT_:
		    case '^': 
		    case ')': return '-'; 
		    default: return UMINUS_ ;
		 }
	     }
  return '-';  /* to satisfy picky compilers that want a guaranteed return */
}

int yyvstop[] = {
0,

45,
0,

45,
0,

46,
0,

45,
46,
0,

44,
0,

30,
46,
0,

46,
0,

46,
0,

46,
0,

20,
46,
0,

21,
46,
0,

19,
46,
0,

19,
46,
0,

18,
46,
0,

46,
0,

19,
46,
0,

3,
46,
0,

3,
46,
0,

3,
46,
0,

19,
46,
0,

19,
46,
0,

19,
46,
0,

46,
0,

43,
46,
0,

43,
46,
0,

43,
46,
0,

43,
46,
0,

38,
43,
46,
0,

39,
43,
46,
0,

40,
43,
46,
0,

46,
0,

45,
46,
0,

17,
18,
46,
0,

1,
3,
46,
0,

1,
3,
46,
0,

1,
3,
46,
0,

43,
46,
0,

43,
46,
0,

43,
46,
0,

38,
43,
46,
0,

45,
0,

16,
0,

25,
0,

14,
0,

29,
0,

23,
0,

10,
0,

13,
0,

9,
0,

3,
0,

3,
0,

5,
0,

26,
0,

24,
0,

27,
0,

22,
0,

43,
0,

35,
43,
0,

36,
43,
0,

43,
0,

37,
43,
0,

28,
0,

45,
0,

16,
0,

1,
0,

1,
3,
0,

1,
3,
0,

32,
43,
0,

31,
43,
0,

34,
36,
43,
0,

33,
37,
43,
0,

2,
0,

15,
0,

9,
10,
0,

11,
0,

4,
0,

43,
0,

1,
2,
0,

32,
0,

31,
0,

34,
0,

33,
0,

7,
0,

6,
0,

10,
0,

12,
0,

9,
0,

41,
43,
0,

6,
7,
0,

8,
0,

9,
10,
0,

7,
0,

6,
0,

6,
7,
0,

42,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	45,0,	46,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	4,41,	0,0,	
0,0,	0,0,	4,41,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,6,	1,7,	
1,8,	45,46,	46,46,	1,9,	
9,48,	1,10,	1,11,	1,12,	
1,13,	4,41,	1,14,	1,15,	
1,16,	1,17,	1,18,	1,19,	
2,32,	12,49,	16,51,	0,0,	
4,42,	4,41,	4,43,	16,52,	
0,0,	1,20,	1,21,	1,22,	
6,44,	20,59,	21,60,	22,61,	
0,0,	1,3,	0,0,	4,41,	
4,41,	0,0,	0,0,	84,101,	
2,6,	2,7,	2,8,	50,87,	
50,87,	2,9,	0,0,	2,10,	
2,11,	0,0,	0,0,	0,0,	
2,33,	2,15,	2,16,	2,34,	
2,35,	2,36,	0,0,	1,23,	
1,24,	84,102,	84,102,	7,45,	
0,0,	1,24,	8,47,	2,20,	
2,21,	2,22,	47,86,	7,45,	
7,0,	86,103,	103,116,	50,87,	
50,87,	1,25,	1,26,	67,94,	
27,67,	116,124,	1,27,	89,107,	
89,107,	1,28,	1,29,	1,30,	
124,127,	1,31,	31,69,	0,0,	
0,0,	84,102,	84,102,	0,0,	
7,46,	0,0,	0,0,	0,0,	
0,0,	2,23,	0,0,	0,0,	
7,45,	7,45,	2,37,	7,45,	
2,38,	0,0,	7,45,	0,0,	
7,45,	0,0,	0,0,	89,107,	
89,107,	0,0,	0,0,	2,25,	
2,39,	0,0,	100,111,	100,111,	
2,27,	0,0,	0,0,	2,40,	
2,29,	2,30,	7,45,	2,31,	
15,50,	15,50,	15,50,	15,50,	
15,50,	15,50,	15,50,	15,50,	
15,50,	15,50,	17,53,	0,0,	
17,54,	17,54,	17,55,	17,55,	
17,55,	17,55,	17,55,	17,55,	
17,55,	17,55,	100,111,	100,111,	
0,0,	7,45,	112,121,	112,121,	
0,0,	0,0,	7,45,	0,0,	
17,56,	17,56,	18,53,	0,0,	
18,54,	18,54,	18,55,	18,55,	
18,55,	18,55,	18,55,	18,55,	
18,55,	18,55,	25,65,	25,65,	
25,65,	25,65,	25,65,	25,65,	
25,65,	25,65,	25,65,	25,65,	
18,56,	18,56,	112,121,	112,121,	
0,0,	0,0,	17,57,	0,0,	
17,56,	17,56,	0,0,	0,0,	
19,53,	0,0,	19,55,	19,55,	
19,55,	19,55,	19,55,	19,55,	
19,55,	19,55,	19,55,	19,55,	
0,0,	0,0,	0,0,	0,0,	
17,58,	0,0,	18,57,	0,0,	
18,56,	18,56,	19,56,	19,56,	
23,62,	0,0,	0,0,	23,63,	
23,63,	23,63,	23,63,	23,63,	
23,63,	23,63,	23,63,	23,63,	
23,63,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,56,	19,56,	
26,66,	26,66,	26,66,	26,66,	
26,66,	26,66,	26,66,	26,66,	
26,66,	26,66,	28,68,	28,68,	
28,68,	28,68,	28,68,	28,68,	
28,68,	28,68,	28,68,	28,68,	
0,0,	88,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
24,64,	0,0,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
32,70,	0,0,	88,106,	0,0,	
32,70,	33,72,	33,72,	33,72,	
33,72,	33,72,	33,72,	33,72,	
33,72,	33,72,	33,72,	88,51,	
88,51,	88,51,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,70,	
34,77,	34,77,	34,78,	34,78,	
34,78,	34,78,	34,78,	34,78,	
34,78,	34,78,	32,42,	32,70,	
32,71,	0,0,	0,0,	32,72,	
32,72,	32,72,	32,72,	32,72,	
32,72,	32,72,	32,72,	32,72,	
32,72,	32,70,	32,70,	35,77,	
35,77,	35,78,	35,78,	35,78,	
35,78,	35,78,	35,78,	35,78,	
35,78,	36,78,	36,78,	36,78,	
36,78,	36,78,	36,78,	36,78,	
36,78,	36,78,	36,78,	37,79,	
37,79,	37,79,	37,79,	37,79,	
37,79,	37,79,	37,79,	37,79,	
37,79,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	32,73,	0,0,	
32,74,	38,80,	38,80,	38,80,	
38,80,	38,80,	38,80,	38,80,	
38,80,	38,80,	38,80,	0,0,	
32,75,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,76,	
39,81,	39,81,	39,81,	39,81,	
39,81,	39,81,	39,81,	39,81,	
39,81,	39,81,	40,82,	40,82,	
40,82,	40,82,	40,82,	40,82,	
40,82,	40,82,	40,82,	40,82,	
42,83,	0,0,	42,84,	42,84,	
42,84,	42,84,	42,84,	42,84,	
42,84,	42,84,	42,84,	42,84,	
43,85,	0,0,	0,0,	0,0,	
43,85,	0,0,	0,0,	0,0,	
0,0,	0,0,	51,51,	85,85,	
0,0,	0,0,	0,0,	85,85,	
106,0,	0,0,	51,51,	51,0,	
0,0,	0,0,	0,0,	43,85,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	52,52,	
0,0,	0,0,	85,85,	43,85,	
0,0,	0,0,	0,0,	52,52,	
52,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	85,85,	0,0,	
0,0,	43,85,	43,85,	51,88,	
51,51,	106,51,	51,51,	0,0,	
51,51,	51,51,	0,0,	51,51,	
85,85,	85,85,	0,0,	0,0,	
0,0,	0,0,	106,51,	106,51,	
106,51,	51,51,	51,51,	51,51,	
52,52,	52,52,	0,0,	52,52,	
0,0,	51,51,	52,52,	0,0,	
52,52,	53,89,	53,89,	53,89,	
53,89,	53,89,	53,89,	53,89,	
53,89,	53,89,	53,89,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	52,52,	0,0,	
0,0,	53,90,	53,90,	0,0,	
51,51,	56,91,	0,0,	56,91,	
0,0,	51,51,	56,92,	56,92,	
56,92,	56,92,	56,92,	56,92,	
56,92,	56,92,	56,92,	56,92,	
0,0,	0,0,	0,0,	0,0,	
0,0,	52,52,	0,0,	0,0,	
0,0,	0,0,	52,52,	0,0,	
0,0,	53,90,	53,90,	58,93,	
58,93,	58,93,	58,93,	58,93,	
58,93,	58,93,	58,93,	58,93,	
58,93,	62,63,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
62,63,	62,63,	62,63,	65,65,	
65,65,	65,65,	65,65,	65,65,	
65,65,	65,65,	65,65,	65,65,	
65,65,	66,66,	66,66,	66,66,	
66,66,	66,66,	66,66,	66,66,	
66,66,	66,66,	66,66,	68,68,	
68,68,	68,68,	68,68,	68,68,	
68,68,	68,68,	68,68,	68,68,	
68,68,	71,85,	0,0,	0,0,	
0,0,	71,85,	73,96,	73,96,	
73,96,	73,96,	73,96,	73,96,	
73,96,	73,96,	73,96,	73,96,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
71,85,	74,97,	74,97,	74,97,	
74,97,	74,97,	74,97,	74,97,	
74,97,	74,97,	74,97,	0,0,	
71,85,	0,0,	71,83,	0,0,	
71,95,	71,95,	71,95,	71,95,	
71,95,	71,95,	71,95,	71,95,	
71,95,	71,95,	71,85,	71,85,	
75,98,	75,98,	75,98,	75,98,	
75,98,	75,98,	75,98,	75,98,	
75,98,	75,98,	76,99,	76,99,	
76,99,	76,99,	76,99,	76,99,	
76,99,	76,99,	76,99,	76,99,	
77,77,	77,77,	77,78,	77,78,	
77,78,	77,78,	77,78,	77,78,	
77,78,	77,78,	78,78,	78,78,	
78,78,	78,78,	78,78,	78,78,	
78,78,	78,78,	78,78,	78,78,	
79,79,	79,79,	79,79,	79,79,	
79,79,	79,79,	79,79,	79,79,	
79,79,	79,79,	80,80,	80,80,	
80,80,	80,80,	80,80,	80,80,	
80,80,	80,80,	80,80,	80,80,	
81,81,	81,81,	81,81,	81,81,	
81,81,	81,81,	81,81,	81,81,	
81,81,	81,81,	82,82,	82,82,	
82,82,	82,82,	82,82,	82,82,	
82,82,	82,82,	82,82,	82,82,	
83,100,	83,100,	83,100,	83,100,	
83,100,	83,100,	83,100,	83,100,	
83,100,	83,100,	87,104,	0,0,	
87,104,	0,0,	0,0,	87,105,	
87,105,	87,105,	87,105,	87,105,	
87,105,	87,105,	87,105,	87,105,	
87,105,	90,108,	0,0,	90,108,	
0,0,	0,0,	90,109,	90,109,	
90,109,	90,109,	90,109,	90,109,	
90,109,	90,109,	90,109,	90,109,	
91,92,	91,92,	91,92,	91,92,	
91,92,	91,92,	91,92,	91,92,	
91,92,	91,92,	94,110,	94,110,	
94,110,	94,110,	94,110,	94,110,	
94,110,	94,110,	94,110,	94,110,	
95,101,	0,0,	95,95,	95,95,	
95,95,	95,95,	95,95,	95,95,	
95,95,	95,95,	95,95,	95,95,	
101,112,	101,112,	101,112,	101,112,	
101,112,	101,112,	101,112,	101,112,	
101,112,	101,112,	95,102,	95,102,	
0,0,	0,0,	0,0,	0,0,	
0,0,	102,114,	0,0,	102,114,	
101,113,	101,113,	102,115,	102,115,	
102,115,	102,115,	102,115,	102,115,	
102,115,	102,115,	102,115,	102,115,	
104,105,	104,105,	104,105,	104,105,	
104,105,	104,105,	104,105,	104,105,	
104,105,	104,105,	95,102,	95,102,	
0,0,	0,0,	0,0,	0,0,	
0,0,	107,117,	0,0,	107,117,	
101,113,	101,113,	107,118,	107,118,	
107,118,	107,118,	107,118,	107,118,	
107,118,	107,118,	107,118,	107,118,	
108,109,	108,109,	108,109,	108,109,	
108,109,	108,109,	108,109,	108,109,	
108,109,	108,109,	110,110,	110,110,	
110,110,	110,110,	110,110,	110,110,	
110,110,	110,110,	110,110,	110,110,	
111,119,	0,0,	111,119,	0,0,	
0,0,	111,120,	111,120,	111,120,	
111,120,	111,120,	111,120,	111,120,	
111,120,	111,120,	111,120,	113,122,	
0,0,	113,122,	0,0,	0,0,	
113,123,	113,123,	113,123,	113,123,	
113,123,	113,123,	113,123,	113,123,	
113,123,	113,123,	114,115,	114,115,	
114,115,	114,115,	114,115,	114,115,	
114,115,	114,115,	114,115,	114,115,	
117,118,	117,118,	117,118,	117,118,	
117,118,	117,118,	117,118,	117,118,	
117,118,	117,118,	119,120,	119,120,	
119,120,	119,120,	119,120,	119,120,	
119,120,	119,120,	119,120,	119,120,	
121,125,	0,0,	121,125,	0,0,	
0,0,	121,126,	121,126,	121,126,	
121,126,	121,126,	121,126,	121,126,	
121,126,	121,126,	121,126,	122,123,	
122,123,	122,123,	122,123,	122,123,	
122,123,	122,123,	122,123,	122,123,	
122,123,	125,126,	125,126,	125,126,	
125,126,	125,126,	125,126,	125,126,	
125,126,	125,126,	125,126,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-43,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+13,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+3,	0,		yyvstop+12,
yycrank+-98,	0,		yyvstop+15,
yycrank+2,	0,		yyvstop+17,
yycrank+2,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+24,
yycrank+11,	0,		yyvstop+27,
yycrank+0,	0,		yyvstop+30,
yycrank+0,	0,		yyvstop+33,
yycrank+120,	0,		yyvstop+36,
yycrank+12,	0,		yyvstop+38,
yycrank+132,	0,		yyvstop+41,
yycrank+156,	0,		yyvstop+44,
yycrank+190,	0,		yyvstop+47,
yycrank+4,	0,		yyvstop+50,
yycrank+5,	0,		yyvstop+53,
yycrank+6,	0,		yyvstop+56,
yycrank+215,	0,		yyvstop+59,
yycrank+225,	0,		yyvstop+61,
yycrank+166,	yysvec+24,	yyvstop+64,
yycrank+244,	yysvec+24,	yyvstop+67,
yycrank+1,	yysvec+24,	yyvstop+70,
yycrank+254,	yysvec+24,	yyvstop+73,
yycrank+0,	yysvec+24,	yyvstop+77,
yycrank+0,	yysvec+24,	yyvstop+81,
yycrank+2,	0,		yyvstop+85,
yycrank+339,	0,		yyvstop+87,
yycrank+305,	0,		yyvstop+90,
yycrank+324,	yysvec+17,	yyvstop+94,
yycrank+351,	yysvec+18,	yyvstop+98,
yycrank+361,	yysvec+19,	yyvstop+102,
yycrank+371,	yysvec+24,	yyvstop+106,
yycrank+393,	yysvec+24,	yyvstop+109,
yycrank+412,	yysvec+24,	yyvstop+112,
yycrank+422,	yysvec+24,	yyvstop+115,
yycrank+0,	yysvec+4,	yyvstop+119,
yycrank+434,	0,		0,	
yycrank+483,	yysvec+42,	yyvstop+121,
yycrank+0,	0,		yyvstop+123,
yycrank+-3,	yysvec+7,	0,	
yycrank+-4,	yysvec+7,	yyvstop+125,
yycrank+5,	0,		0,	
yycrank+0,	0,		yyvstop+127,
yycrank+0,	0,		yyvstop+129,
yycrank+11,	yysvec+15,	yyvstop+131,
yycrank+-501,	0,		0,	
yycrank+-522,	0,		yyvstop+133,
yycrank+525,	0,		yyvstop+135,
yycrank+0,	yysvec+18,	yyvstop+137,
yycrank+0,	yysvec+19,	yyvstop+139,
yycrank+554,	0,		0,	
yycrank+0,	0,		yyvstop+141,
yycrank+579,	0,		0,	
yycrank+0,	0,		yyvstop+143,
yycrank+0,	0,		yyvstop+145,
yycrank+0,	0,		yyvstop+147,
yycrank+589,	0,		0,	
yycrank+0,	yysvec+62,	yyvstop+149,
yycrank+0,	yysvec+24,	yyvstop+151,
yycrank+599,	yysvec+24,	yyvstop+153,
yycrank+609,	yysvec+24,	yyvstop+156,
yycrank+1,	yysvec+24,	yyvstop+159,
yycrank+619,	yysvec+24,	yyvstop+161,
yycrank+0,	0,		yyvstop+164,
yycrank+0,	yysvec+32,	yyvstop+166,
yycrank+668,	0,		yyvstop+168,
yycrank+0,	yysvec+33,	yyvstop+170,
yycrank+634,	0,		0,	
yycrank+653,	0,		0,	
yycrank+680,	0,		0,	
yycrank+690,	0,		0,	
yycrank+700,	yysvec+18,	yyvstop+172,
yycrank+710,	yysvec+19,	yyvstop+175,
yycrank+720,	yysvec+24,	yyvstop+178,
yycrank+730,	yysvec+24,	yyvstop+181,
yycrank+740,	yysvec+24,	yyvstop+184,
yycrank+750,	yysvec+24,	yyvstop+188,
yycrank+760,	0,		0,	
yycrank+29,	yysvec+42,	yyvstop+192,
yycrank+494,	0,		yyvstop+194,
yycrank+7,	0,		0,	
yycrank+775,	0,		0,	
yycrank+-303,	yysvec+51,	0,	
yycrank+51,	yysvec+53,	yyvstop+196,
yycrank+790,	0,		0,	
yycrank+800,	0,		0,	
yycrank+0,	yysvec+91,	yyvstop+199,
yycrank+0,	yysvec+58,	yyvstop+201,
yycrank+810,	yysvec+24,	yyvstop+203,
yycrank+822,	0,		yyvstop+205,
yycrank+0,	yysvec+73,	yyvstop+208,
yycrank+0,	yysvec+74,	yyvstop+210,
yycrank+0,	yysvec+75,	yyvstop+212,
yycrank+0,	yysvec+76,	yyvstop+214,
yycrank+90,	yysvec+83,	yyvstop+216,
yycrank+832,	0,		yyvstop+218,
yycrank+854,	0,		0,	
yycrank+5,	0,		0,	
yycrank+864,	0,		0,	
yycrank+0,	yysvec+104,	yyvstop+220,
yycrank+-498,	yysvec+51,	yyvstop+222,
yycrank+886,	0,		0,	
yycrank+896,	0,		0,	
yycrank+0,	yysvec+108,	yyvstop+224,
yycrank+906,	yysvec+24,	yyvstop+226,
yycrank+921,	0,		0,	
yycrank+126,	yysvec+101,	yyvstop+229,
yycrank+936,	0,		0,	
yycrank+946,	0,		0,	
yycrank+0,	yysvec+114,	yyvstop+232,
yycrank+7,	0,		0,	
yycrank+956,	0,		0,	
yycrank+0,	yysvec+117,	yyvstop+234,
yycrank+966,	0,		0,	
yycrank+0,	yysvec+119,	yyvstop+237,
yycrank+981,	0,		0,	
yycrank+991,	0,		0,	
yycrank+0,	yysvec+122,	yyvstop+239,
yycrank+23,	0,		0,	
yycrank+1001,	0,		0,	
yycrank+0,	yysvec+125,	yyvstop+241,
yycrank+0,	0,		yyvstop+244,
0,	0,	0};
struct yywork *yytop = yycrank+1058;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,011 ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,'*' ,'+' ,011 ,'-' ,01  ,'*' ,
'0' ,'0' ,'2' ,'2' ,'2' ,'2' ,'2' ,'2' ,
'2' ,'2' ,011 ,011 ,'*' ,'*' ,'*' ,01  ,
01  ,01  ,01  ,01  ,'D' ,'D' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,'_' ,
01  ,'_' ,'_' ,'_' ,'d' ,'d' ,'_' ,'_' ,
'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,
'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,'_' ,
'_' ,'_' ,'_' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
