/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/******************************************************************
*
*  File: help.c
* 
*  Purpose: Print help screens.
*/

#include "include.h"

/*******************************************************************
*
*  Function: main_help()
*
*  Purpose:  Help screen for main menu.
*/

/* strings to print 2 per line */
char *help_strings[] = {
"Reporting:",
" C  Run consistency checks.",
" c  Report count of elements.",
" e  Extrapolate.",
" i  Information on status.",
" v  Report volumes.",
" z  Do curvature test.",
"Model characteristics: ",
" A  Set adjustable parameters.",
" a  Toggle area normalization.",
" b  Set body volumes and pressures.",
" f  Set diffusion constant.",
" G  Set gravity.",
" J  Toggle jiggling on every move.",
" k  Set boundary spring constant.",
" M  Toggle linear/quadratic model.",
" m  Toggle fixed motion scale.",
" p  Set ambient pressure.",
" Q  Set quantities.",
" W  Homothety toggle.",
"Surface modification: ",
" g nnn    Go nnn iterations.",
" j  Jiggle once.",
" jj Long jiggle once.",
" K  Skinnny triangle edge divide.",
" l  Subdivide long edges.",
" N  Set target volumes to actual.",
" n  Notch ridges and valleys.",
" O  Pop non-minimal edges.",
" o  Pop non-minimal tangent cones.",
" r  Refine triangulation.",
" t  Remove tiny edges.",
" u  Equiangulate.",
" V  Vertex averaging.",
" w  Weed out small triangles.",
" y  Torus duplication.",
" Z  Zoom in on vertex.",
"Output: ",
" D  Toggle display every iteration.",
" d  Dump surface to datafile.",
" P  Create graphics display file.",
" s  Show triangulation graphically.",

"Miscellaneous: ",
" F   Toggle command logging.",
/* " R  Restore state from binary file",
   " S  Save state to binary file",
   */
" H,h,? This help screen.",
" q,x   Exit."
 };

char *qhelp[]={
"\n",
"QUERIES:\n",
"READ \"filename\"\n",
"SHELL\n",
"LIST TOPINFO\n",
"(LIST | SHOW | REFINE | DELETE) elements [WHERE condition]\n",
"SET elements (FIXED | attribute value) [WHERE condition]\n",
"UNSET elements (FIXED | CONSTRAINT n) [WHERE condition]\n",
"elements: vertices,edges,facets,bodies\n",
"attributes: x,y,z,density,pressure,volume,color,constraint\n",
"colors: black,red,green,blue,cyan,magenta,brown,darkgray,lightgray,\n",
"	lightblue,lightgreen,lightred,lightcyan,lightmagenta,yellow,white\n",
"condition is a logical expression using these terms and operators:\n",
"terms: numbers,id,original,tag,x,y,z,length,area,volume,density,fixed,e,pi,g\n",
"operators: +,-,*,/,^n,**,==,!=,>,<,>=,<=,NOT,!,AND,&&,OR,||\n",
"Query output may be piped to unix commands.\n",
"Examples:\n",
"  list edges | more\n",
"  refine edges where not fixed and length > .23\n",
"  set facet color green where original == 1 or original == 2\n",
"  list vertices where x^2 + y^2 > 1\n",
"  show facets where area < .01\n",
"\n",
 NULL};

void main_help()
{
  int n = sizeof(help_strings)/sizeof(char *);
  int i,j;

#ifndef NOPIPE
  if ( outfd == stdout )
    { outfd = popen("more","w");
      if ( outfd == NULL )
	{ perror("more");
	  outfd = stdout;
	}
    }
#endif

  fprintf(outfd,"\nCommand syntax: \n");
  for ( i = 0, j = (n+1)/2 ; i < (n+1)/2 ; i++,j++ )
    { fprintf(outfd,"%-38.38s ",help_strings[i]);
      if ( j < n )
        fprintf(outfd,"%-38.38s\n",help_strings[j]);
      else fprintf(outfd,"\n");
    }

#ifdef NOPIPE
  fprintf(outfd,"Hit RETURN for more.");
  getstring(msg);
#endif

  for ( i = 0 ; qhelp[i] ; i++ )
    fprintf(outfd,"%s",qhelp[i]);

#ifndef NOPIPE
  if ( outfd != stdout )
    { pclose(outfd);
      outfd = stdout;
    }
#endif
}

/*********************************************************************
*
*  Function: graph_help()
*
*  Purpose:  Display help screen for graphics mode.
*/

char *ghelp_strings[] =
{
"View transformation commands are strings of letters. Each letter ",
"causes an action and may be preceded by a repetition count: ",
" u   Rotate up 6 degrees.",
" d   Rotate down 6 degrees",
" r   Rotate right 6 degrees.",
" l   Rotate left 6 degrees.",
" c   Rotate clockwise 6 degrees.",
" C   Rotate counterclockwise 6 degrees.",
" z   Zoom by factor of 1.2.",
" s   Shrink by factor of 1.2.",
" arrow keys - Translate image.",
" R   Reset viewing parameters.",
" e   Toggle facet edge drawing.",
" B   Toggle display of boundary facets.",
" v   Toggle ridge and valley coloring.",
" b   Draw bounding box.",
" +,- Increment, decrement fill color.",
" H   Toggle hidden surface removal.",
" t   Set clipping mode for torus.",
" ?,h help (this display)",
" x,q Exit to main menu.",
};
                    
void graph_help()
{
  int n = sizeof(ghelp_strings)/sizeof(char *);
  int i;

  for ( i = 0 ; i < n ; i++ )
    fprintf(stderr,"%s\n",ghelp_strings[i]);
}
