.\"
.\" 
.\"           Copyright (c) Digital Equipment Corporation, 1993
.\" 
.\"                          All Rights Reserved
.\" 
.\" Permission to use, copy, modify, and distribute  this software and its
.\" documentation for any  purpose   and without fee  is  hereby  granted,
.\" provided that the above copyright notice appear in all copies and that
.\" both  that  copyright  notice  and  this  permission notice appear  in
.\" supporting documentation, and that the name of Digital  not be used in
.\" advertising or publicity  pertaining to distribution  of the  software
.\" without specific, written prior permission.
.\" 
.\" DIGITAL DISCLAIMS   ALL  WARRANTIES WITH   REGARD   TO  THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT   SHALL  DIGITAL  BE   LIABLE  FOR  ANY SPECIAL,   INDIRECT   OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF CONTRACT, NEGLIGENCE OR
.\" OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\" 
.\"
.\"
.\" HISTORY
.\" $Log: xglinfo.man,v $
.\" Revision 1.1.2.4  1993/06/18  15:02:54  John_Dennis
.\" 	change copyright token to free copyright token
.\" 	[1993/06/18  14:59:37  John_Dennis]
.\"
.\" Revision 1.1.2.3  1993/06/16  21:45:33  John_Dennis
.\" 	correct spelling mistakes
.\" 	[1993/06/16  21:45:03  John_Dennis]
.\" 
.\" Revision 1.1.2.2  1993/06/16  20:33:46  John_Dennis
.\" 	include sample output
.\" 	[1993/06/16  20:13:47  John_Dennis]
.\" 
.\" 	initial version by John Dennis
.\" 	[1993/06/16  15:53:02  John_Dennis]
.\" 
.\" $EndLog$
.\"
.TH XGLINFO 1 "OpenGL Release 1.0"
.SH NAME
xglinfo \- display & visual information utility for OpenGL with the X Window System
.SH SYNOPSIS
.B "xglinfo"
[\-display \fIdisplayname\fP]
[\+\-printDisplayInfo] [\+\-printScreenInfo] [\+\-printVisualInfo]
[\+\-printCookedVisualInfo] [\+\-printRawVisualInfo]

.SH DESCRIPTION
.PP
.I Xglinfo
is a utility for displaying information about an X server supporting the
OpenGL extension, especially with regards to visuals.  It is used to examine
the capabilities of a server, the predefined values for various parameters
used in communicating between clients and the server, and the different types
of screens and visuals that are available. It includes the same set of
information as xdpyinfo, but is extended to display information about OpenGL
visuals as well. In contrast to xdpyinfo the amount and form of information
displayed is controllable by command line arguments.
.PP
The amount of information displayed is controllable by the command line
switches. Many of these switches take either a '+' or a '-'. If the argument is
preceded by a '+' the option is turned on. If the argument is
preceded by a '-' the option is turned off.
.PP
The visual information can be printed in either 'raw' or 'cooked' form. The
cooked form is the default. In the cooked form the visual information is
analyzed and is presented in user friendly form. At the same time some basic
error checks are performed on the combinations of visual data. The raw form
just dumps the values returned for the visual.
.PP
Credit is due to Jim Fulton who wrote the original xdpyinfo while at MIT from
which xglinfo is derived.
.SH EXAMPLE
.PP
The following shows a sample produced by
.I xglinfo
when connected to display that supports an 24 plane screen. Note the error
reporting for the OpenGL visuals. The inconsistent OpenGL visuals were
deliberately set up to illustrate the error checking feature.
.PP
.nf
.in 0
================================= Display :0.0 =================================
name of display:        :0.0
version number:         11.0
vendor string:          DECWINDOWS Digital Equipment Corporation DEC OSF/1 V1.2
vendor release:         1
max request size:       262140 bytes
motion buffer size:     100
bitmap:                 unit = 32, bit order = LSBFirst, padding = 32
image byte order:       LSBFirst
keycode range:          minimum 86, maximum 255
focus:                  PointerRoot
default screen num:     0
number of screens:      1
pixmap formats:         4 total
                        depth  1, bits_per_pixel  1, scanline_pad 32
                        depth  8, bits_per_pixel  8, scanline_pad 32
                        depth 12, bits_per_pixel 16, scanline_pad 32
                        depth 24, bits_per_pixel 32, scanline_pad 32
Server Extensions:      14 total
                        X3D-PEX, GLX, DEC-GLX, SHAPE, MIT-SHM, 
                        Multi-Buffering, MIT-SUNDRY-NONSTANDARD, 
                        Keyboard-Management-Extension, 
                        Shared-Memory Transport, DEC-XTRAP, XVideo, Xie, 
                        Adobe-DPS-Extension, DPSExtension, 
GLX Extension:          error base = 142, event base = 64, Version 1.0
=================================== Screen 0 ===================================
screen:                 0
dimensions:             1280x1024 pixels (342x273 millimeters)
resolution:             95x95 dots per inch
depths:                 (3 total):       1, 8, 24
root window id:         0x2a
depth of root window:   24 planes
number colormaps:       minimum 1, maximum 1
default colormap:       0x28, number colormap cells 256
preallocated pixels:    black 0x0, white 0xffffff
options:                backing-store YES, save-unders YES
input event mask:       0x70003c
                        ButtonPress          ButtonRelease        EnterWindow
                        LeaveWindow          SubstructureRedirect FocusChange
                        PropertyChange       
=================== 7 Visuals for Screen 0 (default = 0x26) ===================
StaticGray visual: ID = 0x21 (hex) 33 (decimal) screen = 0
  GL NOT SUPPORTED
  Core X: depth=8, colormapSize=256 

GrayScale visual: ID = 0x22 (hex) 34 (decimal) screen = 0
  GL NOT SUPPORTED
  Core X: depth=8, colormapSize=256 

StaticColor visual: ID = 0x23 (hex) 35 (decimal) screen = 0
  DOUBLE buffered MONO COLOR INDEX visual with (Z Stencil)
  GL Sizes: ColorIndex=8, Z=24, Stencil=8
  ERROR: CI visual, but Alpha has non-zero size = 8
  Core X: depth=8, colormapSize=256 

PseudoColor visual: ID = 0x24 (hex) 36 (decimal) screen = 0
  DOUBLE buffered MONO COLOR INDEX visual with (Z Stencil)
  GL Sizes: ColorIndex=8, Z=24, Stencil=8
  ERROR: CI visual, but Alpha has non-zero size = 8
  Core X: depth=8, colormapSize=256 

TrueColor visual: ID = 0x25 (hex) 37 (decimal) screen = 0
  DOUBLE buffered MONO RGB visual with (Alpha Z Stencil Accum)
  GL Sizes: RGBA=(3,3,2,8), Z=24, Stencil=8, Accum=(16,16,16,16)
  Core X: depth=8, colormapSize=8 RGB: masks=(0xe0,0x1c,0x3) bits=8

TrueColor visual: ID = 0x26 (hex) 38 (decimal) screen = 0
  DOUBLE buffered MONO RGB visual with (Alpha Z Stencil Accum)
  GL Sizes: RGBA=(8,8,8,8), Z=24, Stencil=8, Accum=(16,16,16,16)
  Core X: depth=24, colormapSize=256 RGB: masks=(0xff0000,0xff00,0xff) bits=8

DirectColor visual: ID = 0x27 (hex) 39 (decimal) screen = 0
  DOUBLE buffered MONO RGB visual with (Alpha Z Stencil Accum)
  GL Sizes: RGBA=(8,8,8,8), Z=24, Stencil=8, Accum=(16,16,16,16)
  Core X: depth=24, colormapSize=256 RGB: masks=(0xff0000,0xff00,0xff) bits=8

.in
.fi

.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get the default host, display number, and screen.
.SH "SEE ALSO"
X(1), xdpyinfo(1), xwininfo(1), xprop(1), xrdb(1)
.SH COPYRIGHT
Copyright 1993, Digital Equipment Corporation
.SH AUTHOR
John Dennis
.br
Digital Equipment Corporation
.br
jdennis@mlo.dec.com
