/*
 * (c) Copyright 1993, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED 
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation, and that 
 * the name of Silicon Graphics, Inc. not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. 
 *
 * THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS"
 * AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL SILICON
 * GRAPHICS, INC.  BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,
 * SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
 * KIND, OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION,
 * LOSS OF PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF
 * THIRD PARTIES, WHETHER OR NOT SILICON GRAPHICS, INC.  HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE
 * POSSESSION, USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * US Government Users Restricted Rights 
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions set forth in FAR 52.227.19(c)(2) or subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software
 * clause at DFARS 252.227-7013 and/or in similar or successor
 * clauses in the FAR or the DOD or NASA FAR Supplement.
 * Unpublished-- rights reserved under the copyright laws of the
 * United States.  Contractor/manufacturer is Silicon Graphics,
 * Inc., 2011 N.  Shoreline Blvd., Mountain View, CA 94039-7311.
 *
 * OpenGL(TM) is a trademark of Silicon Graphics, Inc.
 */

/*****************************************************************************
 * pdb - routines for maintaining a database of performance information
 *****************************************************************************/



#ifndef __PDB_H__
#define __PDB_H__
#ifdef __cplusplus
extern "C" {
#endif



typedef void (*pdbCallbackT)();

typedef int pdbStatusT;
#define PDB_NO_ERROR		0x0000
#define PDB_OUT_OF_MEMORY	0x0001	/* malloc failed */
#define PDB_SYNTAX_ERROR	0x0002	/* syntax error in database file */
#define PDB_NOT_FOUND		0x0004	/* no such benchmark in database */
#define PDB_CANT_WRITE		0x0008	/* can't update database file */
#define PDB_NOT_OPEN		0x0010	/* database not yet open */
#define PDB_ALREADY_OPEN	0x0020	/* database already open */



extern pdbStatusT pdbClose	(void);
extern pdbStatusT pdbMeasureRate(pdbCallbackT initialize,
				 pdbCallbackT operation,
				 pdbCallbackT finalize,
				 double* rate);
extern pdbStatusT pdbOpen	(void);
extern pdbStatusT pdbReadRate	(const char* machineName,
				 const char* applicationName,
				 const char* benchmarkName,
				 double* rate);
extern pdbStatusT pdbWriteRate	(const char* machineName,
				 const char* applicationName,
				 const char* benchmarkName,
				 const double rate);



#ifdef __cplusplus
}
#endif
#endif /* !__PDB_H__ */


