/****************************************************************************
 * matrix_ops.h
 * Author Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* These entry points are provided by the matrix_ops module */

#define PI 3.14159265
#define DegtoRad PI/180.0 
#define RadtoDeg 180.0/PI

extern Transformation matrix_mult();
extern float *matrix_mult_c();
extern Transformation Make_Translate();
extern float *make_translate_c();
extern Transformation Make_Scale();
extern float *make_scale_c();
extern Transformation Make_Rotate();
extern float *make_rotate_c();
extern Transformation Make_Identity();
extern float *matrix_vector_c();
extern float *transpose();
extern float *make_aligning_rotation();
