/****************************************************************************
 *                                                                          *
 *	painter_vars.h                                                       *
 *      Copyright 1989, Pittsburgh Supercomputing Center                    *
 *                      All Rights Reserved                                 *
 *			Author Chris Nuuja                                  *
 *                                                                          *
 ****************************************************************************/

/*  This file contains the global variables used by painter for rendering */
#include "paintr_strct.h"

/* Hash table size */
#define HASHSIZE 4099 /* a prime number */
#define BAD_HASH_LOOKUP -9
#define BAD_HASH_ADD -9
typedef int Hash_result;


typedef struct hash_cell_struct {
	int val;
	Hash_result result;
	struct hash_cell_struct *next, *last;
	} Hash_cell;

extern Hash_cell **hashtable;  /* hashtable to map primitive id's to objects */

/*   Lighting variables    */
extern ren_pointtype  *LightPosBuffer,*OldLightBuffer;
extern ren_colortype *LightColorBuffer;
extern int LightCount;
extern int MaxLightCount;
extern int AmbientColor;

/*  Variables used for Clipping the hither and yon planes   */
extern float Zmin, Zmax;

/*   Global rendering flags relating to the polygon currently being drawn  */
extern int Current_Color;  /* current polygon's color  */
extern int BackCullable;   /* set to 1 if current polygon is back-cullable */
extern float TextHeight;   /* Height, in pixels, of text 		   */
extern int HIDDEN_SURF;    /* set to 1 if total scene is not wireframe     */

/*  Transformation Matricies   */
extern float *Identity;	     /* the identity tranform   */
extern float *ObjectTrans;   /* the current polygon's world-coordinate trans */
extern float *EyetoImage;    /* defines the 3d-to-2d-perspective transform */
extern float *ViewMatrix;    /* defines the world-to-camera-view transform */

/* Primitive table and fill-pointer */
extern ren_objecttype *PrimTable;      /* the table itself      */
extern ren_objecttype *Prim_FillPtr;   /* the fill pointer      */
extern int PrimTableSize;              /* the size of the table */


extern ren_objecttype *ObjectBuffer;
extern int MaxObjects, ObjectCount;

/* Polygon z-sorted table and fill index */
extern depthtable_rec *DepthBuffer;       /* the table itself	*/
extern int DepthCount;		       /* current fill index    */



extern ren_polytype *PolyBuffer,*DPolyBuffer;
extern int PolyCount,DepthPolyCount;
extern int MaxPolyCount,MaxDepthPoly;	       /* the size of the table */

extern ren_colortype  *ColorBuffer,*DColorBuffer;
extern int ColorCount,DColorCount;
extern int MaxColorCount,MaxDColorCount;

extern float *CoordBuffer,*DCoordBuffer;
extern int CoordBuffIndex,DCoordIndex;
extern int MaxCoordIndex,MaxDCoordIndex; 


/*  Global default values   */
extern int White,Black,Background;
extern float Default_TextHeight;

/*  Global string holding the name of device to be used  */
extern char *DeviceName;


extern float *Xcoord_buffer, *Ycoord_buffer, *Zcoord_buffer;
extern float *Xclip_buffer, *Yclip_buffer, *Zclip_buffer;

/*   clipping defs     */
#define HITHER_PLANE 0
#define YON_PLANE 1
