/**************************************************************************** * key.c
 * Author Frank Wu
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#include <stdio.h>
#include "alisp_node.h"
#include "parse.h"

/*an info table of all standard LISP primitives*/

/*an info table of all standard LISP keywords*/

KEY_DATA key_table[] = {
    {"bogus",K_NORMAL},
    {"&key", K_KEY},
    {"&rest", K_REST},
    {"*",K_MUL},
    {"+",K_ADD},
    {"-",K_SUB},
    {"/",K_DIV},
    {"<",K_LESS},
    {">",K_GREATER},
    {"add",K_ADD},
    {"and",K_AND},
    {"append",K_APPEND},
    {"apply",K_APPLY},
    {"aref",K_AREF},
    {"arrayp",K_ARRAYP},
    {"assoc",K_ASSOC},
    {"atomp",K_ATOMP},
    {"boundp",K_BOUNDP},
    {"caaar",K_CAAAR},
    {"caadr",K_CAADR},
    {"caar",K_CAAR},
    {"cadar",K_CADAR},
    {"caddr",K_CADDR},
    {"cadr",K_CADR},
    {"car",K_CAR},
    {"cdaar",K_CDAAR},
    {"cdadr",K_CDADR},
    {"cdar",K_CDAR},
    {"cddar",K_CDDAR},
    {"cdddr",K_CDDDR},
    {"cddr",K_CDDR},
    {"cdr",K_CDR},
    {"cond",K_COND},
    {"cons",K_CONS},
    {"consp",K_CONSP},
    {"defstruct",K_DEFSTRUCT},
    {"defun",K_DEFUN},
    {"do",K_DO},
    {"do*",K_DOSTAR},
    {"eq",K_EQ},
    {"eval",K_EVAL},
    {"fboundp",K_FBOUNDP},
    {"fixp",K_FIXP},
    {"floatp",K_FLOATP},
    {"if",K_IF},
    {"lambda",K_LAMBDA},
    {"let",K_LET},
    {"let*",K_LETSTAR},
    {"list",K_LIST},
    {"listp",K_LISTP},
    {"load",K_LOAD},
    {"make-array",K_MARRAY},
    {"mapcar",K_MAPCAR},
    {"nil",K_NIL},
    {"not",K_NOT},
    {"null",K_NULL},
    {"or",K_OR},
    {"pprint",K_PPRINT},
    {"progn",K_PROGN},
    {"quit",K_QUIT},
    {"quote",K_QUOTE},
    {"rplaca",K_RPLCA},
    {"rplacd",K_RPLCD},
    {"setf",K_SETF},
    {"setq",K_SETQ},
    {"symbolp",K_SYMBOLP},
    {"t",K_TRUE},
    {"true",K_TRUE}

};

/*FUNCTION -- check_key()
 *this function executes a binary search in the key_word_table
 *with the global string "token".  If "token" is a keyword, it
 *will be assign to be a "key_tk".*/

/*WHEN USED?
 *check_key() is called by parse_stream()*/

/*WHAT's RETURNED?
 *When "token" exists in table (ie found) the enum type associated
 *associated with that keyword is returned.  Otherwise a "K_NOOP" is
 *returned to indicate that the token is not a keyword*/
 
check_key()
{
    short low = 1, high = 68, mid;
    int compare;
   
    while(low < high){
	mid = (low + high)/2;
	compare = strcmp(token,getkeyword(mid));
	if(compare < 0)
	    high = mid;
	else 
	    if(compare > 0)
		low = mid + 1;
	    else {
		return(mid);
	    }
    }
    return(0);
}
int	store;

