/****************************************************************************
 * movietop3d.c
 * Author Julie Roskies and Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#include <stdio.h>
#include "struct_defs.h"
#include "fill_defs.h"
#include "err_defs.h"
#include "emit_defs.h"
#include "color_defs.h"
#include "part_defs.h"
#include "disp_defs.h"

#ifdef VMS
#include <string.h>
#include climsgdef
#include descrip

int my_present(in_string)
char *in_string;
{
int  ret=0;

struct dsc$descriptor_s name_desc;
name_desc.dsc$w_length = strlen(in_string);  
name_desc.dsc$a_pointer = in_string;         
name_desc.dsc$b_class = DSC$K_CLASS_S;       
name_desc.dsc$b_dtype = DSC$K_DTYPE_T;       
ret = CLI$PRESENT(&name_desc);  
return(ret);
}

char *my_string(in_string)
char *in_string;
{
#define c_length 128

char *out_string = (char *)malloc(c_length);
struct dsc$descriptor_s name_desc, out_desc;
short str_l;
int  ret, ret_value, i;

for (i=0; i<c_length; ++i) out_string[i] = ' ';
name_desc.dsc$w_length = strlen(in_string);    
name_desc.dsc$a_pointer = in_string;         
name_desc.dsc$b_class = DSC$K_CLASS_S;       
name_desc.dsc$b_dtype = DSC$K_DTYPE_T;         

out_desc.dsc$w_length = c_length;    
out_desc.dsc$a_pointer = out_string;         
out_desc.dsc$b_class = DSC$K_CLASS_S;       
out_desc.dsc$b_dtype = DSC$K_DTYPE_T;    

ret = CLI$GET_VALUE(&name_desc, &out_desc, &str_l);
out_string[str_l] = '\0';

return(out_string);
}

FILE *outfile;		/* output will be written here */

main(argc, argv)
int argc; 
char *argv[];
{
	
	FILE *fsetup();   /* safely opens input file, returns pointer */
	FILE *movie_data; /* will point to file of MOVIE.BYU data */     
	FILE *part_col_data;   /* will point to file of part color info, if it exists */
	FILE *c_table_data; 	/* will point to c_table file */
	FILE *displace_data;	/* will point to displacement data file */
	FILE *scalar_data;	/* will point to scalar file */

	char *fsetuptemp; 	/* holds filenames to pass to fsetup */
	Model *thismodel;
	int c, part_colq = 0, c_tableq = 0, displaceq = 0, scalarq = 0; 
	int loq = 0, hiq = 0;	/* will be used in parsing argv */ 	

	float scale = 1.0;
	float loscale, hiscale;

	ger_init("movietop3d");

	ger_debug("movietop3d:");

	/* VMS parsing of command line */
	if(my_present("parts") & 1) {
		fsetuptemp = my_string("parts");
	      	part_col_data = fsetup (fsetuptemp, "r");
	      	part_colq = 1;
	      	};
	if (my_present("c_table") & 1) {
		fsetuptemp = my_string("c_table");
	      	c_table_data = fsetup (fsetuptemp, "r");
	      	c_tableq= 1;
	      	};
	if (my_present("displace") & 1) {
		fsetuptemp = my_string("displace");
	      	displace_data = fsetup (fsetuptemp, "r");
	      	displaceq= 1;
	      	};
	if (my_present("disp_mult") & 1) {
		sscanf(my_string("disp_mult"), "%f", &scale);
		};
	if (my_present("scalar") & 1) {
		fsetuptemp = my_string("scalar");
	      	scalar_data = fsetup(fsetuptemp, "r");
	      	scalarq = 1;
	      	sscanf(my_string("min"), "%f", &loscale);
	      	loq= 1;
	      	sscanf(my_string("max"), "%f", &hiscale);
	      	hiq= 1;
	      	};
	if (my_present("output") & 1) {
		fsetuptemp = my_string("output");
	      	outfile = fsetup (fsetuptemp, "w");
	      	}
	else outfile = stdout;
		                                 
	
	/* Setting up the main movie geometry file */	
	fsetuptemp = my_string("movie_geo");
	movie_data= fsetup(fsetuptemp, "r");         

#else
FILE *outfile;		/* output will be written here */

main(argc, argv)
int argc; 
char *argv[];
{
	
	FILE *fsetup();   /* safely opens input file, returns pointer */
	FILE *movie_data; /* will point to file of MOVIE.BYU data */     
	FILE *part_col_data;   /* will point to file of part color info, if it exists */
	FILE *c_table_data; 	/* will point to c_table file */
	FILE *displace_data;	/* will point to displacement data file */
	FILE *scalar_data;	/* will point to scalar file */

	Model *thismodel;
	int c, part_colq = 0, c_tableq = 0, displaceq = 0, scalarq = 0, loq = 0, hiq = 0;	/* will be used in parsing argv */ 	
	float scale = 1.0;
	float loscale, hiscale;

	ger_init("movietop3d");

	ger_debug("movietop3d:");

	if (argc == 1) {
	fprintf(stderr, "\nusage: movietop3d [-p parts] [-d displacements] [-m disp_mult] \n\
 	          [-c c_table] [-s scalar min max] model.geo\n\n\
		parts - color information for model parts\n\
      		displacements - displacement data file\n\
		disp_mult - number by which to multiply displacements\n\
      		c_table - color table file\n\
     		scalar - scalar data file\n\
		min max - lowest and highest scalar used, separated by a space\n\
		model.geo - model geometry data in MOVIE.BYU format\n");
        exit(0); }
           
	while (--argc > 0 && (*++argv)[0] == '-' && strlen(*argv) == 2) {
		c = *++argv[0];
		switch (c) {
		case 'p':
 			part_col_data = fsetup (*++argv, "r");
	     		part_colq = 1;
     			break;
		case 'c':
 			c_table_data = fsetup (*++argv, "r");
	     		c_tableq= 1;
			break;
	        case 'm':
 			sscanf(*++argv, "%f", &scale);
     			break;
		case 'd':
 			displace_data = fsetup (*++argv, "r");
	     		displaceq = 1;
     			break;
	       	case 's':
 			scalar_data = fsetup (*++argv, "r");
	     		scalarq = 1;
     	      		if (sscanf(*++argv, "%f", &loscale))
			{
			loq= 1;
			if (sscanf(*++argv, "%f", &hiscale))
			    hiq= 1;
			};
			if (loq != 1 || hiq != 1)
			    ger_fatal(
				"movietop3d: illegal scalar range in command line");
	     		break;
	 	default:
 			ger_fatal(
	               	    "movietop3d: illegal option %c\n", c);
		}
	}

	/* sets up movie_data to point to last argument on command line or
	   to stdin if last argument is just a dash */

	if (strlen(*argv) == 1 && **argv == '-')
		movie_data= stdin;
	else
		movie_data= fsetup(*argv, "r");

	/* makes output go to stdout */
	outfile = stdout;

#endif
                                                     
	/* Sets thismodel to point to model created from data */
	thismodel = fillstruct(movie_data);

	/* Prints some basic information to stderr */
	fprintf(stderr, "\nmodel emitted with:\n%ld vertices\n%ld facets\n%d parts\n",
		thismodel->vertex_count, thismodel->facet_count,
		thismodel->part_count);

	/* Fill in part color info, if data exists */
	if (part_colq == 1)
		fill_part_color(part_col_data, thismodel);

	/* Fill in part displacement info, if data exists */
	if (displaceq == 1) {
		thismodel->displace_scale = scale;
		add_displace(displace_data, thismodel);
		};

	/* Fill in the color table for use by the scalars */
	if (c_tableq == 1) {
		add_c_table(c_table_data, thismodel);
		if (scalarq != 1)
		    fprintf(stderr, "\n No scalar data given, c_table will not be used\n");
		};

	/* Fill in the color of vertices, using scalars */
	if (scalarq == 1)
	    if (c_tableq != 1)
		fprintf(stderr, "\nNo c_table given, scalars have no meaning\n");
	    else 
	       	    add_vertex_color(scalar_data, thismodel, loscale, hiscale);
	       
	/* Emits the p3d code for this model */
	emit_p3d_model ( thismodel );
}

FILE *fsetup(fname, fmode)
char fname[]; 
char fmode[];
/* fsetup safely opens a file and returns its pointer. */
{
	FILE *fp;

	if (fmode[0] == 'w' )
		{
		if (strcmp(fname,"-") == 0) fp = stdout;
		else fp= fopen(fname, fmode);
		if ( fp == NULL )
			ger_fatal("Error opening %s", fname);  
		}
	else if ( (fp = fopen(fname, fmode)) == NULL )               
		ger_fatal("Error opening %s", fname);
	return (fp);
}
