Flying User Interface
----------------------

File: rui.c

Works with renderers: any

Interaction: by keyboard strokes

Required Hooks: none

Light support: full

Camera support: full

Model support: full

Auxiliary routines:

Comments:
	This user interface provides a generic way for a user at a simple
	terminal to manipulate the rendering of a model.  At each
	call to ui_traverselights or ui_camera, the information is
	cached as well as passed on to the renderer.  When ui_render
	is called, the following occurs:

	1)  The object is rendered as described with the existing lighting
	    and camera information.

	2)  Initial position and velocity information is generated for
	    an 'rocket' flying through the world coordinate system
	    of the model.

	3)  The user is given the opportunity to advance the rocket along
	    its path, roll or rotate the rocket (causing turns), apply 
	    thrust, start a trace of plane positions (which may later be 
            used to construct a movie of the flight), load new plane 
            coordinates, move on to the next P3D rendering instruction, 
            exit, or ask for help.  The user interface may return or the 
            application may exit as a result of this.

	4)  If the plane has moved, the model is rerendered.

	5)  Loop back to (3) above.

	The net result is that a view of the model gets rendered, and the
	user is asked for input.  As long as the user continues flying
	around the given model, the model is repeatedly rerendered from
	the new positions.  When the user asks to quit examining the 
        current model, the next P3D model is rendered in the same way.

	The following hints may be of help when flying around the model.
	The rocket experiences no linear or angular drag, so once it is
	started moving or rotating it will continue to do so.  If thrust
	is applied (via the 't' command), it stays on and the rocket will
	continue to accelerate until the 'b' command is used to apply
	braking thrust.  Rotational thrust is instantaneous only,
	however.  Applying the 'u', 'd', 'l', 'r', 'c' or 'a' commands
	will start the rocket rotating in the given direction, but the
	rotation rate will be constant rather than accelerating.  To
	stop rotation, apply a rotation command in the direction opposite
	to the direction of rotation.  The rocket is constrained to
	move in the direction it is pointing, as if it had fins like
	a dart, so to turn the flight path simply turn the nose of the
	rocket appropriately.  (I know that's not physically reasonable,
	but it makes the rocket much easier to control).

	To begin tracing your flight path, type 'T'.  This will cause
	a file named rui_trace.dat to be created which contains (in 
	readable ascii) a block of data for each step of your flight
	after the 'T' command is given.  You can move to any point in
	the flight recorded in an existing trace file by using the 'L'
	command and responding appropriately as you are prompted for
	dynamical information about the point in question.  Moving on
	to a new rendering command in the P3D metafile does not turn
	off tracing, so be careful not to proceed to a new model in
	the metafile if you have enabled tracing.

	The performance of the rocket is controlled by C language 
	'#define' statements at the top of rui.c .

Bugs:
	There is currently no way to rotate the rocket by very small angles.



	
	





