Flying User Interface
----------------------

File: fui.c

Works with renderers: any

Interaction: by keyboard strokes

Required Hooks: none

Light support: full

Camera support: full

Model support: full

Auxiliary routines:

Comments:
	This user interface provides a generic way for a user at a simple
	terminal to manipulate the rendering of a model.  At each
	call to ui_traverselights or ui_camera, the information is
	cached as well as passed on to the renderer.  When ui_render
	is called, the following occurs:

	1)  The object is rendered as described with the existing lighting
	    and camera information.

	2)  Initial position and velocity information is generated for
	    an 'airplane' flying through the world coordinate system
	    of the model.

	3)  The user is given the opportunity to advance the plane along
	    its path, roll the plane (causing turns), pitch the plane's
	    nose up and down, apply thrust, start a trace of plane positions
	    (which may later be used to construct a movie of the flight),
	    load new plane coordinates, move on to the next P3D rendering
	    instruction, exit, or ask for help.  The user interface may 
	    return or the application may exit as a result of this.
	    Note that roll angle changes are cumulative, while pitch
	    angle changes are absolute.  For example, the keystroke
	    sequence 'rrrr' is equivalent to '4r' (except that the plane
	    will have moved in the interim), while the sequence '5u3d'
	    is equivalent to '3d'.

	4)  If the plane has moved, the model is rerendered.

	5)  Loop back to (3) above.

	The net result is that a view of the model gets rendered, and the
	user is asked for input.  As long as the user continues flying
	around the given model, the model is repeatedly rerendered from
	the new positions.  When the user asks to quit examining the 
        current model, the next P3D model is rendered in the same way.

	The following hints may be of help when flying around the model.
	The plane (like a real plane) is in a state of dynamic equilibrium
	as it flies.  The forces on it depend on its velocity, pointing
	direction, and angle of roll.  To turn right or left, bank the
	plane in the desired direction.  If you wish to accelerate, you
	must point the nose down in addition to applying thrust;  if you
	just apply thrust the plane will gain altitude but keep a constant
	speed.  To lose altitude, either point the nose down and leave
	the thrust constant or decrease thrust.  Don't be afraid to reduce
	thrust, even to negative values;  your speed will remain fairly
	constant as you lose altitude and liberation of potential energy 
	makes up for the decrease in thrust.

	To begin tracing your flight path, type 'T'.  This will cause
	a file named fui_trace.dat to be created which contains (in 
	readable ascii) a block of data for each step of your flight
	after the 'T' command is given.  You can move to any point in
	the flight recorded in an existing trace file by using the 'L'
	command and responding appropriately as you are prompted for
	dynamical information about the point in question.  Moving on
	to a new rendering command in the P3D metafile does not turn
	off tracing, so be careful not to proceed to a new model in
	the metafile if you have enabled tracing.

	The performance of the plane and physical parameters like gravity
	are controlled by C language '#define' statements at the top
	of fui.c .

Bugs:
	There is currently no way to rotate the plane by less than 1 degree.

	The plane has a rather unrealistically high lift-to-drag ratio,
	and the scaling laws used in calculating forces may be inappropriate.


	
	





