
      program t_bigbuf

C
C Program to test d8gimg when buffers are larger than image
C
C Input file:  h200x150.hdf (in "files" directory)
C Output file: new.hdf
C

C****||************************************************************
      integer d8gdims, d8gimg
      integer width, height, ispal, ret
      integer bufwidth, bufheight

      character*1 image(500,400)
      character*1 newimage(200,150)
      character*1 pal(768)

      parameter (bufwidth  = 500,
     *           bufheight = 400)

C****||**** read in image into "too large" array ******************
      print *,'1'
      ret = d8gdims('h200x150.hdf', width, height, ispal)
      if ( ret .lt. 0) print *, 'Error opening file h200x150.hdf.'
      ret = d8gimg('h200x150.hdf', image,bufwidth,bufheight,pal)
      print *, 'width=',width,'   height=',height

C****||**** copy image to an array that is the "right size" *******
      do 100 i=1,200
          do 100 j=1,150
              newimage(i,j) = image(i,j)
  100 continue

C****||*** write newimage to different file -- should be the same ***
      ret = d8pimg('new.hdf', newimage, width, height, ispal)

      stop
      end


