/* SCCS @(#)proreggrarex.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      proreggrarex.layout.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   proreggrarex.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   Region growing parameters                           */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "proreggrarex.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_region_extraction_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_region_extraction_param_widget(PRO_regions_extraction_param)
	Widget PRO_regions_extraction_param;
{
	Widget PRO_region_extraction_param_widget;
	Widget node_number;
	Widget nb_of_pixel;
	Widget Nb_of_neighbours;
	Widget error_on_properties;
	Widget node_number_text;
	Widget Nb_of_pixel_text;
	Widget error_text;
	Widget Nb_of_neighbours_text;
	xs_struc_paramprepro *Paramprepro;
	Widget PRO_region_extraction_param_Label_0;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_region_extraction_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,256); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,185); n++;
	XtSetArg(args[n],XmNx,27); n++;
	XtSetArg(args[n],XmNy,19); n++;

	PRO_region_extraction_param_widget = 
	   XmCreateForm(PRO_regions_extraction_param,
			"PRO_region_extraction_param_widget",args,n);
	XtManageChild(PRO_region_extraction_param_widget);

	Paramprepro->parent = PRO_region_extraction_param_widget;

	/* Creating node_number Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[461],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,25); n++;

	node_number = XmCreateLabel(PRO_region_extraction_param_widget,
				    "node_number",args,n);
	XtManageChild(node_number);

	/* Creating nb_of_pixel Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[462],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,42); n++;

	nb_of_pixel = XmCreateLabel(PRO_region_extraction_param_widget,
				    "nb_of_pixel",args,n);
	XtManageChild(nb_of_pixel);

	/* Creating Nb_of_neighbours Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[463],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,59); n++;

	Nb_of_neighbours = XmCreateLabel(PRO_region_extraction_param_widget,
					 "Nb_of_neighbours",args,n);
	XtManageChild(Nb_of_neighbours);

	/* Creating error_on_properties Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[464],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,76); n++;

	error_on_properties = 
	   XmCreateLabel(PRO_region_extraction_param_widget,
			 "error_on_properties",args,n);
	XtManageChild(error_on_properties);

	/* Creating node_number_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,node_number); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,25); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	node_number_text = XmCreateText(PRO_region_extraction_param_widget,
					"node_number_text",args,n);
	XtManageChild(node_number_text);

	Paramprepro->line = node_number_text;

	/* Creating Nb_of_pixel_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,nb_of_pixel); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,42); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Nb_of_pixel_text = XmCreateText(PRO_region_extraction_param_widget,
					"Nb_of_pixel_text",args,n);
	XtManageChild(Nb_of_pixel_text);

	Paramprepro->colon = Nb_of_pixel_text;

	/* Creating error_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,error_on_properties); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,76); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	error_text = XmCreateText(PRO_region_extraction_param_widget,
				  "error_text",args,n);
	XtManageChild(error_text);

	Paramprepro->alpha = error_text;

	/* Creating Nb_of_neighbours_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Nb_of_neighbours); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,59); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Nb_of_neighbours_text = 
	    XmCreateText(PRO_region_extraction_param_widget,
			 "Nb_of_neighbours_text",args,n);
	XtManageChild(Nb_of_neighbours_text);

	Paramprepro->diameter = Nb_of_neighbours_text;

	/* Creating PRO_region_extraction_param_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[266],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	PRO_region_extraction_param_Label_0 = 
	   XmCreateLabel(PRO_region_extraction_param_widget,
			 "PRO_region_extraction_param_Label_0",args,n);
	XtManageChild(PRO_region_extraction_param_Label_0);

	return(Paramprepro);
}
