/* SCCS @(#)progsmsphere.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       progsmsphere.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   progsmsphere.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   Processing Gray Scale Morphology                    */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "progsmsphere.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_gsm_sphere 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_gsm_sphere(progsmsphere)
	Widget progsmsphere;
{
	Widget PRO_gsm_sphere;
	Widget Radius_text;
	Widget PRO_sphere;
	Widget min_label;
	Widget Label_2;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_gsm_sphere Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,233); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,214); n++;
	XtSetArg(args[n],XmNx,16); n++;
	XtSetArg(args[n],XmNy,5); n++;

	PRO_gsm_sphere = XmCreateForm(progsmsphere,"PRO_gsm_sphere",args,n);
	XtManageChild(PRO_gsm_sphere);

	Paramprepro->parent = PRO_gsm_sphere;

	/* Creating Radius_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,15); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,53); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNvalue, "2"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Radius_text = XmCreateText(PRO_gsm_sphere,"Radius_text",args,n);
	XtManageChild(Radius_text);

	Paramprepro->alpha = Radius_text;

	/* Creating PRO_sphere Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[222],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PRO_sphere = XmCreateLabel(PRO_gsm_sphere,"PRO_sphere",args,n);
	XtManageChild(PRO_sphere);

	/* Creating min_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,13); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	min_label = XmCreateLabel(PRO_gsm_sphere,"min_label",args,n);
	XtManageChild(min_label);

	/* Creating Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[216],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	Label_2 = XmCreateLabel(PRO_gsm_sphere,"Label_2",args,n);
	XtManageChild(Label_2);

	return(Paramprepro);
}
